/*
 * Decompiled with CFR 0.152.
 */
package appeng.proxy.helpers;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.me.util.IMEInventory;
import appeng.util.AEItemStack;
import appeng.util.ItemList;
import appeng.util.Platform;
import net.mcft.copy.betterstorage.api.ICrateStorage;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;

public class BSCrate
implements IMEInventory {
    ICrateStorage cs;
    ForgeDirection side;

    public BSCrate(Object object, ForgeDirection d) {
        this.cs = (ICrateStorage)object;
        this.side = d;
    }

    @Override
    public long storedItemTypes() {
        return this.getAvailableItems().size();
    }

    @Override
    public long storedItemCount() {
        long t = 0L;
        for (IAEItemStack is : this.getAvailableItems()) {
            t += is.getStackSize();
        }
        return t;
    }

    @Override
    public long remainingItemCount() {
        return 0L;
    }

    @Override
    public long remainingItemTypes() {
        return 0L;
    }

    @Override
    public long getTotalItemTypes() {
        return 0L;
    }

    @Override
    public boolean containsItemType(IAEItemStack i) {
        return this.cs.getItemCount(this.side, Platform.getSharedItemStack(i)) > 0;
    }

    @Override
    public long countOfItemType(IAEItemStack i) {
        return this.cs.getItemCount(this.side, Platform.getSharedItemStack(i));
    }

    @Override
    public IAEItemStack addItems(IAEItemStack input) {
        ItemStack failed = this.cs.insertItems(this.side, input.getItemStack());
        if (failed == null) {
            return null;
        }
        input.setStackSize(failed.field_77994_a);
        return input;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request) {
        ItemStack Obtained = this.cs.extractItems(this.side, request.getItemStack());
        return AEItemStack.create(Obtained);
    }

    @Override
    public IItemList getAvailableItems(IItemList out) {
        for (ItemStack is : this.cs.getContents(this.side)) {
            out.add(AEItemStack.create(is));
        }
        return out;
    }

    @Override
    public IItemList getAvailableItems() {
        return this.getAvailableItems(new ItemList());
    }

    @Override
    public IAEItemStack calculateItemAddition(IAEItemStack stack) {
        int room = this.cs.spaceForItem(this.side, stack.getItemStack());
        if (stack.getStackSize() <= (long)room) {
            return stack.copy();
        }
        IAEItemStack as = stack.copy();
        as.setStackSize(stack.getStackSize() - (long)room);
        return as;
    }

    @Override
    public long getAvailableSpaceByItem(IAEItemStack i, long maxNeeded) {
        int room = this.cs.spaceForItem(this.side, i.getItemStack());
        return room;
    }
}

