/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.me.tiles.IFulllyOptionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.util.IGridInterface;
import appeng.common.AppEngTextureRegistry;
import appeng.common.network.IAppEngNetworkTile;
import appeng.me.basetiles.TileME;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.SpatialPylonCalculator;
import appeng.me.cluster.implementations.SpatialPylonCluster;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileSpatialPylon
extends TileME
implements IGridMachine,
IAppEngNetworkTile,
IAEMultiBlock,
IFulllyOptionalMETile {
    final int DISPLAY_ENDMIN = 1;
    final int DISPLAY_ENDMAX = 2;
    final int DISPLAY_MIDDLE = 3;
    final int DISPLAY_X = 4;
    final int DISPLAY_Y = 8;
    final int DISPLAY_Z = 12;
    final int MB_STATUS = 15;
    final int DISPLAY_ENABLED = 16;
    final int DISPLAY_POWEREDENABLED = 32;
    final int NET_STATUS = 48;
    byte displayBits = 0;
    SpatialPylonCluster clust;
    SpatialPylonCalculator calc = new SpatialPylonCalculator(this);
    boolean didHaveLight = false;
    ForgeDirection ori = ForgeDirection.UNKNOWN;
    int textureOffset = 0;

    @Override
    public boolean requiresTickingUpdates() {
        return false;
    }

    @Override
    public void markForUpdate() {
        boolean hasLight;
        super.markForUpdate();
        boolean bl = hasLight = this.getLightValue() > 0;
        if (hasLight != this.didHaveLight) {
            this.didHaveLight = hasLight;
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    protected void terminate() {
        super.terminate();
        this.disconnect();
    }

    @Override
    public void onNeighborBlockChange() {
        this.calc.calculateMultiblock((IBlockAccess)this.field_70331_k, this.getLocation());
    }

    @Override
    public void setPowerStatus(boolean _hasPower) {
        super.setPowerStatus(_hasPower);
        byte oldDisplayBits = this.displayBits;
        this.displayBits = (byte)(this.displayBits & 0xFFFFFFDF | (_hasPower ? 32 : 0));
        if (this.displayBits != oldDisplayBits) {
            this.markForUpdate();
        }
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection dir) {
        if (this.ori.equals((Object)dir) || this.ori.getOpposite().equals((Object)dir)) {
            return AppEngTextureRegistry.Blocks.BlockSpatialPylon[this.textureOffset].get();
        }
        if ((this.displayBits & 3) == 3) {
            return AppEngTextureRegistry.Blocks.BlockSpatialPylonC[this.textureOffset].get();
        }
        if ((this.displayBits & 3) == 1) {
            return AppEngTextureRegistry.Blocks.BlockSpatialPylonE[this.textureOffset].get();
        }
        if ((this.displayBits & 3) == 2) {
            return AppEngTextureRegistry.Blocks.BlockSpatialPylonE[this.textureOffset].get();
        }
        return AppEngTextureRegistry.Blocks.BlockSpatialPylon[this.textureOffset].get();
    }

    @Override
    public void disconnect() {
        if (this.clust != null) {
            this.clust.destroy();
            this.clust = null;
            MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.field_70331_k, this.getLocation()));
            this.recalculateDisplay();
        }
    }

    @Override
    public IAECluster getCluster() {
        return this.clust;
    }

    private void recalculateDisplay() {
        byte oldBits = this.displayBits;
        this.displayBits = 0;
        if (this.clust != null) {
            this.displayBits = this.clust.min.equals(this.getLocation()) ? (byte)1 : (this.clust.max.equals(this.getLocation()) ? (byte)2 : (byte)3);
            switch (this.clust.currentAxis) {
                case X: {
                    this.displayBits = (byte)(this.displayBits | 4);
                    break;
                }
                case Y: {
                    this.displayBits = (byte)(this.displayBits | 8);
                    break;
                }
                case Z: {
                    this.displayBits = (byte)(this.displayBits | 0xC);
                    break;
                }
                default: {
                    this.displayBits = 0;
                }
            }
            if (this.getGrid() != null) {
                if (this.clust.isValid) {
                    this.displayBits = (byte)(this.displayBits | 0x10);
                }
                if (this.isPowered()) {
                    this.displayBits = (byte)(this.displayBits | 0x20);
                }
            }
        }
        if (oldBits != this.displayBits) {
            this.markForUpdate();
        }
    }

    public void updateStatus(SpatialPylonCluster c) {
        this.clust = c;
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.field_70331_k, this.getLocation()));
        this.recalculateDisplay();
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        data.writeByte(this.displayBits);
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        byte oldBits = this.displayBits;
        this.displayBits = stream.readByte();
        return oldBits != this.displayBits;
    }

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return st == IAppEngNetworkTile.SyncTime.WORLD;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isSeperated() {
        return this.clust == null;
    }

    @Override
    public float getPowerDrainPerTick() {
        return 0.5f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (this.displayBits != 0) {
            if ((this.displayBits & 0xC) == 4) {
                this.ori = ForgeDirection.EAST;
                if ((this.displayBits & 3) == 2) {
                    renderer.field_78662_g = 1;
                    renderer.field_78683_h = 2;
                    renderer.field_78681_k = 2;
                    renderer.field_78675_l = 1;
                } else if ((this.displayBits & 3) == 1) {
                    renderer.field_78662_g = 2;
                    renderer.field_78683_h = 1;
                    renderer.field_78681_k = 1;
                    renderer.field_78675_l = 2;
                } else {
                    renderer.field_78662_g = 1;
                    renderer.field_78683_h = 1;
                    renderer.field_78681_k = 1;
                    renderer.field_78675_l = 1;
                }
            } else if ((this.displayBits & 0xC) == 8) {
                this.ori = ForgeDirection.UP;
                if ((this.displayBits & 3) == 2) {
                    renderer.field_78679_j = 3;
                    renderer.field_78685_i = 3;
                    renderer.field_78662_g = 3;
                    renderer.field_78683_h = 3;
                }
            } else if ((this.displayBits & 0xC) == 12) {
                this.ori = ForgeDirection.NORTH;
                if ((this.displayBits & 3) == 2) {
                    renderer.field_78685_i = 1;
                    renderer.field_78679_j = 2;
                } else if ((this.displayBits & 3) == 1) {
                    renderer.field_78679_j = 1;
                    renderer.field_78685_i = 2;
                    renderer.field_78681_k = 3;
                    renderer.field_78675_l = 3;
                } else {
                    renderer.field_78679_j = 1;
                    renderer.field_78685_i = 2;
                }
            }
            this.textureOffset = 0;
            boolean r = super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
            int n = this.textureOffset = (this.displayBits & 0x10) == 16 ? 1 : 2;
            if ((this.displayBits & 0x20) == 32) {
                int bn = 15;
                Tessellator.field_78398_a.func_78380_c(bn << 20 | bn << 4);
                Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    this.renderFace(block, renderer, d);
                }
            } else {
                super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
            }
            renderer.field_78675_l = 0;
            renderer.field_78681_k = 0;
            renderer.field_78685_i = 0;
            renderer.field_78679_j = 0;
            renderer.field_78683_h = 0;
            renderer.field_78662_g = 0;
            return r;
        }
        this.textureOffset = 0;
        boolean r = super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        this.textureOffset = 1;
        return super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
    }

    @Override
    public int getLightValue() {
        if ((this.displayBits & 0x20) == 32) {
            return 8;
        }
        return super.getLightValue();
    }

    @Override
    public void setGrid(IGridInterface gi) {
        super.setGrid(gi);
        this.recalculateDisplay();
    }

    public void updateNetworkStatus(boolean isValid) {
        this.recalculateDisplay();
    }
}

