/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.IAEItemStack;
import appeng.api.WorldCoord;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IConfigEnum;
import appeng.api.config.RedstoneModeInput;
import appeng.api.config.StackModeInput;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.me.tiles.IColoredMETile;
import appeng.api.me.tiles.IConfigureableTile;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IOrientableTile;
import appeng.api.me.tiles.ITileIOCable;
import appeng.api.me.util.IConfigManager;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngTile;
import appeng.common.network.IAppEngNetworkTile;
import appeng.interfaces.IConfigEnabledTile;
import appeng.me.MEInventoryNull;
import appeng.me.METhrottle;
import appeng.me.basetiles.TileCableBase;
import appeng.me.tile.AEAppEngInternalInventory;
import appeng.render.AppEngBlockRenderer;
import appeng.util.ConfigManager;
import appeng.util.InventoryAdaptor;
import appeng.util.ItemList;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.IMEInventoryDestination;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileInputCable
extends TileCableBase
implements IOrientableTile,
ITileIOCable,
IConfigEnabledTile,
IConfigureableTile,
IDirectionalMETile,
IAppEngNetworkTile,
IGridMachine,
IColoredMETile {
    ForgeDirection orientation;
    int color = -1;
    public AEAppEngInternalInventory item;
    public ITileIOCable.Version ver;
    ConfigManager config = new ConfigManager(this);
    RedstoneModeInput rsMode = RedstoneModeInput.Ignore;
    StackModeInput sMode = StackModeInput.Single;
    METhrottle throttle;
    FuzzyMode fuzzyMode;

    @Override
    public boolean requiresRedstoneUpdates() {
        return true;
    }

    @Override
    public AxisAlignedBB extendBusCollision(AxisAlignedBB b) {
        if (this.ver == ITileIOCable.Version.Basic) {
            return this.IOBusCollision(0.3f, this.orientation, b);
        }
        return this.IOBusCollision(0.2f, this.orientation, b);
    }

    @Override
    public boolean isColored(ForgeDirection d) {
        return this.color >= 0;
    }

    @Override
    public ITileIOCable.Version getVersion() {
        return this.ver;
    }

    public TileInputCable() {
        this.orientation = ForgeDirection.UP;
        this.rsMode = RedstoneModeInput.Ignore;
        this.config.RegisterSetting(this.rsMode);
        this.sMode = StackModeInput.Single;
        this.config.RegisterSetting(this.sMode);
        this.fuzzyMode = FuzzyMode.Percent_99;
        this.config.RegisterSetting(this.fuzzyMode);
        this.ver = ITileIOCable.Version.Precision;
        this.item = new AEAppEngInternalInventory(this, 8);
        this.item.setMaxStackSize(1);
        this.throttle = new METhrottle(5, AppEngConfiguration.automationMinTickRate, AppEngConfiguration.automationMinTickRate + 110);
    }

    @Override
    public void setOrientationBySide(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        super.setOrientationBySide(player, side, hitX, hitY, hitZ);
        this.orientation = ForgeDirection.getOrientation((int)side);
        if (player.func_70093_af()) {
            this.orientation = this.orientation.getOpposite();
        }
        WorldCoord pos = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        pos.add(this.orientation, -1);
        TileEntity te = this.field_70331_k.func_72796_p(pos.x, pos.y, pos.z);
        if (te instanceof IColoredMETile && ((IColoredMETile)te).isColored(ForgeDirection.UNKNOWN)) {
            this.color = ((IColoredMETile)te).getColor();
        }
    }

    @Override
    public void setPowerStatus(boolean _hasPower) {
        super.setPowerStatus(_hasPower);
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTipPart(Block block, RenderBlocks renderer, float offset, float Thickness, float DirectionalThickness, int x, int y, int z) {
        AppEngBlockRenderer AppEngRenderer = AppEngBlockRenderer.instance;
        AppEngRenderer.setOverrideBlockTexture(block, this.ver == ITileIOCable.Version.Fuzzy ? AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get() : AppEngTextureRegistry.Blocks.BlockInterface.get());
        float offX = (float)this.orientation.offsetX / 2.0f;
        float offY = (float)this.orientation.offsetY / 2.0f;
        float offZ = (float)this.orientation.offsetZ / 2.0f;
        float centerX = 0.5f;
        float centerY = 0.5f;
        float centerZ = 0.5f;
        float thickX = (double)Math.abs(this.orientation.offsetX) > 0.1 ? DirectionalThickness : Thickness;
        float thickY = (double)Math.abs(this.orientation.offsetY) > 0.1 ? DirectionalThickness : Thickness;
        float thickZ = (double)Math.abs(this.orientation.offsetZ) > 0.1 ? DirectionalThickness : Thickness;
        this.setTipRenderBounds(renderer, this.orientation, centerX + offX - thickX, (centerY += (float)this.orientation.offsetY * -offset) + offY - thickY, (centerZ += (float)this.orientation.offsetZ * -offset) + offZ - thickZ, (centerX += (float)this.orientation.offsetX * -offset) + offX + thickX, centerY + offY + thickY, centerZ + offZ + thickZ);
        renderer.func_78570_q(block, x, y, z);
        AppEngRenderer.setOverrideBlockTexture(block, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.field_78661_f = true;
        Icon cableColor = this.color == -1 ? AppEngTextureRegistry.Blocks.MECableClear.get() : AppEngTextureRegistry.Blocks.MECableColors[this.color].get();
        this.renderCableAt(0.11, world, x, y, z, block, modelId, renderer, cableColor, true, 0.0);
        this.renderCableAt(0.18, world, x, y, z, block, modelId, renderer, AppEngTextureRegistry.Blocks.MECable.get(), false, 0.1875);
        if (this.ver == ITileIOCable.Version.Basic) {
            this.renderTipPart(block, renderer, 0.076f, 0.2f, 0.076f, x, y, z);
            this.renderTipPart(block, renderer, 0.304f, 0.1f, 0.2f, x, y, z);
        } else {
            this.renderTipPart(block, renderer, 0.076f, 0.3f, 0.076f, x, y, z);
            this.renderTipPart(block, renderer, 0.152f, 0.25f, 0.076f, x, y, z);
            this.renderTipPart(block, renderer, 0.22799999f, 0.2f, 0.076f, x, y, z);
            this.renderTipPart(block, renderer, 0.304f, 0.15f, 0.076f, x, y, z);
        }
        renderer.field_78661_f = false;
        super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        return true;
    }

    @Override
    public NBTTagCompound getSettings(AppEngTile.ConfigMode mode) {
        if (this.getVersion() == ITileIOCable.Version.Basic) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("rsMode", this.rsMode.toString());
        tag.func_74778_a("sMode", this.sMode.toString());
        tag.func_74778_a("fzMode", this.fuzzyMode.toString());
        NBTTagCompound it = new NBTTagCompound();
        if (this.item != null) {
            this.item.writeToNBT(it);
        }
        tag.func_74766_a("it", it);
        return tag;
    }

    @Override
    public void restoreSettings(NBTTagCompound tag, AppEngTile.ConfigMode mode) {
        try {
            this.item.readFromNBT(tag.func_74775_l("it"));
            this.rsMode = (RedstoneModeInput)this.config.loadSetting(this.rsMode, tag, "rsMode");
            this.sMode = (StackModeInput)this.config.loadSetting(this.sMode, tag, "sMode");
            this.fuzzyMode = this.config.loadSetting(this.fuzzyMode, tag, "fzMode");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.color = par1nbtTagCompound.func_74771_c("co");
        this.orientation = ForgeDirection.getOrientation((int)par1nbtTagCompound.func_74771_c("ori"));
        this.item.readFromNBT(par1nbtTagCompound.func_74775_l("it"));
        this.rsMode = (RedstoneModeInput)this.config.loadSetting(this.rsMode, par1nbtTagCompound, "rsMode");
        this.sMode = (StackModeInput)this.config.loadSetting(this.sMode, par1nbtTagCompound, "sMode");
        this.fuzzyMode = this.config.loadSetting(this.fuzzyMode, par1nbtTagCompound, "fzMode");
        try {
            this.ver = ITileIOCable.Version.valueOf(par1nbtTagCompound.func_74779_i("ver"));
        }
        catch (IllegalArgumentException err) {
            this.ver = ITileIOCable.Version.Precision;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74774_a("co", (byte)this.color);
        par1nbtTagCompound.func_74774_a("ori", (byte)this.orientation.ordinal());
        par1nbtTagCompound.func_74778_a("rsMode", this.rsMode.toString());
        par1nbtTagCompound.func_74778_a("sMode", this.sMode.toString());
        par1nbtTagCompound.func_74778_a("fzMode", this.fuzzyMode.toString());
        par1nbtTagCompound.func_74778_a("ver", this.ver.toString());
        NBTTagCompound it = new NBTTagCompound();
        if (this.item != null) {
            this.item.writeToNBT(it);
        }
        par1nbtTagCompound.func_74766_a("it", it);
    }

    @Override
    public boolean isBlockNormalCube() {
        return false;
    }

    @Override
    public void setColor(int offset) {
        this.color = offset;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        ForgeDirection oldOrientation = this.orientation;
        int oldColor = this.color;
        boolean changed = super.handleTilePacket(stream);
        this.orientation = ForgeDirection.getOrientation((int)stream.readByte());
        this.color = stream.readByte();
        this.ver = ITileIOCable.Version.values()[stream.readByte()];
        return oldColor != this.color || oldOrientation != this.orientation || changed;
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        super.configureTilePacket(data);
        data.writeByte((byte)this.orientation.ordinal());
        data.writeByte((byte)this.color);
        data.writeByte((byte)this.ver.ordinal());
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return this.ver != ITileIOCable.Version.Basic;
    }

    public int PullItem(int remainingItems, InventoryAdaptor ia, IAEItemStack filter) {
        if (ia != null) {
            ItemStack canGet = null;
            canGet = this.ver == ITileIOCable.Version.Fuzzy ? ia.simulateSimilarRemove(remainingItems, Platform.getSharedItemStack(filter), this.fuzzyMode, this.getDest()) : ia.simulateRemove(remainingItems, Platform.getSharedItemStack(filter), this.getDest());
            IGridInterface gi = this.getGrid();
            if (canGet != null && gi != null) {
                IMEInventoryHandler mei = gi.getCellArray();
                if (mei == null) {
                    return 0;
                }
                ItemStack is = Platform.calculateItemAddition(mei, canGet);
                int Amount = canGet.field_77994_a;
                if (is != null) {
                    Amount -= is.field_77994_a;
                }
                if (Amount > 0 && gi.useMEEnergy(Amount * (this.sMode == StackModeInput.Stack ? 3 : 1), "input bus: " + (Object)((Object)this.ver))) {
                    ItemStack itemsRemoved = null;
                    itemsRemoved = this.ver == ITileIOCable.Version.Fuzzy ? ia.removeSimilarItems(Amount, Platform.getSharedItemStack(filter), this.fuzzyMode, this.getDest()) : ia.removeItems(Amount, Platform.getSharedItemStack(filter), this.getDest());
                    if (itemsRemoved != null) {
                        this.throttle.hasAccomplishedWork();
                        mei = gi.getCellArray();
                        ItemStack failedToInsert = Platform.addItems(mei, itemsRemoved);
                        if (failedToInsert != null) {
                            itemsRemoved.field_77994_a -= failedToInsert.field_77994_a;
                            ia.addItems(failedToInsert);
                        }
                        return itemsRemoved.field_77994_a;
                    }
                }
            }
        }
        return 0;
    }

    private IInventoryDestination getDest() {
        IGridInterface gi = this.getGrid();
        if (gi != null) {
            return new IMEInventoryDestination(gi.getCellArray());
        }
        return new IMEInventoryDestination(new MEInventoryNull());
    }

    public void InputItems() {
        int remainingItems;
        if (!this.isMachineActive()) {
            return;
        }
        WorldCoord wc = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        wc.add(this.orientation, 1);
        InventoryAdaptor ia = InventoryAdaptor.getAdaptor(this.field_70331_k.func_72796_p(wc.x, wc.y, wc.z), this.orientation.getOpposite());
        int n = remainingItems = this.sMode == StackModeInput.Stack ? 64 : 1;
        if (this.rsMode != RedstoneModeInput.OnPulse) {
            remainingItems = (int)((float)remainingItems * this.throttle.getMultipler());
        }
        int diff = 0;
        do {
            diff = 0;
            ItemList options = (ItemList)this.item.getIMEI().getAvailableItems(new ItemList());
            if (options.size() == 0) {
                int td = this.PullItem(remainingItems, ia, null);
                remainingItems -= td;
                diff += td;
                continue;
            }
            for (IAEItemStack filter : options) {
                if (remainingItems <= 0) continue;
                int td = this.PullItem(remainingItems, ia, filter);
                remainingItems -= td;
                diff += td;
            }
        } while (remainingItems > 0 && diff > 0);
    }

    @Override
    public void onUpdateRedstone() {
        super.onUpdateRedstone();
        this.throttle.hasAccomplishedWork();
    }

    @Override
    public void updateTileEntity() {
        if (this.throttle.process()) {
            if (this.rsMode == RedstoneModeInput.Ignore) {
                this.InputItems();
            } else if (this.rsMode == RedstoneModeInput.WhenOff && !this.getRedstoneState()) {
                this.InputItems();
            } else if (this.rsMode == RedstoneModeInput.WhenOn && this.getRedstoneState()) {
                this.InputItems();
            }
        }
    }

    @Override
    public void pulseRedStone() {
        if (this.rsMode == RedstoneModeInput.OnPulse) {
            this.InputItems();
        }
    }

    @Override
    public void cycleOrientation() {
        this.orientation = Platform.cycleOrientations(this.orientation, false);
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.getWorld(), this.getLocation()));
    }

    @Override
    public float getHoleThickness(ForgeDirection direction) {
        if (this.orientation == direction) {
            return this.getVersion() == ITileIOCable.Version.Basic ? 0.3f : 0.2f;
        }
        return super.getHoleThickness(direction);
    }

    @Override
    public float getPowerDrainPerTick() {
        return this.sMode == StackModeInput.Stack ? 2.0f : 1.0f;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir.ordinal() != this.orientation.ordinal();
    }

    @Override
    public List<String> getConfigurations() {
        return this.config.getConfigurations();
    }

    @Override
    public String nextConfiguration(String name) {
        return this.config.nextConfiguration(name);
    }

    @Override
    public String prevConfiguration(String name) {
        return this.config.prevConfiguration(name);
    }

    @Override
    public String setConfiguration(String name, String value) {
        return this.config.setConfiguration(name, value);
    }

    @Override
    public String getConfiguration(String name) {
        return this.config.getConfiguration(name);
    }

    @Override
    public List<String> getConfiguationOptions(String name) {
        return this.config.getConfiguationOptions(name);
    }

    @Override
    public IInventory getConfiguration() {
        return this.item;
    }

    @Override
    public String getName() {
        switch (this.ver) {
            case Basic: {
                return "AppEng.Blocks.ImportBus.name";
            }
            case Precision: {
                return "AppEng.Blocks.ImportBusPrecision.name";
            }
            case Fuzzy: {
                return "AppEng.Blocks.ImportBusFuzzy.name";
            }
        }
        return "Undefined";
    }

    @Override
    public void updateSetting(IConfigEnum newValue) {
        if (newValue instanceof FuzzyMode) {
            this.fuzzyMode = (FuzzyMode)newValue;
        }
        if (newValue instanceof RedstoneModeInput) {
            this.rsMode = (RedstoneModeInput)newValue;
        }
        if (newValue instanceof StackModeInput) {
            this.sMode = (StackModeInput)newValue;
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    @Override
    public ForgeDirection getPrimaryOrientation() {
        return this.orientation;
    }

    @Override
    public int getSpin() {
        return 0;
    }

    @Override
    public void setPrimaryOrientation(ForgeDirection s) {
        this.orientation = s;
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.getWorld(), this.getLocation()));
    }

    @Override
    public void setSpin(int spin) {
    }
}

