/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.TileRef;
import appeng.api.WorldCoord;
import appeng.common.AppEng;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.MBCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.me.tile.TileQuantumBridge;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class QuantumCalculator
extends MBCalculator {
    TileQuantumBridge tqb;

    public QuantumCalculator(IAEMultiBlock t) {
        super(t);
        this.tqb = (TileQuantumBridge)t;
    }

    @Override
    public boolean isValidTile(TileEntity te) {
        return te instanceof TileQuantumBridge;
    }

    @Override
    public boolean checkMultiblockScale(WorldCoord min, WorldCoord max) {
        if ((max.x - min.x + 1) * (max.y - min.y + 1) * (max.z - min.z + 1) == 9) {
            int ones = (max.x - min.x == 0 ? 1 : 0) + (max.y - min.y == 0 ? 1 : 0) + (max.z - min.z == 0 ? 1 : 0);
            int threes = (max.x - min.x == 2 ? 1 : 0) + (max.y - min.y == 2 ? 1 : 0) + (max.z - min.z == 2 ? 1 : 0);
            return ones == 1 && threes == 2;
        }
        return false;
    }

    @Override
    public void updateTiles(IAECluster cl, IBlockAccess w, WorldCoord min, WorldCoord max) {
        byte num = 0;
        int ringNum = 0;
        QuantumCluster c = (QuantumCluster)cl;
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    TileQuantumBridge te = (TileQuantumBridge)w.func_72796_p(x, y, z);
                    byte Fish = 0;
                    if ((num = (byte)((byte)(num + 1))) == 5) {
                        Fish = num;
                        c.setCenter(te);
                    } else {
                        Fish = num == 1 || num == 3 || num == 7 || num == 9 ? (byte)(this.tqb.corner | num) : num;
                        int n = ringNum;
                        ringNum = (byte)(ringNum + 1);
                        c.Ring[n] = new TileRef(te);
                    }
                    te.updateStatus(c, Fish);
                }
            }
        }
    }

    @Override
    public IAECluster createCluster(IBlockAccess w, WorldCoord min, WorldCoord max) {
        return new QuantumCluster(min, max);
    }

    @Override
    public void disconnect() {
        this.tqb.disconnect();
    }

    @Override
    public boolean verifyInternalStructure(IBlockAccess w, WorldCoord min, WorldCoord max) {
        int num = 0;
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    IAEMultiBlock te = (IAEMultiBlock)w.func_72796_p(x, y, z);
                    if (!te.isValid()) {
                        return false;
                    }
                    if (!((num = (int)((byte)(num + 1))) == 5 ? w.func_72805_g(x, y, z) != AppEng.getInstance().registration.blkQuantumLink.getMetaData() : w.func_72805_g(x, y, z) != AppEng.getInstance().registration.blkQuantumRing.getMetaData())) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

