/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.IAEItemStack;
import appeng.api.IWirelessTermHandler;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.me.tiles.ICellProvider;
import appeng.api.me.tiles.IExtendedCellProvider;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.network.AppEngPacketHandlerBase;
import appeng.common.network.packets.PacketNMEInv;
import appeng.me.CellInventory;
import appeng.util.AEItemStack;
import appeng.util.ItemList;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class NetworkedIMEI {
    long totalBytes;
    long usedBytes;
    long storedItemTypes;
    long totalItemTypes;
    long storedItemCount;
    long remainingItemCount;
    long unusedItemCount;
    boolean canHoldNewItem;
    boolean isValid = false;
    private String Search;
    public ICellProvider realInv;
    public IGridMachine machine;
    public Player targetPlayer;
    List<recvedPacket> termPackets = new ArrayList<recvedPacket>();
    public byte instance = 0;
    public byte page = 0;
    boolean hasUpdates = false;
    List<IAEItemStack> invChanges = new ArrayList<IAEItemStack>();
    List<IAEItemStack> list;
    List<IAEItemStack> lastSearch = null;
    public ViewItems requestItems = ViewItems.ALL;
    public double distanceMultiplier;
    public int wirelessSlot = -1;

    public IMEInventoryHandler getParent() {
        return null;
    }

    public void setParent(IMEInventoryHandler _p) {
    }

    public NetworkedIMEI() {
        this.list = new ArrayList<IAEItemStack>();
    }

    public void setSearch(String s) {
        if (s.equals(this.Search)) {
            return;
        }
        this.Search = s;
        this.lastSearch = null;
    }

    public boolean checkValid() {
        if (this.machine != null) {
            if (!this.machine.isMachineActive()) {
                return false;
            }
            if (this.machine.getGrid() != null) {
                return true;
            }
        }
        return true;
    }

    public void update() {
        if (this.realInv != null) {
            IMEInventoryHandler realCell = this.realInv instanceof IExtendedCellProvider ? ((IExtendedCellProvider)this.realInv).provideCell(this.requestItems.toString()) : this.realInv.provideCell();
            double storedPower = 0.0;
            if (this.getWirelessTerminal() != null) {
                ItemStack is = this.getWirelessTerminal();
                IWirelessTermHandler handler = AppEng.getApiInstance().getWirelessRegistry().getWirelessTerminalHandler(is);
                if (handler != null) {
                    storedPower = AppEngConfiguration.requirePower ? (handler.hasPower(this.targetPlayer, is) ? 1.0 : 0.0) : 1.0;
                }
            }
            if (realCell != null && this.checkValid() && (this.wirelessSlot == -1 || storedPower > 0.9)) {
                this.isValid = true;
                this.list = new ArrayList<IAEItemStack>();
                ItemList ll = (ItemList)realCell.getAvailableItems();
                for (IAEItemStack o : ll) {
                    if (CellInventory.isBlackListed(o)) continue;
                    this.list.add(o.copy());
                }
            } else {
                this.list = new ArrayList<IAEItemStack>();
                this.canHoldNewItem = false;
                this.unusedItemCount = 0L;
                this.remainingItemCount = 0L;
                this.storedItemCount = 0L;
                this.totalItemTypes = 0L;
                this.storedItemTypes = 0L;
                this.usedBytes = 0L;
                this.totalBytes = 0L;
                this.isValid = false;
            }
        }
    }

    void checkCompleted() {
        HashMap<Byte, Byte> PacketAvail = new HashMap<Byte, Byte>();
        HashMap<Byte, Byte> PacketSizes = new HashMap<Byte, Byte>();
        for (recvedPacket p : this.termPackets) {
            if (p.end) {
                PacketSizes.put(p.intst, p.page);
            }
            PacketAvail.put(p.intst, (byte)(PacketAvail.containsKey(p.intst) ? (Byte)PacketAvail.get(p.intst) + 1 : 1));
        }
        for (Byte Insts : PacketSizes.keySet()) {
            try {
                ByteArrayOutputStream bytesInput = new ByteArrayOutputStream();
                DataOutputStream dataInput = new DataOutputStream(bytesInput);
                byte ps = (Byte)PacketSizes.get(Insts);
                if (ps + 1 != (Byte)PacketAvail.get(Insts)) continue;
                for (byte page = 0; page <= ps; page = (byte)(page + 1)) {
                    for (recvedPacket p : this.termPackets) {
                        if (p.intst != Insts || p.page != page) continue;
                        dataInput.write(p.data);
                    }
                }
                Iterator<recvedPacket> ix = this.termPackets.iterator();
                while (ix.hasNext()) {
                    if (ix.next().intst != Insts) continue;
                    ix.remove();
                }
                try {
                    ByteArrayInputStream bytes = new ByteArrayInputStream(bytesInput.toByteArray());
                    DataInputStream data = new DataInputStream(bytes);
                    boolean isUpdate = data.readBoolean();
                    if (isUpdate) {
                        AppEng.log("Received Terminal Update, " + bytesInput.size() + "b");
                    } else {
                        AppEng.log("Received Terminal Def, " + bytesInput.size() + "b");
                    }
                    this.isValid = data.readBoolean();
                    int items = data.readInt();
                    DataInputStream idata = new DataInputStream(new GZIPInputStream(data));
                    if (!isUpdate || this.list == null) {
                        this.list = new ArrayList<IAEItemStack>();
                    }
                    for (int x = 0; x < items; ++x) {
                        IAEItemStack aeis = AEItemStack.loadItemStackFromPacket(idata);
                        if (isUpdate) {
                            boolean added = false;
                            for (IAEItemStack ie : this.list) {
                                if (!ie.equals(aeis)) continue;
                                added = true;
                                ie.reset();
                                int priority = ((AEItemStack)aeis).priority;
                                if (((AEItemStack)ie).priority < priority) {
                                    ((AEItemStack)ie).priority = priority;
                                }
                                ie.setStackSize(aeis.getStackSize());
                                ie.setCountRequestable(aeis.getCountRequestable());
                                ie.setCraftable(aeis.isCraftable());
                            }
                            if (added) continue;
                            Platform.sumItemToList(this.list, aeis);
                            continue;
                        }
                        this.list.add(aeis);
                    }
                    Iterator<IAEItemStack> i = this.list.iterator();
                    while (i.hasNext()) {
                        if (i.next().isMeaninful()) continue;
                        i.remove();
                    }
                    this.lastSearch = null;
                }
                catch (NullPointerException e) {
                    bytesInput = new ByteArrayOutputStream();
                    dataInput = new DataOutputStream(bytesInput);
                }
                catch (IOException e) {
                    bytesInput = new ByteArrayOutputStream();
                    dataInput = new DataOutputStream(bytesInput);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void addPacket(PacketNMEInv p) {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(p.data);
            DataInputStream data = new DataInputStream(bytes);
            recvedPacket rp = new recvedPacket();
            rp.intst = data.readByte();
            rp.page = data.readByte();
            rp.data = Arrays.copyOfRange(p.data, 2, p.data.length - 1);
            rp.end = p.data[p.data.length - 1] != 0;
            this.termPackets.add(rp);
            this.checkCompleted();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readPacket(PacketNMEInv p) {
        this.addPacket(p);
    }

    public Packet250CustomPayload getRequestPacket() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(this.requestItems.toString().length());
            data.writeUTF(this.requestItems.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new PacketNMEInv(bytes.toByteArray()).getPacket();
    }

    public List<Packet250CustomPayload> getDataPacket() throws IOException {
        List<IAEItemStack> listPackage = null;
        boolean sendingUpdates = false;
        if (this.hasUpdates) {
            IMEInventoryHandler realCell;
            this.update();
            listPackage = new ArrayList<IAEItemStack>();
            IMEInventoryHandler iMEInventoryHandler = realCell = this.realInv instanceof IExtendedCellProvider ? ((IExtendedCellProvider)this.realInv).provideCell(this.requestItems.toString()) : this.realInv.provideCell();
            if (realCell == null) {
                return new ArrayList<Packet250CustomPayload>();
            }
            ItemList ll = (ItemList)realCell.getAvailableItems();
            for (IAEItemStack ie : this.invChanges) {
                if (CellInventory.isBlackListed(ie)) continue;
                IAEItemStack o = ll.findItem(ie);
                if (o == null) {
                    o = ie.copy();
                    o.setStackSize(0L);
                    listPackage.add(o);
                    continue;
                }
                Platform.sumItemToList(listPackage, o);
            }
            this.invChanges = new ArrayList<IAEItemStack>();
            sendingUpdates = true;
            this.hasUpdates = false;
        } else {
            this.update();
            listPackage = this.list;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        int page = 0;
        byte by = this.instance;
        this.instance = (byte)(by + 1);
        byte myInstance = by;
        try {
            data.writeBoolean(sendingUpdates);
            data.writeBoolean(this.isValid);
            int size = 0;
            if (listPackage != null) {
                size = listPackage.size();
            }
            data.writeInt(size);
            GZIPOutputStream gzo = new GZIPOutputStream(bytes);
            DataOutputStream out = new DataOutputStream(gzo);
            if (size > 0) {
                for (int x = 0; x < listPackage.size(); ++x) {
                    listPackage.get(x).writeToPacket(out);
                }
                gzo.close();
            } else {
                data.writeInt(0);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        int maxPacketSize = 30000;
        ArrayList<Packet250CustomPayload> out = new ArrayList<Packet250CustomPayload>();
        byte[] byteData = bytes.toByteArray();
        ByteBuffer bb = ByteBuffer.wrap(byteData);
        byte[] newBlock = new byte[6 + maxPacketSize + 1];
        ByteBuffer.wrap(newBlock).putInt(AppEngPacketHandlerBase.PacketTypes.PACKET_NMEIINV.ordinal());
        int byteDataLength = byteData.length;
        int offset = 0;
        while (offset < byteDataLength) {
            int smallSize = byteDataLength - offset;
            if (smallSize > maxPacketSize) {
                smallSize = maxPacketSize;
                bb.get(newBlock, 6, smallSize);
                newBlock[6 + maxPacketSize] = 0;
            } else {
                newBlock = new byte[6 + smallSize + 1];
                ByteBuffer.wrap(newBlock).putInt(AppEngPacketHandlerBase.PacketTypes.PACKET_NMEIINV.ordinal()).put(myInstance).put((byte)0).put(byteData, offset, smallSize).put((byte)1);
            }
            offset += smallSize;
            newBlock[4] = myInstance;
            int n = page;
            page = (byte)(page + 1);
            newBlock[5] = n;
            Packet250CustomPayload packet = new Packet250CustomPayload("AE", Arrays.copyOf(newBlock, newBlock.length));
            packet.field_73287_r = false;
            out.add(packet);
        }
        return out;
    }

    @SideOnly(value=Side.CLIENT)
    public List<IAEItemStack> getAvailableItems() {
        if (!this.isValid) {
            return new ArrayList<IAEItemStack>();
        }
        if (this.lastSearch != null) {
            return this.lastSearch;
        }
        if (this.Search != null && this.Search.length() > 0) {
            return this.searchItems(this.Search);
        }
        if (AppEngConfiguration.terminalAutoSearch == SearchBoxMode.NEIAutoSearch || AppEngConfiguration.terminalAutoSearch == SearchBoxMode.NEIStandard) {
            this.updateNEI(this.Search);
        }
        ArrayList<IAEItemStack> is = new ArrayList<IAEItemStack>();
        if (this.list != null) {
            for (IAEItemStack x : this.list) {
                if (x == null) continue;
                is.add(x);
            }
        }
        this.lastSearch = is;
        this.sortSearch();
        return this.lastSearch;
    }

    public void resetSearch() {
        this.Search = null;
        this.lastSearch = null;
    }

    void sortSearch() {
        try {
            if (AppEngConfiguration.SortBy == SortOrder.Priority) {
                Collections.sort(this.lastSearch, ItemSorters.ConfigBased_SortByPriority);
            }
            if (AppEngConfiguration.SortBy == SortOrder.Size) {
                Collections.sort(this.lastSearch, ItemSorters.ConfigBased_SortBySize);
            }
            if (AppEngConfiguration.SortBy == SortOrder.Name) {
                Collections.sort(this.lastSearch, ItemSorters.ConfigBased_SortByName);
            }
            if (AppEngConfiguration.SortBy == SortOrder.ItemID) {
                Collections.sort(this.lastSearch, ItemSorters.ConfigBased_SortByID);
            }
        }
        catch (Throwable e) {
            FMLLog.severe((String)("An Error occured while sorting list by " + AppEngConfiguration.SortBy + " - Please send this to the author."), (Object[])new Object[0]);
            for (IAEItemStack i : this.lastSearch) {
                FMLLog.severe((String)(i.getItemID() + " : " + i.getItemDamage() + " : " + ((AEItemStack)i).priority + " : " + Platform.getItemDisplayName(i)), (Object[])new Object[0]);
            }
            FMLLog.severe((String)"Exception:", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public ItemStack getWirelessTerminal() {
        if (this.wirelessSlot >= 0) {
            EntityPlayer ep = (EntityPlayer)this.targetPlayer;
            ItemStack is = ep.field_71071_by.func_70448_g();
            if (AppEng.getApiInstance().getWirelessRegistry().isWirelessTerminal(is)) {
                return is;
            }
        }
        return null;
    }

    private void updateNEI(String filter) {
        try {
            Class c = ReflectionHelper.getClass((ClassLoader)this.getClass().getClassLoader(), (String[])new String[]{"codechicken.nei.LayoutManager"});
            Field fldSearchField = c.getField("searchField");
            Object searchField = fldSearchField.get(c);
            Method a = searchField.getClass().getMethod("setText", String.class);
            Method b = searchField.getClass().getMethod("onTextChange", String.class);
            a.invoke(searchField, filter);
            b.invoke(searchField, "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<IAEItemStack> searchItems(String str) {
        ArrayList<IAEItemStack> s = new ArrayList<IAEItemStack>();
        if (AppEngConfiguration.terminalAutoSearch == SearchBoxMode.NEIAutoSearch || AppEngConfiguration.terminalAutoSearch == SearchBoxMode.NEIStandard) {
            this.updateNEI(str);
        }
        Pattern m = null;
        try {
            m = Pattern.compile(str.toLowerCase(), 2);
        }
        catch (Throwable _) {
            // empty catch block
        }
        if (this.list != null) {
            block4: for (IAEItemStack l : this.list) {
                try {
                    String dspName = Platform.getItemDisplayName(l);
                    if (m != null) {
                        if (m.matcher(dspName.toLowerCase()).find()) {
                            s.add(l);
                            continue;
                        }
                        if (!AppEngConfiguration.terminalSearchToolTips) continue;
                        for (Object lp : Platform.getTooltip(l)) {
                            if (!(lp instanceof String) || !m.matcher((String)lp).find()) continue;
                            s.add(l);
                            continue block4;
                        }
                        continue;
                    }
                    if (dspName.toLowerCase().contains(str.toLowerCase())) {
                        s.add(l);
                        continue;
                    }
                    if (!AppEngConfiguration.terminalSearchToolTips) continue;
                    for (Object lp : Platform.getTooltip(l)) {
                        if (!(lp instanceof String) || !((String)lp).toLowerCase().contains(str.toLowerCase())) continue;
                        s.add(l);
                    }
                }
                catch (Exception err) {
                    AppEng.log("Caught exception thrown by " + l.getItem());
                }
            }
        }
        this.lastSearch = s;
        this.sortSearch();
        return this.lastSearch;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void postChanges(List<IAEItemStack> invChanges) {
        if (invChanges != null && !invChanges.isEmpty()) {
            this.hasUpdates = true;
            this.invChanges = invChanges;
        }
    }

    public IMEInventoryHandler provideCell() {
        if (!this.checkValid()) {
            return null;
        }
        if (this.realInv != null) {
            return this.realInv.provideCell();
        }
        return null;
    }

    public int usePowerForAddition(int stackSize, int i) {
        if (this.getWirelessTerminal() != null) {
            ItemStack term;
            double fish = this.distanceMultiplier * (AppEngConfiguration.WirelessDistanceMultiplier / 100.0);
            if (fish < 1.0) {
                fish = 1.0;
            }
            if ((term = this.getWirelessTerminal()) != null) {
                IWirelessTermHandler handler = AppEng.getApiInstance().getWirelessRegistry().getWirelessTerminalHandler(term);
                boolean isGood = handler.usePower(this.targetPlayer, (float)((double)stackSize * fish), term);
                this.updateWirelessItem(term);
                if (!isGood) {
                    try {
                        this.update();
                        for (Packet250CustomPayload p : this.getDataPacket()) {
                            PacketDispatcher.sendPacketToPlayer((Packet)p, (Player)this.targetPlayer);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return 0;
                }
            }
        }
        if (!this.checkValid()) {
            return 0;
        }
        if (this.realInv != null) {
            return this.realInv.usePowerForAddition(stackSize, i);
        }
        return 0;
    }

    private void updateWirelessItem(ItemStack term) {
        EntityPlayer ep = (EntityPlayer)this.targetPlayer;
        ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, term);
    }

    private class recvedPacket {
        public byte intst;
        public byte page;
        public byte[] data;
        public boolean end;

        private recvedPacket() {
        }
    }
}

