/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.nei.FastTransferManager;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DefaultOverlayHandler
implements IOverlayHandler {
    int offsetx;
    int offsety;

    public DefaultOverlayHandler(int x, int y) {
        this.offsetx = x;
        this.offsety = y;
    }

    public DefaultOverlayHandler() {
        this(5, 11);
    }

    @Override
    public void overlayRecipe(awy gui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        List<PositionedStack> ingredients = recipe.getIngredientStacks(recipeIndex);
        List<DistributedIngred> ingredStacks = this.getPermutationIngredients(ingredients);
        if (!this.clearIngredients(gui, ingredients)) {
            return;
        }
        this.findInventoryQuantities(gui, ingredStacks);
        List<IngredientDistribution> assignedIngredients = this.assignIngredients(ingredients, ingredStacks);
        if (assignedIngredients == null) {
            return;
        }
        this.assignIngredSlots(gui, ingredients, assignedIngredients);
        int quantity = this.calculateRecipeQuantity(assignedIngredients);
        if (quantity != 0) {
            this.moveIngredients(gui, assignedIngredients, quantity);
        }
    }

    private boolean clearIngredients(awy gui, List<PositionedStack> ingreds) {
        for (PositionedStack pstack : ingreds) {
            for (we slot : gui.e.c) {
                if (slot.h != pstack.relx + this.offsetx || slot.i != pstack.rely + this.offsety || !slot.e()) continue;
                FastTransferManager.clickSlot(gui, slot.g, 0, 1);
                if (!slot.e()) continue;
                return false;
            }
        }
        return true;
    }

    private void moveIngredients(awy gui, List<IngredientDistribution> assignedIngredients, int quantity) {
        block0: for (IngredientDistribution distrib : assignedIngredients) {
            ye pstack = distrib.permutation;
            int transferCap = quantity * pstack.b;
            int transferred = 0;
            int destSlotIndex = 0;
            we dest = distrib.slots[0];
            int slotTransferred = 0;
            int slotTransferCap = pstack.e();
            for (we slot : gui.e.c) {
                ye stack;
                if (!slot.e() || !(slot.f instanceof ud) || !InventoryUtils.canStack((ye)(stack = slot.d()), (ye)pstack)) continue;
                FastTransferManager.clickSlot(gui, slot.g);
                int amount = Math.min(transferCap - transferred, stack.b);
                for (int c = 0; c < amount; ++c) {
                    FastTransferManager.clickSlot(gui, dest.g, 1);
                    ++transferred;
                    if (++slotTransferred < slotTransferCap) continue;
                    if (++destSlotIndex == distrib.slots.length) {
                        dest = null;
                        break;
                    }
                    dest = distrib.slots[destSlotIndex];
                    slotTransferred = 0;
                }
                FastTransferManager.clickSlot(gui, slot.g);
                if (transferred < transferCap && dest != null) continue;
                continue block0;
            }
        }
    }

    private int calculateRecipeQuantity(List<IngredientDistribution> assignedIngredients) {
        int quantity = Integer.MAX_VALUE;
        for (IngredientDistribution distrib : assignedIngredients) {
            DistributedIngred istack = distrib.distrib;
            if (istack.numSlots == 0) {
                return 0;
            }
            int allSlots = istack.invAmount;
            if (allSlots / istack.numSlots > istack.stack.e()) {
                allSlots = istack.numSlots * istack.stack.e();
            }
            quantity = Math.min(quantity, allSlots / istack.distributed);
        }
        return quantity;
    }

    private we[][] assignIngredSlots(awy gui, List<PositionedStack> ingredients, List<IngredientDistribution> assignedIngredients) {
        we[][] recipeSlots = this.mapIngredSlots(gui, ingredients);
        HashMap<we, Integer> distribution = new HashMap<we, Integer>();
        for (int i = 0; i < recipeSlots.length; ++i) {
            for (we slot : recipeSlots[i]) {
                if (distribution.containsKey(slot)) continue;
                distribution.put(slot, -1);
            }
        }
        HashSet avaliableSlots = new HashSet(distribution.keySet());
        HashSet<Integer> remainingIngreds = new HashSet<Integer>();
        ArrayList assignedSlots = new ArrayList();
        for (int i = 0; i < ingredients.size(); ++i) {
            remainingIngreds.add(i);
            assignedSlots.add(new LinkedList());
        }
        while (avaliableSlots.size() > 0 && remainingIngreds.size() > 0) {
            Iterator iterator = remainingIngreds.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                boolean assigned = false;
                DistributedIngred istack = assignedIngredients.get((int)i).distrib;
                for (we slot : recipeSlots[i]) {
                    if (!avaliableSlots.contains(slot)) continue;
                    avaliableSlots.remove(slot);
                    if (slot.e()) continue;
                    ++istack.numSlots;
                    ((LinkedList)assignedSlots.get(i)).add(slot);
                    assigned = true;
                    break;
                }
                if (assigned && istack.numSlots * istack.stack.e() < istack.invAmount) continue;
                iterator.remove();
            }
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            assignedIngredients.get((int)i).slots = ((LinkedList)assignedSlots.get(i)).toArray(new we[0]);
        }
        return recipeSlots;
    }

    private List<IngredientDistribution> assignIngredients(List<PositionedStack> ingredients, List<DistributedIngred> ingredStacks) {
        ArrayList<IngredientDistribution> assignedIngredients = new ArrayList<IngredientDistribution>();
        for (PositionedStack posstack : ingredients) {
            DistributedIngred biggestIngred = null;
            ye permutation = null;
            int biggestSize = 0;
            block1: for (ye pstack : posstack.items) {
                for (int j = 0; j < ingredStacks.size(); ++j) {
                    int relsize;
                    DistributedIngred istack = ingredStacks.get(j);
                    if (!InventoryUtils.canStack((ye)pstack, (ye)istack.stack) || istack.invAmount - istack.distributed < pstack.b || (relsize = (istack.invAmount - istack.invAmount / istack.recipeAmount * istack.distributed) / pstack.b) <= biggestSize) continue;
                    biggestSize = relsize;
                    biggestIngred = istack;
                    permutation = pstack;
                    continue block1;
                }
            }
            if (biggestIngred == null) {
                return null;
            }
            biggestIngred.distributed += permutation.b;
            assignedIngredients.add(new IngredientDistribution(biggestIngred, permutation));
        }
        return assignedIngredients;
    }

    private void findInventoryQuantities(awy gui, List<DistributedIngred> ingredStacks) {
        for (we slot : gui.e.c) {
            ye pstack;
            DistributedIngred istack;
            if (!slot.e() || !(slot.f instanceof ud) || (istack = this.findIngred(ingredStacks, pstack = slot.d())) == null) continue;
            istack.invAmount += pstack.b;
        }
    }

    private List<DistributedIngred> getPermutationIngredients(List<PositionedStack> ingredients) {
        ArrayList<DistributedIngred> ingredStacks = new ArrayList<DistributedIngred>();
        for (PositionedStack posstack : ingredients) {
            for (ye pstack : posstack.items) {
                DistributedIngred istack = this.findIngred(ingredStacks, pstack);
                if (istack == null) {
                    istack = new DistributedIngred(pstack);
                    ingredStacks.add(istack);
                }
                istack.recipeAmount += pstack.b;
            }
        }
        return ingredStacks;
    }

    public we[][] mapIngredSlots(awy gui, List<PositionedStack> ingredients) {
        we[][] recipeSlotList = new we[ingredients.size()][];
        for (int i = 0; i < ingredients.size(); ++i) {
            LinkedList<we> recipeSlots = new LinkedList<we>();
            PositionedStack pstack = ingredients.get(i);
            for (we slot : gui.e.c) {
                if (slot.h != pstack.relx + this.offsetx || slot.i != pstack.rely + this.offsety) continue;
                recipeSlots.add(slot);
                break;
            }
            recipeSlotList[i] = recipeSlots.toArray(new we[0]);
        }
        return recipeSlotList;
    }

    public void clickSlot(awy window, int slotIndex, int button, int modifier) {
        uy container = window.e;
        we slot = null;
        if (slotIndex >= 0 && slotIndex < container.c.size()) {
            slot = container.a(slotIndex);
        }
        window.sendMouseClick(slot, slotIndex, button, modifier);
    }

    public DistributedIngred findIngred(List<DistributedIngred> ingredStacks, ye pstack) {
        for (DistributedIngred istack : ingredStacks) {
            if (!InventoryUtils.canStack((ye)pstack, (ye)istack.stack)) continue;
            return istack;
        }
        return null;
    }

    public static class IngredientDistribution {
        public DistributedIngred distrib;
        public ye permutation;
        public we[] slots;

        public IngredientDistribution(DistributedIngred distrib, ye permutation) {
            this.distrib = distrib;
            this.permutation = permutation;
        }
    }

    public static class DistributedIngred {
        public ye stack;
        public int invAmount;
        public int distributed;
        public int numSlots;
        public int recipeAmount;

        public DistributedIngred(ye item) {
            this.stack = InventoryUtils.copyStack((ye)item, (int)1);
        }
    }
}

