/*
 * Decompiled with CFR 0.152.
 */
package myrathi.obsidiplates.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import myrathi.obsidiplates.ObsidiPlates;
import myrathi.obsidiplates.item.ItemMultiPressurePlate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockMultiPressurePlate
extends Block {
    @SideOnly(value=Side.CLIENT)
    private Icon[] iconArray;

    public BlockMultiPressurePlate(int itemID) {
        super(itemID, Material.field_76246_e);
        this.func_71884_a(Block.field_71976_h);
        this.func_71849_a(CreativeTabs.field_78028_d);
        this.func_71907_b(true);
        this.setBlockBoundsBasedOnState(this.getActiveStateFromWeight(15));
        GameRegistry.registerBlock((Block)this, ItemMultiPressurePlate.class, (String)"ObsidianPressurePlate");
        EnumPlates.registerNames(this);
    }

    public float func_71934_m(World world, int x, int y, int z) {
        EnumPlates type = EnumPlates.typeFromMeta(world.func_72805_g(x, y, z));
        return type.block.func_71934_m(world, x, y, z) * type.getHardnessModifier();
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double expX, double expY, double expZ) {
        EnumPlates type = EnumPlates.typeFromMeta(world.func_72805_g(x, y, z));
        return type.block.getExplosionResistance(entity, world, x, y, z, expX, expY, expZ);
    }

    protected int getPowerSupply(int metadata) {
        return (metadata & 1) > 0 ? 15 : 0;
    }

    protected int getPlateState(World world, int x, int y, int z) {
        boolean players = EnumPlates.isPlayerDetector(world.func_72805_g(x, y, z));
        List list = world.func_72872_a(players ? EntityPlayer.class : EntityLiving.class, this.getSensitiveAABB(x, y, z));
        for (Entity e : list) {
            if (e == null || e.func_82144_au() || !(players ^ !(e instanceof EntityPlayer))) continue;
            return 15;
        }
        return 0;
    }

    public void func_71902_a(IBlockAccess blk, int x, int y, int z) {
        this.setBlockBoundsBasedOnState(blk.func_72805_g(x, y, z));
    }

    protected void setBlockBoundsBasedOnState(int metadata) {
        float f = 0.0625f;
        boolean active = this.getPowerSupply(metadata) > 0;
        this.func_71905_a(f, 0.0f, f, 1.0f - f, active ? 0.03125f : 0.0625f, 1.0f - f);
    }

    protected int getActiveStateFromWeight(int weight) {
        return weight > 0 ? 1 : 0;
    }

    public int func_71859_p_(World world) {
        return 20;
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return ObsidiPlates.proxy.renderId_MultiPressurePlate;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71856_s_() {
        return 1;
    }

    public boolean func_71918_c(IBlockAccess blk, int x, int y, int z) {
        return true;
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        return world.func_72797_t(x, y - 1, z) || BlockFence.func_72249_c((int)world.func_72798_a(x, y - 1, z));
    }

    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        if (!world.func_72797_t(x, y - 1, z) && !BlockFence.func_72249_c((int)world.func_72798_a(x, y - 1, z))) {
            this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_94571_i(x, y, z);
        }
    }

    public void func_71847_b(World world, int x, int y, int z, Random rnd) {
        int lvl;
        if (!world.field_72995_K && (lvl = this.getPowerSupply(world.func_72805_g(x, y, z))) > 0) {
            this.setStateIfMobInteractsWithPlate(world, x, y, z, lvl);
        }
    }

    public void func_71869_a(World world, int x, int y, int z, Entity ent) {
        int lvl;
        if (!world.field_72995_K && (lvl = this.getPowerSupply(world.func_72805_g(x, y, z))) == 0) {
            this.setStateIfMobInteractsWithPlate(world, x, y, z, lvl);
        }
    }

    protected void setStateIfMobInteractsWithPlate(World world, int x, int y, int z, int stateNew) {
        int stateCur = this.getPlateState(world, x, y, z);
        boolean activeNew = stateNew > 0;
        boolean activeCur = stateCur > 0;
        int meta = world.func_72805_g(x, y, z);
        if (stateNew != stateCur) {
            int activeBit = this.getActiveStateFromWeight(stateCur);
            meta = meta & 0xFFFFFFFE | activeBit;
            world.func_72921_c(x, y, z, meta, 2);
            this.notifyNeighbourOfChange(world, x, y, z);
            world.func_72909_d(x, y, z, x, y, z);
        }
        if (!EnumPlates.isPlateSilent(meta) && activeCur ^ activeNew) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.1, (double)z + 0.5, "random.click", 0.3f, activeNew ? 0.5f : 0.6f);
        }
        if (activeCur) {
            world.func_72836_a(x, y, z, this.field_71990_ca, this.func_71859_p_(world));
        }
    }

    protected AxisAlignedBB getSensitiveAABB(int x, int y, int z) {
        float f = 0.125f;
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + f), (double)y, (double)((float)z + f), (double)((float)(x + 1) - f), (double)y + 0.25, (double)((float)(z + 1) - f));
    }

    public void func_71852_a(World world, int x, int y, int z, int blockID, int metadata) {
        if (this.getPowerSupply(metadata) > 0) {
            this.notifyNeighbourOfChange(world, x, y, z);
        }
        super.func_71852_a(world, x, y, z, blockID, metadata);
    }

    protected void notifyNeighbourOfChange(World world, int x, int y, int z) {
        world.func_72898_h(x, y, z, this.field_71990_ca);
        world.func_72898_h(x, y - 1, z, this.field_71990_ca);
    }

    public int func_71865_a(IBlockAccess blk, int x, int y, int z, int side) {
        return this.getPowerSupply(blk.func_72805_g(x, y, z));
    }

    public int func_71855_c(IBlockAccess blk, int x, int y, int z, int side) {
        return ForgeDirection.getOrientation((int)side).equals((Object)ForgeDirection.UP) ? this.getPowerSupply(blk.func_72805_g(x, y, z)) : 0;
    }

    public boolean func_71853_i() {
        return true;
    }

    public void func_71919_f() {
        float f = 0.5f;
        float f1 = 0.125f;
        float f2 = 0.5f;
        this.func_71905_a(0.5f - f, 0.5f - f1, 0.5f - f2, 0.5f + f, 0.5f + f1, 0.5f + f2);
    }

    public int func_71915_e() {
        return 1;
    }

    protected boolean isPlateActive(int metadata) {
        return (metadata & 1) > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        if (!ForgeDirection.getOrientation((int)side).equals((Object)ForgeDirection.UP) && EnumPlates.isPlateSilent(metadata)) {
            return Block.field_72101_ab.func_71858_a(side, 0);
        }
        return EnumPlates.typeFromMeta((int)metadata).block.func_71851_a(side);
    }

    public int func_71899_b(int metadata) {
        return metadata & 0xFFFFFFFE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int blockID, CreativeTabs tab, List list) {
        for (EnumPlates plate : EnumPlates.values()) {
            if (plate.equals((Object)EnumPlates.UNKNOWN)) continue;
            list.add(new ItemStack(blockID, 1, plate.getMeta(false, false)));
            list.add(new ItemStack(blockID, 1, plate.getMeta(false, true)));
            list.add(new ItemStack(blockID, 1, plate.getMeta(true, false)));
            list.add(new ItemStack(blockID, 1, plate.getMeta(true, true)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconReg) {
    }

    public static enum EnumPlates {
        OBSIDIAN(Block.field_72089_ap, "Players", true, 0.25f),
        MOSSY(Block.field_72087_ao, "NPCs", false, 1.0f),
        UNKNOWN(null, "UNKNOWN", false, 0.0f);

        public final Block block;
        public final String unlocalizedPrefix;
        public final String localizedInsert;
        public final boolean forPlayers;
        public final float hardnessMod;

        private EnumPlates(Block block, String name, boolean player, float hardnessMod) {
            this.block = block;
            this.unlocalizedPrefix = Block.field_72046_aM.func_71917_a() + "." + this.name();
            this.localizedInsert = name;
            this.forPlayers = player;
            this.hardnessMod = hardnessMod;
        }

        public int getMeta(boolean silent, boolean hidden) {
            return (this.ordinal() & 1) << 2 | (silent ? 2 : 0) | (hidden ? 8 : 0);
        }

        public float getHardnessModifier() {
            return this.hardnessMod;
        }

        public ItemStack getIS(boolean silent, boolean hidden) {
            return new ItemStack((Block)ObsidiPlates.blockObsidiPlate, 1, this.getMeta(silent, hidden));
        }

        public static EnumPlates typeFromMeta(int metadata) {
            int plate = metadata >>> 2 & 1;
            if (plate >= UNKNOWN.ordinal()) {
                return UNKNOWN;
            }
            return EnumPlates.values()[plate];
        }

        public static String getUnlocalizedNameFromDamage(int damage) {
            boolean hidden = EnumPlates.isPlateHidden(damage);
            boolean silent = EnumPlates.isPlateSilent(damage);
            String suffix = hidden && silent ? ".both" : (hidden ? ".hidden" : (silent ? ".silent" : ""));
            return EnumPlates.typeFromMeta((int)damage).unlocalizedPrefix.concat(suffix);
        }

        public static boolean isPlayerDetector(int metadata) {
            return EnumPlates.typeFromMeta((int)metadata).forPlayers;
        }

        public static boolean isPlateHidden(int metadata) {
            return (metadata & 8) > 0;
        }

        public static boolean isPlateSilent(int metadata) {
            return (metadata & 2) > 0;
        }

        public static void registerNames(BlockMultiPressurePlate block) {
            for (EnumPlates plate : EnumPlates.values()) {
                if (plate.equals((Object)UNKNOWN)) continue;
                String lname = Block.field_72046_aM.func_71931_t();
                LanguageRegistry.instance().addStringLocalization(plate.unlocalizedPrefix + ".name", lname);
                LanguageRegistry.instance().addStringLocalization(plate.unlocalizedPrefix + ".hidden.name", lname.concat(" (Shrouded)"));
                LanguageRegistry.instance().addStringLocalization(plate.unlocalizedPrefix + ".silent.name", lname.concat(" (Silent)"));
                LanguageRegistry.instance().addStringLocalization(plate.unlocalizedPrefix + ".both.name", lname.concat(" (Shrouded, Silent)"));
            }
        }
    }
}

