/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.netherores.ores;

import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import powercrystals.netherores.NetherOresCore;
import powercrystals.netherores.ores.BlockNetherOres;
import powercrystals.netherores.ores.INetherOre;

public class BlockNetherOverrideOre
extends BlockOre
implements INetherOre {
    private ThreadLocal<Boolean> explode = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private ThreadLocal<Boolean> willAnger = new ThreadLocal();

    public BlockNetherOverrideOre(int n) {
        super(n);
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer entityPlayer, int n, int n2, int n3) {
        boolean bl = entityPlayer == null || !EnchantmentHelper.func_77502_d((EntityLivingBase)entityPlayer);
        this.explode.set(bl);
        this.willAnger.set(true);
        boolean bl2 = super.removeBlockByPlayer(world, entityPlayer, n, n2, n3);
        if (bl || NetherOresCore.silkyStopsPigmen.getBoolean(true)) {
            BlockNetherOres.angerPigmen(entityPlayer, world, n, n2, n3);
        }
        this.willAnger.set(false);
        this.explode.set(true);
        return bl2;
    }

    public void func_71852_a(World world, int n, int n2, int n3, int n4, int n5) {
        Boolean bl;
        if (this.explode.get().booleanValue()) {
            BlockNetherOres.checkExplosionChances((Block)this, world, n, n2, n3);
        }
        if ((bl = this.willAnger.get()) == null || !bl.booleanValue()) {
            BlockNetherOres.angerPigmen(world, n, n2, n3);
        }
        super.func_71852_a(world, n, n2, n3, n4, n5);
    }

    public void onBlockExploded(World world, int n, int n2, int n3, Explosion explosion) {
        this.explode.set(false);
        this.willAnger.set(NetherOresCore.enableMobsAngerPigmen.getBoolean(true) || explosion == null || !(explosion.func_94613_c() instanceof EntityLiving));
        super.onBlockExploded(world, n, n2, n3, explosion);
        this.willAnger.set(true);
        this.explode.set(true);
        if (NetherOresCore.enableExplosionChainReactions.getBoolean(true)) {
            BlockNetherOres.checkExplosionChances((Block)this, world, n, n2, n3);
        }
    }
}

