/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.village.Village;
import openblocks.Config;
import openmods.OpenMods;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableIntArray;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityVillageHighlighter
extends SyncedTileEntity {
    public static int VALUES_PER_VILLAGE = 7;
    public SyncableIntArray villageData;
    private boolean previousBreedStatus = false;

    protected void createSyncedFields() {
        this.villageData = new SyncableIntArray();
    }

    public static int[] convertIntegers(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        Iterator<Integer> iterator = integers.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return ret;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && OpenMods.proxy.getTicks(this.field_70331_k) % 10L == 0L) {
            ArrayList<Integer> tmpDataList = new ArrayList<Integer>();
            for (Village village : this.field_70331_k.field_72982_D.func_75540_b()) {
                if (!village.func_75570_a(this.field_70329_l, this.field_70330_m, this.field_70327_n)) continue;
                tmpDataList.add(village.func_75568_b());
                tmpDataList.add(village.func_75577_a().field_71574_a - this.field_70329_l);
                tmpDataList.add(village.func_75577_a().field_71572_b - this.field_70330_m);
                tmpDataList.add(village.func_75577_a().field_71573_c - this.field_70327_n);
                tmpDataList.add(village.func_75567_c());
                tmpDataList.add(village.func_75562_e());
                tmpDataList.add(System.identityHashCode(village));
            }
            this.villageData.setValue(TileEntityVillageHighlighter.convertIntegers(tmpDataList));
            this.sync();
            boolean canBreed = this.canVillagersBreed();
            if (this.previousBreedStatus != canBreed) {
                this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, Config.blockVillageHighlighterId);
                this.previousBreedStatus = canBreed;
            }
        }
    }

    public SyncableIntArray getVillageData() {
        return this.villageData;
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(200.0, 200.0, 200.0);
    }

    public boolean isPowered() {
        if (this.field_70331_k == null) {
            return false;
        }
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_82115_m() {
        return 65536.0;
    }

    public boolean canVillagersBreed() {
        for (Village village : this.field_70331_k.field_72982_D.func_75540_b()) {
            if (!village.func_75570_a(this.field_70329_l, this.field_70330_m, this.field_70327_n)) continue;
            int i = (int)((double)village.func_75567_c() * 0.35);
            if (village.func_75562_e() >= i) continue;
            return true;
        }
        return false;
    }

    public int getSignalStrength() {
        return this.canVillagersBreed() ? 15 : 0;
    }
}

