/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.common.item.ItemPaintBrush;
import openblocks.common.item.ItemPaintCan;
import openmods.api.IActivateAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;

public class TileEntityPaintCan
extends SyncedTileEntity
implements IPlaceAwareTile,
IActivateAwareTile {
    private SyncableInt color;
    private SyncableInt amount;

    public void onSynced(Set<ISyncableObject> changes) {
    }

    protected void createSyncedFields() {
        this.color = new SyncableInt();
        this.amount = new SyncableInt();
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        this.color.setValue(ItemPaintCan.getColorFromStack(stack));
        this.amount.setValue(ItemPaintCan.getAmountFromStack(stack));
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack heldStack;
        if (!this.field_70331_k.field_72995_K && this.amount.getValue() > 0 && (heldStack = player.func_70694_bm()) != null && heldStack.func_77973_b() instanceof ItemPaintBrush) {
            ItemPaintBrush.setColor(heldStack, this.color.getValue());
            heldStack.func_77964_b(0);
            this.amount.modify(-1);
            this.sync();
            this.field_70331_k.func_72956_a((Entity)player, "liquid.swim", 0.1f, 1.2f);
        }
        if (this.amount.getValue() <= 0 && !this.field_70331_k.field_72995_K) {
            ItemStack item = new ItemStack(Item.field_77788_aw);
            BlockUtils.dropItemStackInWorld((World)this.field_70331_k, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (ItemStack)item);
            this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
        }
        return false;
    }

    public int getColor() {
        return this.color.getValue();
    }

    public int getAmount() {
        return this.amount.getValue();
    }

    public void setAmount(int amt) {
        this.amount.setValue(amt);
    }
}

