/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityImaginary;
import openmods.utils.ColorUtils;
import openmods.utils.ItemUtils;

public class ItemImaginationGlasses
extends ItemArmor {
    private static final String TAG_COLOR = "Color";
    private static final int ARMOR_HELMET = 0;
    public final Type type;

    public static int getGlassesColor(ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        return tag.func_74762_e(TAG_COLOR);
    }

    public ItemImaginationGlasses(int itemId, Type type) {
        super(itemId, EnumArmorMaterial.GOLD, 1, 0);
        this.type = type;
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister registry) {
        this.field_77791_bV = registry.func_94245_a(this.type.iconName);
    }

    public Icon getIcon(ItemStack stack, int pass) {
        return this.field_77791_bV;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return this.type.textureName;
    }

    public boolean checkBlock(TileEntityImaginary.Property property, ItemStack stack, TileEntityImaginary te) {
        return this.type.checkBlock(property, stack, te);
    }

    public void func_77633_a(int itemId, CreativeTabs tab, List result) {
        result.add(new ItemStack((Item)this));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 1;
    }

    public static enum Type {
        PENCIL("pencil"){

            @Override
            protected boolean checkBlock(TileEntityImaginary.Property property, ItemStack stack, TileEntityImaginary te) {
                return te.isPencil() ^ te.isInverted();
            }
        }
        ,
        CRAYON("crayon"){

            @Override
            protected boolean checkBlock(TileEntityImaginary.Property property, ItemStack stack, TileEntityImaginary te) {
                return (!te.isPencil() && ItemImaginationGlasses.getGlassesColor(stack) == te.color) ^ te.isInverted();
            }
        }
        ,
        TECHNICOLOR("technicolor"){

            @Override
            protected boolean checkBlock(TileEntityImaginary.Property property, ItemStack stack, TileEntityImaginary te) {
                if (property == TileEntityImaginary.Property.VISIBLE) {
                    return true;
                }
                return te.isInverted();
            }
        }
        ,
        BASTARD("admin"){

            @Override
            protected boolean checkBlock(TileEntityImaginary.Property property, ItemStack stack, TileEntityImaginary te) {
                return true;
            }
        };

        public final String iconName;
        public final String textureName;
        public static final Type[] VALUES;

        private Type(String name) {
            this.iconName = "openblocks:glasses_" + name;
            this.textureName = "openblocks:textures/models/glasses_" + name + ".png";
        }

        protected abstract boolean checkBlock(TileEntityImaginary.Property var1, ItemStack var2, TileEntityImaginary var3);

        static {
            VALUES = Type.values();
        }
    }

    public static class ItemCrayonGlasses
    extends ItemImaginationGlasses {
        public ItemCrayonGlasses(int itemId) {
            super(itemId, Type.CRAYON);
        }

        @Override
        public void func_77633_a(int itemId, CreativeTabs tab, List result) {
            for (ColorUtils.ColorMeta color : ColorUtils.getAllColors()) {
                result.add(this.createCrayonGlasses(color.rgb));
            }
        }

        public int func_82814_b(ItemStack stack) {
            return ItemCrayonGlasses.getGlassesColor(stack);
        }

        public ItemStack createCrayonGlasses(int color) {
            ItemStack stack = new ItemStack((Item)this);
            NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
            tag.func_74768_a(ItemImaginationGlasses.TAG_COLOR, color);
            return stack;
        }

        @SideOnly(value=Side.CLIENT)
        public int func_82790_a(ItemStack stack, int pass) {
            return ItemCrayonGlasses.getGlassesColor(stack);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, EntityPlayer player, List result, boolean extended) {
            result.add(StatCollector.func_74837_a((String)"openblocks.misc.color", (Object[])new Object[]{this.func_82814_b(stack)}));
        }

        @Override
        public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
            if ("overlay".equals(type)) {
                return "openblocks:textures/models/glasses_crayon_overlay.png";
            }
            return super.getArmorTexture(stack, entity, slot, type);
        }
    }
}

