/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.base.Strings;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import openblocks.common.entity.EntitySmoothMove;

public abstract class EntityAssistant
extends EntitySmoothMove
implements IEntityAdditionalSpawnData {
    private String owner;
    private WeakReference<EntityPlayer> cachedOwner;
    protected double ownerOffsetX;
    protected double ownerOffsetY;
    protected double ownerOffsetZ;

    public EntityAssistant(World world, EntityPlayer owner) {
        super(world);
        this.cachedOwner = new WeakReference<EntityPlayer>(owner);
        if (owner != null) {
            this.owner = owner.func_70023_ak();
        }
    }

    public EntityPlayer findOwner() {
        if (this.owner == null || this.owner.isEmpty()) {
            return null;
        }
        EntityPlayer result = this.field_70170_p.func_72924_a(this.owner);
        if (result != null) {
            this.cachedOwner = new WeakReference<EntityPlayer>(result);
        }
        return result;
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.owner = tag.func_74779_i("Owner");
    }

    protected void func_70014_b(NBTTagCompound tag) {
        if (this.owner != null) {
            tag.func_74778_a("Owner", this.owner);
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer owner = (EntityPlayer)this.cachedOwner.get();
            if (owner == null) {
                owner = this.findOwner();
            }
            if (owner != null) {
                this.smoother.setTarget(owner.field_70165_t + this.ownerOffsetX, owner.field_70163_u + (double)owner.func_70047_e() + this.ownerOffsetY, owner.field_70161_v + this.ownerOffsetZ);
            }
        }
        this.updatePrevPosition();
        this.smoother.update();
    }

    protected void func_70081_e(int par1) {
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70099_a(this.toItemStack(), 0.5f);
        }
        this.func_70106_y();
        return true;
    }

    public abstract ItemStack toItemStack();

    public boolean func_130002_c(EntityPlayer player) {
        if (player instanceof EntityPlayerMP && player.func_70093_af() && this.func_70032_d((Entity)player) < 3.0f) {
            System.out.println("Interact: " + player);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeUTF(Strings.nullToEmpty((String)this.owner));
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.owner = data.readUTF();
    }

    public void setSpawnPosition(Entity owner) {
        this.func_70107_b(owner.field_70165_t + 1.0, owner.field_70163_u + (double)owner.func_70047_e(), owner.field_70161_v);
    }
}

