/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3Pool;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityTarget;
import openmods.block.OpenBlock;

public class BlockTarget
extends OpenBlock {
    private int lastEntityHit = 0;

    public BlockTarget() {
        super(Config.blockTargetId, Material.field_76246_e);
        this.func_71900_a(0.3f);
        this.setRotationMode(OpenBlock.BlockRotationMode.FOUR_DIRECTIONS);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean shouldRenderBlock() {
        return false;
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K && entity != null && entity instanceof EntityArrow) {
            if (this.lastEntityHit != entity.field_70157_k) {
                this.lastEntityHit = entity.field_70157_k;
                return;
            }
            this.lastEntityHit = entity.field_70157_k;
            this.onTargetHit(world, x, y, z, world.func_82732_R().func_72345_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
        }
    }

    public void onTargetHit(World world, int x, int y, int z, Vec3 entityPosition) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile == null || !(tile instanceof TileEntityTarget)) {
            return;
        }
        TileEntityTarget target = (TileEntityTarget)tile;
        if (!target.isEnabled()) {
            return;
        }
        ForgeDirection rotation = target.getRotation();
        ForgeDirection opposite = rotation.getOpposite();
        double centerX = (double)x + 0.5 + (double)opposite.offsetX * 0.5;
        double centerY = (double)y + 0.55 + (double)opposite.offsetY * 0.45;
        double centerZ = (double)z + 0.5 + (double)opposite.offsetZ * 0.5;
        if (opposite == ForgeDirection.NORTH || opposite == ForgeDirection.SOUTH) {
            entityPosition.field_72449_c = centerZ;
        } else if (opposite == ForgeDirection.EAST || opposite == ForgeDirection.WEST) {
            entityPosition.field_72450_a = centerX;
        }
        Vec3Pool pool = world.func_82732_R();
        Vec3 bullseye = pool.func_72345_a(centerX, centerY, centerZ);
        double distance = entityPosition.func_72438_d(bullseye);
        target.setStrength(15 - (int)Math.min(15L, Math.max(0L, Math.round(distance * 32.0))));
    }

    public int func_71865_a(IBlockAccess world, int x, int y, int z, int m) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile != null && tile instanceof TileEntityTarget) {
            return ((TileEntityTarget)tile).getStrength();
        }
        return 0;
    }

    public int func_71855_c(IBlockAccess world, int x, int y, int z, int m) {
        return this.func_71865_a(world, x, y, z, m);
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71911_a_(world, x, y, z);
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71872_e(world, x, y, z);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile == null || !(tile instanceof TileEntityTarget)) {
            return;
        }
        TileEntityTarget target = (TileEntityTarget)tile;
        if (!target.isEnabled()) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.1f, 1.0f);
            return;
        }
        ForgeDirection direction = target.getRotation();
        switch (direction) {
            case EAST: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 0.1f, 1.0f, 1.0f);
                break;
            }
            case WEST: {
                this.func_71905_a(0.9f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case NORTH: {
                this.func_71905_a(0.0f, 0.0f, 0.9f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case SOUTH: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.1f);
                break;
            }
            default: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return this.isOnTopOfSolidBlock(world, x, y, z, side);
    }
}

