/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.MinecraftForgeClient;
import openblocks.client.StencilSkyRenderer;
import openblocks.common.block.BlockSky;
import openmods.renderer.StencilRendererHandler;
import openmods.utils.ColorUtils;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class TileEntitySkyRenderer
extends TileEntitySpecialRenderer {
    private boolean disableStencil;
    private boolean initialized;
    private int displayListBase;
    private StencilRendererHandler handler;

    public void func_76894_a(TileEntity te, double x, double y, double z, float partialTickTime) {
        if (this.disableStencil) {
            return;
        }
        int meta = te.func_70322_n();
        if (!BlockSky.isActive(meta)) {
            return;
        }
        if (!this.initialized) {
            this.intialize();
            this.initialized = true;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        ColorUtils.RGB fog = RenderUtils.getFogColor();
        GL11.glColor3f((float)fog.getR(), (float)fog.getG(), (float)fog.getB());
        GL11.glCallList((int)(this.displayListBase + MinecraftForgeClient.getRenderPass()));
        GL11.glPopMatrix();
        this.handler.markForRender();
    }

    protected void intialize() {
        int stencilBit = MinecraftForgeClient.reserveStencilBit();
        if (stencilBit >= 0) {
            int mask = 1 << stencilBit;
            this.displayListBase = GL11.glGenLists((int)2);
            GL11.glNewList((int)this.displayListBase, (int)4864);
            TileEntitySkyRenderer.renderCube();
            GL11.glEndList();
            GL11.glNewList((int)(this.displayListBase + 1), (int)4864);
            TileEntitySkyRenderer.cutHoleInWorld(mask);
            GL11.glEndList();
            this.handler = new StencilSkyRenderer(mask);
        } else {
            this.disableStencil = true;
        }
    }

    private static void renderCube() {
        Tessellator tes = new Tessellator();
        tes.func_78382_b();
        tes.func_78377_a(0.0, 0.0, 0.0);
        tes.func_78377_a(0.0, 1.0, 0.0);
        tes.func_78377_a(1.0, 1.0, 0.0);
        tes.func_78377_a(1.0, 0.0, 0.0);
        tes.func_78377_a(0.0, 0.0, 1.0);
        tes.func_78377_a(1.0, 0.0, 1.0);
        tes.func_78377_a(1.0, 1.0, 1.0);
        tes.func_78377_a(0.0, 1.0, 1.0);
        tes.func_78377_a(0.0, 0.0, 0.0);
        tes.func_78377_a(0.0, 0.0, 1.0);
        tes.func_78377_a(0.0, 1.0, 1.0);
        tes.func_78377_a(0.0, 1.0, 0.0);
        tes.func_78377_a(1.0, 0.0, 0.0);
        tes.func_78377_a(1.0, 1.0, 0.0);
        tes.func_78377_a(1.0, 1.0, 1.0);
        tes.func_78377_a(1.0, 0.0, 1.0);
        tes.func_78377_a(0.0, 0.0, 0.0);
        tes.func_78377_a(1.0, 0.0, 0.0);
        tes.func_78377_a(1.0, 0.0, 1.0);
        tes.func_78377_a(0.0, 0.0, 1.0);
        tes.func_78377_a(0.0, 1.0, 0.0);
        tes.func_78377_a(0.0, 1.0, 1.0);
        tes.func_78377_a(1.0, 1.0, 1.0);
        tes.func_78377_a(1.0, 1.0, 0.0);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        RenderUtils.disableLightmap();
        tes.func_78381_a();
        RenderUtils.enableLightmap();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
    }

    private static void cutHoleInWorld(int stencilMask) {
        GL11.glStencilMask((int)stencilMask);
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)519, (int)stencilMask, (int)stencilMask);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        TileEntitySkyRenderer.renderCube();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glStencilMask((int)0);
        GL11.glDisable((int)2960);
    }
}

