/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.mutant;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import openblocks.api.IMutant;
import openblocks.api.IMutantRenderer;
import openblocks.utils.MutantUtils;

public class MutantRendererZombie
implements IMutantRenderer {
    private static final ResourceLocation texture = new ResourceLocation("textures/entity/zombie/zombie.png");
    private ModelRenderer bipedHead;
    private ModelRenderer bipedHeadwear;
    private ModelRenderer bipedBody;
    private ModelRenderer bipedRightArm;
    private ModelRenderer bipedLeftArm;
    private ModelRenderer bipedRightLeg;
    private ModelRenderer bipedLeftLeg;

    @Override
    public void initialize(ModelBase base) {
        base.field_78090_t = 64;
        base.field_78089_u = 64;
        this.bipedHead = new ModelRenderer(base, 0, 0);
        this.bipedHead.func_78789_a(-4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.bipedHeadwear = new ModelRenderer(base, 32, 0);
        this.bipedHeadwear.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, 0.5f);
        this.bipedBody = new ModelRenderer(base, 16, 16);
        this.bipedBody.func_78789_a(-4.0f, 0.0f, -2.0f, 8, 12, 4);
        this.bipedRightArm = new ModelRenderer(base, 40, 16);
        this.bipedRightArm.func_78789_a(-3.0f, -2.0f, -2.0f, 4, 12, 4);
        this.bipedLeftArm = new ModelRenderer(base, 40, 16);
        this.bipedLeftArm.field_78809_i = true;
        this.bipedLeftArm.func_78789_a(-1.0f, -2.0f, -2.0f, 4, 12, 4);
        this.bipedRightLeg = new ModelRenderer(base, 0, 16);
        this.bipedRightLeg.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.bipedLeftLeg = new ModelRenderer(base, 0, 16);
        this.bipedLeftLeg.field_78809_i = true;
        this.bipedLeftLeg.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 12, 4);
    }

    @Override
    public void renderHead(IMutant mutant, float scale, float yaw, float pitch) {
        MutantRendererZombie.bindTexture();
        MutantUtils.bindToAttachmentPoint(mutant, this.bipedHead, mutant.getBody().getHeadAttachmentPoint());
        this.bipedHead.field_78795_f = pitch / 57.295776f;
        this.bipedHead.field_78796_g = yaw / 57.295776f;
        this.bipedHead.func_78785_a(scale);
    }

    @Override
    public void renderLegs(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
        MutantRendererZombie.bindTexture();
        Vec3[] legAttachmentPoints = mutant.getBody().getLegAttachmentPoints(mutant.getLegs().getNumberOfLegs());
        MutantUtils.bindToAttachmentPoint(mutant, this.bipedLeftLeg, legAttachmentPoints[0]);
        MutantUtils.bindToAttachmentPoint(mutant, this.bipedRightLeg, legAttachmentPoints[1]);
        this.bipedRightLeg.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f)) * 1.4f * prevLegSwing;
        this.bipedLeftLeg.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f + (float)Math.PI)) * 1.4f * prevLegSwing;
        this.bipedRightLeg.field_78796_g = 0.0f;
        this.bipedLeftLeg.field_78796_g = 0.0f;
        this.bipedLeftLeg.func_78785_a(scale);
        this.bipedRightLeg.func_78785_a(scale);
    }

    @Override
    public void renderBody(IMutant mutant, float scale) {
        this.bipedBody.func_78793_a(0.0f, 24.0f - (float)mutant.getLegHeight() - (float)mutant.getBodyHeight(), 0.0f);
        MutantRendererZombie.bindTexture();
        this.bipedBody.func_78785_a(scale);
    }

    @Override
    public void renderWings(IMutant mutant, float scale, float wingSwing) {
    }

    @Override
    public void renderArms(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
        MutantRendererZombie.bindTexture();
        Vec3[] armAttachmentPoints = mutant.getBody().getArmAttachmentPoints();
        MutantUtils.bindToAttachmentPoint(mutant, this.bipedLeftArm, armAttachmentPoints[0]);
        MutantUtils.bindToAttachmentPoint(mutant, this.bipedRightArm, armAttachmentPoints[1]);
        float onGround = mutant.getArmSwingProgress(scale);
        float var8 = MathHelper.func_76126_a((float)(onGround * (float)Math.PI));
        float var9 = MathHelper.func_76126_a((float)((1.0f - (1.0f - onGround) * (1.0f - onGround)) * (float)Math.PI));
        this.bipedRightArm.field_78808_h = 0.0f;
        this.bipedLeftArm.field_78808_h = 0.0f;
        this.bipedRightArm.field_78796_g = -(0.1f - var8 * 0.6f);
        this.bipedLeftArm.field_78796_g = 0.1f - var8 * 0.6f;
        this.bipedRightArm.field_78795_f = -1.5707964f;
        this.bipedLeftArm.field_78795_f = -1.5707964f;
        this.bipedRightArm.field_78795_f -= var8 * 1.2f - var9 * 0.4f;
        this.bipedLeftArm.field_78795_f -= var8 * 1.2f - var9 * 0.4f;
        this.bipedRightArm.field_78808_h += MathHelper.func_76134_b((float)(legSwing * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.field_78808_h -= MathHelper.func_76134_b((float)(legSwing * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.field_78795_f += MathHelper.func_76126_a((float)(legSwing * 0.067f)) * 0.05f;
        this.bipedLeftArm.field_78795_f -= MathHelper.func_76126_a((float)(legSwing * 0.067f)) * 0.05f;
        this.bipedRightArm.func_78785_a(scale);
        this.bipedLeftArm.func_78785_a(scale);
    }

    @Override
    public void renderTail(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
    }

    private static void bindTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }
}

