/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;

public class EntitySelectionHandler {
    private final Map<Class<? extends Entity>, ISelectionRenderer<Entity>> registry = Maps.newIdentityHashMap();

    public static <I extends Entity> void registerRenderer(Class<I> cls, ISelectionRenderer<I> renderer) {
        RegisterSelectionRendererEvent evt = new RegisterSelectionRendererEvent();
        evt.cls = cls;
        evt.renderer = renderer;
        MinecraftForge.EVENT_BUS.post(evt);
    }

    @ForgeSubscribe
    public void renderEvents(RenderWorldLastEvent evt) {
        ISelectionRenderer<Entity> renderer;
        Entity target;
        Minecraft mc = evt.context.field_72777_q;
        if (mc.field_71476_x != null && (target = mc.field_71476_x.field_72308_g) instanceof ISelectAware && (renderer = this.registry.get(mc.field_71476_x.field_72308_g.getClass())) != null) {
            renderer.render(target, (EntityPlayer)mc.field_71439_g, evt.context, evt.partialTicks);
        }
    }

    @ForgeSubscribe
    public void handleRegister(RegisterSelectionRendererEvent<?> evt) {
        this.registry.put(evt.cls, evt.renderer);
    }

    public static class RegisterSelectionRendererEvent<I extends Entity>
    extends Event {
        public Class<I> cls;
        public ISelectionRenderer<I> renderer;
    }

    public static interface ISelectionRenderer<E extends Entity> {
        public void render(E var1, EntityPlayer var2, RenderGlobal var3, float var4);
    }

    public static interface ISelectAware {
    }
}

