/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import extracells.ItemEnum;
import extracells.tileentity.ColorableECTile;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class TileEntityTransitionPlaneFluid
extends ColorableECTile
implements IGridMachine,
IDirectionalMETile {
    Boolean powerStatus = true;
    Boolean networkReady = true;
    Boolean updated = false;
    IGridInterface grid;

    public void func_70316_g() {
        if (this.isMachineActive() && this.getGrid() != null && !this.updated.booleanValue()) {
            this.updated = true;
            this.doWork();
        }
    }

    public void doWork() {
        if (this.isMachineActive() && this.getGrid() != null) {
            ForgeDirection orientation = ForgeDirection.getOrientation((int)this.func_70322_n());
            int offsetID = this.field_70331_k.func_72798_a(this.field_70329_l + orientation.offsetX, this.field_70330_m + orientation.offsetY, this.field_70327_n + orientation.offsetZ);
            int offsetMeta = this.field_70331_k.func_72805_g(this.field_70329_l + orientation.offsetX, this.field_70330_m + orientation.offsetY, this.field_70327_n + orientation.offsetZ);
            IMEInventoryHandler cellArray = this.getGrid().getCellArray();
            if (cellArray != null) {
                try {
                    if (Block.field_71973_m[offsetID] instanceof IFluidBlock) {
                        FluidStack simulation = ((IFluidBlock)Block.field_71973_m[offsetID]).drain(this.field_70331_k, this.field_70329_l + orientation.offsetX, this.field_70330_m + orientation.offsetY, this.field_70327_n + orientation.offsetZ, false);
                        if (simulation != null && cellArray.calculateItemAddition(Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), simulation.amount, simulation.fluidID))) == null) {
                            ((IFluidBlock)Block.field_71973_m[offsetID]).drain(this.field_70331_k, this.field_70329_l + orientation.offsetX, this.field_70330_m + orientation.offsetY, this.field_70327_n + orientation.offsetZ, true);
                            cellArray.addItems(Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), simulation.amount, simulation.fluidID)));
                        }
                    } else if (offsetID == FluidRegistry.WATER.getBlockID() && offsetMeta == 0) {
                        if (cellArray.calculateItemAddition(Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1000, FluidRegistry.WATER.getID()))) == null) {
                            this.field_70331_k.func_94571_i(this.field_70329_l + orientation.offsetX, this.field_70330_m + orientation.offsetY, this.field_70327_n + orientation.offsetZ);
                            cellArray.addItems(Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1000, FluidRegistry.WATER.getID())));
                        }
                    } else if (offsetID == FluidRegistry.LAVA.getBlockID() && offsetMeta == 0 && cellArray.calculateItemAddition(Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1000, FluidRegistry.LAVA.getID()))) == null) {
                        this.field_70331_k.func_94571_i(this.field_70329_l + orientation.offsetX, this.field_70330_m + orientation.offsetY, this.field_70327_n + orientation.offsetZ);
                        cellArray.addItems(Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1000, FluidRegistry.LAVA.getID())));
                    }
                }
                catch (Throwable wontHappen) {
                    // empty catch block
                }
            }
        }
    }

    public void func_70312_q() {
        super.func_70312_q();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileLoadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public void func_70313_j() {
        super.func_70313_j();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileUnloadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public Packet func_70319_e() {
        NBTTagCompound nbtTag = this.getColorDataForPacket();
        this.func_70310_b(nbtTag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbtTag);
    }

    public WorldCoord getLocation() {
        return new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isValid() {
        return true;
    }

    public void setPowerStatus(boolean hasPower) {
        this.powerStatus = hasPower;
    }

    public boolean isPowered() {
        return this.powerStatus;
    }

    public IGridInterface getGrid() {
        return this.grid;
    }

    public void setGrid(IGridInterface gi) {
        this.grid = gi;
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public boolean canConnect(ForgeDirection dir) {
        return dir.ordinal() != this.field_70325_p;
    }

    public float getPowerDrainPerTick() {
        return 0.0f;
    }

    public void setNetworkReady(boolean isReady) {
        this.networkReady = isReady;
    }

    public boolean isMachineActive() {
        return this.powerStatus != false && this.networkReady != false;
    }
}

