/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.events.GridPatternUpdateEvent;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.IStorageAware;
import appeng.api.me.util.ICraftingPattern;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import extracells.ItemEnum;
import extracells.tileentity.ColorableECTile;
import extracells.util.ECPrivateInventory;
import extracells.util.SpecialFluidStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileEntityTerminalFluid
extends ColorableECTile
implements IGridMachine,
IDirectionalMETile,
IStorageAware,
ISidedInventory {
    Boolean powerStatus = false;
    Boolean networkReady = true;
    IGridInterface grid;
    private String customName = StatCollector.func_74838_a((String)"tile.block.fluid.terminal");
    private Fluid currentFluid = null;
    ArrayList<SpecialFluidStack> fluidsInNetwork = new ArrayList();
    ArrayList<Fluid> craftableFluidsInNetwork = new ArrayList();
    ECPrivateInventory inventory = new ECPrivateInventory(this.customName, 2, 64){

        @Override
        public boolean func_94041_b(int i, ItemStack itemstack) {
            return FluidContainerRegistry.isContainer((ItemStack)itemstack) || itemstack != null && itemstack.func_77973_b() instanceof IFluidContainerItem;
        }
    };

    public TileEntityTerminalFluid() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K && this.isMachineActive()) {
            IFluidContainerItem fluidContainerItem;
            ItemStack inputTemp;
            ItemStack input = this.getInventory().func_70301_a(0);
            ItemStack output = this.getInventory().func_70301_a(1);
            if (!this.fluidsInNetwork.isEmpty()) {
                if (this.currentFluid == null) {
                    this.currentFluid = FluidRegistry.getFluid((int)this.fluidsInNetwork.get(0).getID());
                }
                if (this.currentFluid != null && input != null) {
                    if (FluidContainerRegistry.isEmptyContainer((ItemStack)input)) {
                        FluidStack request = new FluidStack(this.currentFluid, 1000);
                        ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)request, (ItemStack)input);
                        if (filledContainer != null) {
                            if (output == null) {
                                if (this.drainFluid(request)) {
                                    this.getInventory().func_70299_a(1, FluidContainerRegistry.fillFluidContainer((FluidStack)request, (ItemStack)input));
                                    this.getInventory().func_70298_a(0, 1);
                                }
                            } else if (output.func_77985_e() && output.field_77994_a < output.func_77976_d() && output.func_77973_b() == filledContainer.func_77973_b() && output.func_77960_j() == filledContainer.func_77960_j() && output.func_77978_p() == filledContainer.func_77978_p() && this.drainFluid(request)) {
                                ++output.field_77994_a;
                                this.getInventory().func_70298_a(0, 1);
                            }
                        }
                    } else if (input.func_77973_b() instanceof IFluidContainerItem) {
                        inputTemp = input.func_77946_l();
                        inputTemp.field_77994_a = 1;
                        fluidContainerItem = (IFluidContainerItem)inputTemp.func_77973_b();
                        if (fluidContainerItem.getFluid(inputTemp) == null || fluidContainerItem.getFluid((ItemStack)inputTemp).amount == 0) {
                            FluidStack request = new FluidStack(this.currentFluid, fluidContainerItem.getCapacity(inputTemp));
                            ItemStack inputToBeFilled = inputTemp.func_77946_l();
                            int filled = fluidContainerItem.fill(inputToBeFilled, request, true);
                            inputToBeFilled.field_77994_a = 1;
                            if (filled >= request.amount) {
                                if (output == null) {
                                    if (this.drainFluid(request)) {
                                        this.getInventory().func_70299_a(1, inputToBeFilled);
                                        this.getInventory().func_70298_a(0, 1);
                                    }
                                } else if (output != null && output.field_77993_c == inputToBeFilled.field_77993_c && (!inputToBeFilled.func_77981_g() || inputToBeFilled.func_77960_j() == output.func_77960_j()) && ItemStack.func_77970_a((ItemStack)inputToBeFilled, (ItemStack)output) && output.field_77994_a + inputToBeFilled.field_77994_a <= inputToBeFilled.func_77976_d() && this.drainFluid(request)) {
                                    ++output.field_77994_a;
                                    this.getInventory().func_70298_a(0, 1);
                                }
                            }
                        }
                    }
                }
            }
            if (FluidContainerRegistry.isFilledContainer((ItemStack)input)) {
                ItemStack drainedContainer = input.func_77973_b().getContainerItemStack(input);
                if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)input) != null) {
                    if (output == null) {
                        if (this.fillFluid(FluidContainerRegistry.getFluidForFilledItem((ItemStack)input))) {
                            this.getInventory().func_70299_a(1, drainedContainer);
                            this.getInventory().func_70298_a(0, 1);
                        }
                    } else if (output.func_77985_e() && output.field_77994_a < output.func_77976_d()) {
                        if (drainedContainer == null) {
                            if (this.fillFluid(FluidContainerRegistry.getFluidForFilledItem((ItemStack)input))) {
                                this.getInventory().func_70298_a(0, 1);
                            }
                        } else if (output.func_77985_e() && output.field_77994_a < output.func_77976_d() && output.func_77973_b() == drainedContainer.func_77973_b() && output.func_77960_j() == drainedContainer.func_77960_j() && output.func_77978_p() == drainedContainer.func_77978_p() && this.fillFluid(FluidContainerRegistry.getFluidForFilledItem((ItemStack)input))) {
                            ++output.field_77994_a;
                            this.getInventory().func_70298_a(0, 1);
                        }
                    }
                }
            } else if (input != null && input.func_77973_b() instanceof IFluidContainerItem) {
                inputTemp = input.func_77946_l();
                inputTemp.field_77994_a = 1;
                fluidContainerItem = (IFluidContainerItem)inputTemp.func_77973_b();
                FluidStack containedFluid = fluidContainerItem.getFluid(inputTemp);
                if (containedFluid != null && containedFluid.amount > 0) {
                    ItemStack inputToBeDrained = inputTemp.func_77946_l();
                    FluidStack drained = fluidContainerItem.drain(inputToBeDrained, containedFluid.amount, true);
                    inputToBeDrained.field_77994_a = 1;
                    if (drained != null && drained.amount >= containedFluid.amount) {
                        if (output == null) {
                            if (this.fillFluid(containedFluid)) {
                                this.getInventory().func_70299_a(1, inputToBeDrained);
                                this.getInventory().func_70298_a(0, 1);
                            }
                        } else if (output.func_77985_e() && output.field_77994_a < output.func_77976_d() && output != null && output.field_77993_c == inputToBeDrained.field_77993_c && (!inputToBeDrained.func_77981_g() || inputToBeDrained.func_77960_j() == output.func_77960_j()) && ItemStack.func_77970_a((ItemStack)inputToBeDrained, (ItemStack)output) && output.field_77994_a + inputToBeDrained.field_77994_a <= inputToBeDrained.func_77976_d() && this.fillFluid(containedFluid)) {
                            ++output.field_77994_a;
                            this.getInventory().func_70298_a(0, 1);
                        }
                    }
                }
            }
        }
    }

    public ECPrivateInventory getInventory() {
        return this.inventory;
    }

    @ForgeSubscribe
    public void onNetworkPatternChange(GridPatternUpdateEvent e) {
        IMEInventoryHandler inventoryHandler;
        if (this.grid != null && (inventoryHandler = this.grid.getCraftableArray()) != null) {
            this.craftableFluidsInNetwork = new ArrayList();
            for (IAEItemStack stack : inventoryHandler.getAvailableItems()) {
                if (stack.getItem() != ItemEnum.FLUIDDISPLAY.getItemInstance()) continue;
                this.craftableFluidsInNetwork.add(FluidRegistry.getFluid((int)stack.getItemDamage()));
            }
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
    }

    public void onNetworkInventoryChange(IItemList iss) {
        this.updateFluids(iss);
    }

    public void updateFluids(IItemList currentItems) {
        this.fluidsInNetwork = new ArrayList();
        if (this.grid != null) {
            for (IAEItemStack itemstack : currentItems) {
                if (itemstack.getItem() != ItemEnum.FLUIDDISPLAY.getItemInstance() || itemstack.getStackSize() <= 0L) continue;
                this.fluidsInNetwork.add(new SpecialFluidStack(itemstack.getItemDamage(), itemstack.getStackSize()));
            }
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
    }

    public List<SpecialFluidStack> getFluids() {
        return this.fluidsInNetwork;
    }

    public List<Fluid> getCurrentCraftables() {
        return this.craftableFluidsInNetwork;
    }

    public Packet func_70319_e() {
        NBTTagCompound nbtTag = this.getColorDataForPacket();
        this.func_70310_b(nbtTag);
        NBTTagCompound fluids = new NBTTagCompound();
        int[] fluidIDs = new int[this.fluidsInNetwork.size()];
        for (int i = 0; i < this.fluidsInNetwork.size(); ++i) {
            fluidIDs[i] = this.fluidsInNetwork.get(i).getID();
            fluids.func_74772_a("FluidAmount#" + i, this.fluidsInNetwork.get(i).getAmount());
        }
        fluids.func_74783_a("FluidIDs", fluidIDs);
        nbtTag.func_74766_a("fluids", fluids);
        NBTTagCompound craftableFluids = new NBTTagCompound();
        int[] craftableFluidIDs = new int[this.craftableFluidsInNetwork.size()];
        for (int i = 0; i < this.craftableFluidsInNetwork.size(); ++i) {
            craftableFluidIDs[i] = this.craftableFluidsInNetwork.get(i).getID();
        }
        craftableFluids.func_74783_a("FluidIDs", craftableFluidIDs);
        nbtTag.func_74766_a("craftablefluids", craftableFluids);
        nbtTag.func_74768_a("currentFluid", this.currentFluid != null ? this.currentFluid.getID() : -1);
        nbtTag.func_74757_a("powered", this.isPowered());
        nbtTag.func_74757_a("ready", this.networkReady.booleanValue());
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbtTag);
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        super.onDataPacket(net, packet);
        this.func_70307_a(packet.field_73331_e);
        NBTTagCompound fluids = packet.field_73331_e.func_74775_l("fluids");
        this.fluidsInNetwork = new ArrayList();
        int[] fluidIDs = fluids.func_74759_k("FluidIDs");
        for (int i = 0; i < fluidIDs.length; ++i) {
            this.fluidsInNetwork.add(new SpecialFluidStack(fluidIDs[i], fluids.func_74763_f("FluidAmount#" + i)));
        }
        NBTTagCompound craftableFluids = packet.field_73331_e.func_74775_l("craftablefluids");
        this.craftableFluidsInNetwork = new ArrayList();
        int[] craftableFluidIDs = craftableFluids.func_74759_k("FluidIDs");
        for (int i = 0; i < craftableFluidIDs.length; ++i) {
            this.craftableFluidsInNetwork.add(FluidRegistry.getFluid((int)craftableFluidIDs[i]));
        }
        this.currentFluid = FluidRegistry.getFluid((int)packet.field_73331_e.func_74762_e("currentFluid"));
        this.powerStatus = packet.field_73331_e.func_74767_n("powered");
        this.networkReady = packet.field_73331_e.func_74767_n("ready");
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    private boolean fillFluid(FluidStack toImport) {
        IMEInventoryHandler cellArray;
        IAEItemStack toFill = Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 0, toImport.fluidID));
        toFill.setStackSize((long)toImport.amount);
        if (this.grid != null && (cellArray = this.grid.getCellArray()) != null) {
            IAEItemStack sim = cellArray.calculateItemAddition(toFill.copy());
            if (sim != null) {
                return false;
            }
            cellArray.addItems(toFill.copy());
            return true;
        }
        return false;
    }

    private boolean drainFluid(FluidStack toExport) {
        IMEInventoryHandler cellArray;
        IAEItemStack toDrain = Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 0, toExport.fluidID));
        toDrain.setStackSize((long)toExport.amount);
        if (this.grid != null && (cellArray = this.grid.getCellArray()) != null) {
            for (SpecialFluidStack fluidstack : this.fluidsInNetwork) {
                if (fluidstack.getID() != toExport.fluidID || fluidstack.amount < (long)toExport.amount) continue;
                IAEItemStack takenStack = cellArray.extractItems(Util.createItemStack((ItemStack)new ItemStack(toDrain.getItem(), (int)toDrain.getStackSize(), toDrain.getItemDamage())));
                if (takenStack == null) {
                    return false;
                }
                if (takenStack.getStackSize() != (long)((int)toDrain.getStackSize())) {
                    cellArray.addItems(takenStack);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void setCurrentFluid(int fluidID) {
        this.currentFluid = FluidRegistry.getFluid((int)fluidID);
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
    }

    public Fluid getCurrentFluid() {
        return this.currentFluid;
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.slots.size(); ++i) {
            if (this.inventory.slots.get(i) == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory.slots.get(i).func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.getInventory().func_94042_c()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        nbt.func_74768_a("currentFluid", this.currentFluid != null ? this.currentFluid.getID() : -1);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagList nbttaglist = nbt.func_74761_m("Items");
        this.inventory.readFromNBT(nbttaglist);
        if (nbt.func_74764_b("CustomName")) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        this.currentFluid = FluidRegistry.getFluid((int)nbt.func_74762_e("currentFluid"));
    }

    public void func_70312_q() {
        super.func_70312_q();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileLoadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public void func_70313_j() {
        super.func_70313_j();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileUnloadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public WorldCoord getLocation() {
        return new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isValid() {
        return true;
    }

    public void setPowerStatus(boolean hasPower) {
        this.powerStatus = hasPower;
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isPowered() {
        return this.powerStatus;
    }

    public IGridInterface getGrid() {
        return this.grid;
    }

    public void setGrid(IGridInterface gi) {
        if (!this.field_70331_k.field_72995_K) {
            this.grid = gi;
            if (gi != null) {
                IMEInventoryHandler cellArray = gi.getCellArray();
                if (cellArray != null) {
                    this.updateFluids(cellArray.getAvailableItems());
                }
            } else {
                this.setPowerStatus(false);
            }
            PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
        }
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public boolean canConnect(ForgeDirection dir) {
        return dir.ordinal() != this.field_70325_p;
    }

    public float getPowerDrainPerTick() {
        return 5.0f;
    }

    public void setNetworkReady(boolean isReady) {
        IMEInventoryHandler cellArray;
        this.networkReady = isReady;
        if (this.getGrid() != null && (cellArray = this.getGrid().getCellArray()) != null) {
            this.updateFluids(cellArray.getAvailableItems());
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
    }

    public boolean isMachineActive() {
        return this.powerStatus != false && this.networkReady != false;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return this.inventory.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public String func_70303_b() {
        return this.inventory.func_70303_b();
    }

    public boolean func_94042_c() {
        return this.inventory.func_94042_c();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.inventory.func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.inventory.func_94041_b(i, itemstack);
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.inventory.func_94041_b(i, itemstack) && i == 0;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 1;
    }

    public void requestFluid(FluidStack toOrder) {
        ItemStack order = new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1, toOrder.fluidID);
        ICraftingPattern pattern = this.grid.getPatternFor(order);
        System.out.println(pattern == null);
        try {
            this.grid.craftingRequest(order);
        }
        catch (AppEngTileMissingException wontHappen) {
            // empty catch block
        }
    }
}

