/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.IStorageAware;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import extracells.ItemEnum;
import extracells.items.ItemFluidDisplay;
import extracells.tileentity.ColorableECTile;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileEntityMonitorStorageFluid
extends ColorableECTile
implements IGridMachine,
IDirectionalMETile,
IStorageAware {
    private IGridInterface grid;
    private boolean locked;
    private boolean matrixed;
    private boolean powerStatus = false;
    private boolean networkReady = true;
    private Fluid fluid;
    private long fluidAmount;

    public void setLocked(boolean _locked) {
        this.locked = _locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setMatrixed() {
        this.matrixed = true;
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
    }

    public boolean isMatrixed() {
        return this.matrixed;
    }

    public void setFluid(Fluid _fluid) {
        this.fluid = _fluid;
        if (this.grid != null && this.grid.getCellArray() != null) {
            this.onNetworkInventoryChange(this.getGrid().getCellArray().getAvailableItems());
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public long getAmount() {
        return this.fluidAmount;
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTag) {
        super.func_70310_b(nbtTag);
        nbtTag.func_74778_a("fluid", this.fluid != null ? this.fluid.getName() : "");
        nbtTag.func_74757_a("matrixed", this.matrixed);
        nbtTag.func_74757_a("locked", this.locked);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTag) {
        super.func_70307_a(nbtTag);
        this.fluid = FluidRegistry.getFluid((String)nbtTag.func_74779_i("fluid"));
        this.matrixed = nbtTag.func_74767_n("matrixed");
        this.locked = nbtTag.func_74767_n("locked");
    }

    public void onNetworkInventoryChange(IItemList iss) {
        long lastAmount = this.fluidAmount;
        this.fluidAmount = 0L;
        if (this.fluid != null) {
            for (IAEItemStack stack : iss) {
                if (stack == null || stack.getItem() != ItemEnum.FLUIDDISPLAY.getItemInstance() || stack.getItemDamage() != this.fluid.getID()) continue;
                this.fluidAmount += stack.getStackSize();
            }
        }
        if (lastAmount != this.fluidAmount) {
            lastAmount = this.fluidAmount;
            PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound nbtTag = this.getColorDataForPacket();
        this.func_70310_b(nbtTag);
        nbtTag.func_74757_a("networkReady", this.networkReady);
        nbtTag.func_74757_a("powerStatus", this.powerStatus);
        nbtTag.func_74772_a("amount", this.fluidAmount);
        nbtTag.func_74768_a("meta", this.func_70322_n());
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbtTag);
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        super.onDataPacket(net, packet);
        this.func_70307_a(packet.field_73331_e);
        this.networkReady = packet.field_73331_e.func_74767_n("networkReady");
        this.powerStatus = packet.field_73331_e.func_74767_n("powerStatus");
        this.fluidAmount = packet.field_73331_e.func_74763_f("amount");
        this.field_70325_p = packet.field_73331_e.func_74762_e("meta");
    }

    public void func_70312_q() {
        super.func_70312_q();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileLoadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public void func_70313_j() {
        super.func_70313_j();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileUnloadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public WorldCoord getLocation() {
        return new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isValid() {
        return true;
    }

    public void setPowerStatus(boolean hasPower) {
        this.powerStatus = hasPower;
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isPowered() {
        return this.powerStatus;
    }

    public IGridInterface getGrid() {
        return this.grid;
    }

    public void setGrid(IGridInterface gi) {
        if (!this.field_70331_k.field_72995_K) {
            this.grid = gi;
            if (gi != null) {
                IMEInventoryHandler cellArray = gi.getCellArray();
                if (cellArray != null) {
                    this.onNetworkInventoryChange(cellArray.getAvailableItems());
                }
            } else {
                this.setPowerStatus(false);
            }
            PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
        }
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public boolean canConnect(ForgeDirection dir) {
        return dir.ordinal() != this.func_70322_n();
    }

    public float getPowerDrainPerTick() {
        return 5.0f;
    }

    public void setNetworkReady(boolean isReady) {
        IMEInventoryHandler cellArray;
        this.networkReady = isReady;
        if (this.getGrid() != null && (cellArray = this.getGrid().getCellArray()) != null) {
            this.onNetworkInventoryChange(cellArray.getAvailableItems());
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
    }

    public boolean isMachineActive() {
        return this.powerStatus && this.networkReady;
    }

    public boolean drainFluid(FluidStack toExport) {
        IMEInventoryHandler cellArray;
        IAEItemStack toDrain = Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 0, toExport.fluidID));
        toDrain.setStackSize((long)toExport.amount);
        if (this.grid != null && (cellArray = this.grid.getCellArray()) != null) {
            for (IAEItemStack fluidstack : cellArray.getAvailableItems()) {
                if (fluidstack == null || !(fluidstack.getItem() instanceof ItemFluidDisplay) || fluidstack.getItemDamage() != toExport.fluidID || fluidstack.getStackSize() < (long)toExport.amount) continue;
                IAEItemStack takenStack = cellArray.extractItems(Util.createItemStack((ItemStack)new ItemStack(toDrain.getItem(), (int)toDrain.getStackSize(), toDrain.getItemDamage())));
                if (takenStack == null) {
                    return false;
                }
                if (takenStack.getStackSize() != (long)((int)toDrain.getStackSize())) {
                    cellArray.addItems(takenStack);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public ItemStack fillContainer(ItemStack container) {
        int amountDrained;
        IFluidContainerItem fluidContainer;
        FluidStack inContainer;
        container.field_77994_a = 1;
        Item item = container.func_77973_b();
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)container)) {
            ItemStack toReturn = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(this.fluid, 1000), (ItemStack)container);
            if (toReturn != null && this.drainFluid(FluidContainerRegistry.getFluidForFilledItem((ItemStack)toReturn))) {
                return toReturn;
            }
        } else if (item instanceof IFluidContainerItem && ((inContainer = (fluidContainer = (IFluidContainerItem)item).getFluid(container)) == null || inContainer.amount <= 0) && (amountDrained = fluidContainer.fill(container, new FluidStack(this.fluid, fluidContainer.getCapacity(container)), true)) >= 0 && this.drainFluid(new FluidStack(this.fluid, amountDrained))) {
            return container;
        }
        return null;
    }
}

