/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.WorldCoord;
import appeng.api.config.RedstoneModeInput;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.IStorageAware;
import appeng.api.me.tiles.ITileCable;
import appeng.api.me.util.IGridInterface;
import cpw.mods.fml.common.network.PacketDispatcher;
import extracells.BlockEnum;
import extracells.ItemEnum;
import extracells.tileentity.ColorableECTile;
import extracells.util.ECPrivateInventory;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityLevelEmitterFluid
extends ColorableECTile
implements IGridMachine,
IDirectionalMETile,
ITileCable,
IStorageAware {
    private Boolean powerStatus = true;
    private Boolean networkReady = true;
    private IGridInterface grid;
    private long currentAmount = 0L;
    private long filterAmount = 0L;
    private String customName = StatCollector.func_74838_a((String)"tile.block.fluid.levelemitter");
    private ECPrivateInventory inventory = new ECPrivateInventory(this.customName, 1, 1);
    private RedstoneModeInput redstoneAction = RedstoneModeInput.WhenOff;

    public int getRedstonePowerBySide(ForgeDirection side) {
        switch (this.redstoneAction) {
            case WhenOff: {
                return side.getOpposite().ordinal() == this.func_70322_n() && this.currentAmount < this.filterAmount ? 15 : 0;
            }
            case WhenOn: {
                return side.getOpposite().ordinal() == this.func_70322_n() && this.currentAmount > this.filterAmount ? 15 : 0;
            }
        }
        return 0;
    }

    public Packet func_70319_e() {
        NBTTagCompound nbtTag = this.getColorDataForPacket();
        this.func_70310_b(nbtTag);
        nbtTag.func_74772_a("currentAmount", this.currentAmount);
        nbtTag.func_74772_a("filterAmount", this.filterAmount);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbtTag);
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        super.onDataPacket(net, packet);
        this.func_70307_a(packet.field_73331_e);
        this.currentAmount = packet.field_73331_e.func_74763_f("currentAmount");
        this.filterAmount = packet.field_73331_e.func_74763_f("filterAmount");
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void updateRedstoneStates() {
        for (ForgeDirection currentSide : ForgeDirection.values()) {
            Block neighbor = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l + currentSide.offsetX, this.field_70330_m + currentSide.offsetY, this.field_70327_n + currentSide.offsetZ)];
            if (neighbor == null) continue;
            neighbor.func_71863_a(this.field_70331_k, this.field_70329_l + currentSide.offsetX, this.field_70330_m + currentSide.offsetY, this.field_70327_n + currentSide.offsetZ, BlockEnum.FLUIDLEVELEMITTER.getBlockInstance().field_71990_ca);
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void setAmount(long filterAmount) {
        this.filterAmount += filterAmount;
        if (this.filterAmount < 0L) {
            this.filterAmount = 0L;
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
    }

    public long getAmount() {
        return this.filterAmount;
    }

    public void onNetworkInventoryChange(IItemList iss) {
        if (this.inventory.slots.get(0) != null && iss != null) {
            for (IAEItemStack currentStack : iss) {
                if (currentStack == null || currentStack.getItem() != ItemEnum.FLUIDDISPLAY.getItemInstance() || currentStack.getItemDamage() != this.inventory.slots.get(0).func_77960_j() || currentStack.getStackSize() == this.currentAmount) continue;
                this.currentAmount = currentStack.getStackSize();
                this.updateRedstoneStates();
            }
        } else if (this.inventory.slots.get(0) == null) {
            this.currentAmount = 0L;
        }
    }

    public void func_70312_q() {
        super.func_70312_q();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileLoadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public void func_70313_j() {
        super.func_70313_j();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileUnloadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public WorldCoord getLocation() {
        return new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isValid() {
        return true;
    }

    public void setPowerStatus(boolean hasPower) {
        this.powerStatus = hasPower;
    }

    public boolean isPowered() {
        return this.powerStatus;
    }

    public IGridInterface getGrid() {
        return this.grid;
    }

    public void setGrid(IGridInterface gi) {
        this.grid = gi;
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public boolean canConnect(ForgeDirection dir) {
        return dir.ordinal() != this.field_70325_p;
    }

    public float getPowerDrainPerTick() {
        return 0.0f;
    }

    public boolean coveredConnections() {
        return false;
    }

    public void setNetworkReady(boolean isReady) {
        this.networkReady = isReady;
    }

    public boolean isMachineActive() {
        return this.powerStatus != false && this.networkReady != false;
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74782_a("Items", (NBTBase)this.inventory.writeToNBT());
        if (this.getInventory().func_94042_c()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        nbt.func_74768_a("RedstoneMode", this.getRedstoneAction().ordinal());
        nbt.func_74772_a("filterAmount", this.filterAmount);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagList nbttaglist = nbt.func_74761_m("Items");
        this.inventory.readFromNBT(nbttaglist);
        if (nbt.func_74764_b("CustomName")) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        this.redstoneAction = RedstoneModeInput.values()[nbt.func_74762_e("RedstoneMode")];
        this.filterAmount = nbt.func_74763_f("filterAmount");
    }

    public ECPrivateInventory getInventory() {
        return this.inventory;
    }

    public RedstoneModeInput getRedstoneAction() {
        return this.redstoneAction;
    }

    public void setRedstoneAction(RedstoneModeInput action) {
        this.redstoneAction = action;
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
        this.updateRedstoneStates();
    }
}

