/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import cpw.mods.fml.common.network.PacketDispatcher;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityCertusTank
extends TileEntity
implements IFluidHandler {
    private FluidStack lastBeforeUpdate = null;
    protected FluidTank tank = new FluidTank(32000){

        public FluidTank readFromNBT(NBTTagCompound nbt) {
            if (!nbt.func_74764_b("Empty")) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                this.setFluid(fluid);
            } else {
                this.setFluid(null);
            }
            return this;
        }
    };

    public Packet func_70319_e() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_70310_b(nbtTag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbtTag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.func_70307_a(packet.field_73331_e);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.readFromNBTWithoutCoords(tag);
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.writeToNBTWithoutCoords(tag);
    }

    public void writeToNBTWithoutCoords(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tag) {
        this.tank.readFromNBT(tag);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || this.tank.getFluid() != null && resource.fluidID != this.tank.getFluid().fluidID) {
            return 0;
        }
        return this.fill(resource, doFill, true);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.tank.getFluid() == null) {
            return null;
        }
        return this.drain(resource, doDrain, true);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.tank.getFluid() == null) {
            return null;
        }
        return this.drain(from, new FluidStack(this.tank.getFluid(), maxDrain), doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluid() == null || this.tank.getFluid().getFluid() == fluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluid() == null || this.tank.getFluid().getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getTankInfo(true);
    }

    public FluidStack drain(FluidStack fluid, boolean doDrain, boolean findMainTank) {
        TileEntity offTE;
        if (findMainTank) {
            Fluid offFluid;
            int yOff = 0;
            TileEntity offTE2 = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + yOff, this.field_70327_n);
            TileEntityCertusTank mainTank = this;
            while (offTE2 != null && offTE2 instanceof TileEntityCertusTank && (offFluid = ((TileEntityCertusTank)offTE2).getFluid()) != null && offFluid == fluid.getFluid()) {
                mainTank = (TileEntityCertusTank)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + yOff, this.field_70327_n);
                offTE2 = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + ++yOff, this.field_70327_n);
            }
            return mainTank != null ? mainTank.drain(fluid, doDrain, false) : null;
        }
        FluidStack drained = this.tank.drain(fluid.amount, doDrain);
        this.compareAndUpdate();
        if ((drained == null || drained.amount < fluid.amount) && (offTE = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n)) instanceof TileEntityCertusTank) {
            TileEntityCertusTank tank = (TileEntityCertusTank)offTE;
            FluidStack externallyDrained = tank.drain(new FluidStack(fluid.fluidID, fluid.amount - (drained != null ? drained.amount : 0)), doDrain, false);
            if (externallyDrained != null) {
                return new FluidStack(fluid.fluidID, (drained != null ? drained.amount : 0) + externallyDrained.amount);
            }
            return drained;
        }
        return drained;
    }

    public int fill(FluidStack fluid, boolean doFill, boolean findMainTank) {
        TileEntity offTE;
        if (findMainTank) {
            Fluid offFluid;
            int yOff = 0;
            TileEntity offTE2 = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - yOff, this.field_70327_n);
            TileEntityCertusTank mainTank = this;
            while (offTE2 != null && offTE2 instanceof TileEntityCertusTank && ((offFluid = ((TileEntityCertusTank)offTE2).getFluid()) == null || offFluid == fluid.getFluid())) {
                mainTank = (TileEntityCertusTank)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - yOff, this.field_70327_n);
                offTE2 = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - ++yOff, this.field_70327_n);
            }
            return mainTank != null ? mainTank.fill(fluid, doFill, false) : 0;
        }
        int filled = this.tank.fill(fluid, doFill);
        this.compareAndUpdate();
        if (filled < fluid.amount && (offTE = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)) instanceof TileEntityCertusTank) {
            TileEntityCertusTank tank = (TileEntityCertusTank)offTE;
            return filled + tank.fill(new FluidStack(fluid.fluidID, fluid.amount - filled), doFill, false);
        }
        return filled;
    }

    public FluidTankInfo[] getTankInfo(boolean goToMainTank) {
        if (!goToMainTank) {
            return new FluidTankInfo[]{this.tank.getInfo()};
        }
        int amount = 0;
        int capacity = 0;
        Fluid fluid = null;
        int yOff = 0;
        TileEntity offTE = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - yOff, this.field_70327_n);
        TileEntityCertusTank mainTank = this;
        while (offTE != null && offTE instanceof TileEntityCertusTank && (((TileEntityCertusTank)offTE).getFluid() == null || ((TileEntityCertusTank)offTE).getFluid() == this.getFluid())) {
            mainTank = (TileEntityCertusTank)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - yOff, this.field_70327_n);
            offTE = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - ++yOff, this.field_70327_n);
        }
        yOff = 0;
        offTE = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + yOff, this.field_70327_n);
        while (offTE != null && offTE instanceof TileEntityCertusTank && ((mainTank = (TileEntityCertusTank)offTE).getFluid() == null || mainTank.getFluid() == this.getFluid())) {
            FluidTankInfo info = mainTank.getTankInfo(false)[0];
            if (info != null) {
                capacity += info.capacity;
                if (info.fluid != null) {
                    amount += info.fluid.amount;
                    if (info.fluid.getFluid() != null) {
                        fluid = info.fluid.getFluid();
                    }
                }
            }
            offTE = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + ++yOff, this.field_70327_n);
        }
        return new FluidTankInfo[]{new FluidTankInfo(fluid != null ? new FluidStack(fluid, amount) : null, capacity)};
    }

    public Fluid getFluid() {
        FluidStack tankFluid = this.tank.getFluid();
        return tankFluid != null && tankFluid.amount > 0 ? tankFluid.getFluid() : null;
    }

    public void compareAndUpdate() {
        FluidStack current = this.tank.getFluid();
        if (current != null) {
            if (this.lastBeforeUpdate != null) {
                if (Math.abs(current.amount - this.lastBeforeUpdate.amount) >= 500) {
                    PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
                    this.lastBeforeUpdate = current.copy();
                } else if (this.lastBeforeUpdate.amount < this.tank.getCapacity() && current.amount == this.tank.getCapacity() || this.lastBeforeUpdate.amount == this.tank.getCapacity() && current.amount < this.tank.getCapacity()) {
                    PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
                    this.lastBeforeUpdate = current.copy();
                }
            } else {
                PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
                this.lastBeforeUpdate = current.copy();
            }
        } else if (this.lastBeforeUpdate != null) {
            PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
            this.lastBeforeUpdate = null;
        }
    }

    public Fluid getRenderFluid() {
        return this.tank.getFluid() != null ? this.tank.getFluid().getFluid() : null;
    }

    public float getRenderScale() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }
}

