/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.me.tiles.IColoredMETile;
import appeng.api.me.tiles.IConnectionSensitive;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public abstract class ColorableECTile
extends TileEntity
implements IConnectionSensitive,
IColoredMETile {
    private Set<ForgeDirection> connections;
    private Set<ForgeDirection> visualConnections;
    private int color = -1;

    public void func_70310_b(NBTTagCompound nbtTag) {
        super.func_70310_b(nbtTag);
        nbtTag.func_74768_a("Color", this.color);
    }

    public void func_70307_a(NBTTagCompound nbtTag) {
        if (nbtTag.func_74764_b("x")) {
            this.field_70329_l = nbtTag.func_74762_e("x");
        }
        if (nbtTag.func_74764_b("y")) {
            this.field_70330_m = nbtTag.func_74762_e("y");
        }
        if (nbtTag.func_74764_b("z")) {
            this.field_70327_n = nbtTag.func_74762_e("z");
        }
        this.color = nbtTag.func_74762_e("Color");
    }

    public void onMEConnectionsChanged(Set<ForgeDirection> connections, Set<ForgeDirection> visualConnections) {
        this.connections = connections;
        this.visualConnections = visualConnections;
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
    }

    public Set<ForgeDirection> getVisualConnections() {
        return this.visualConnections;
    }

    public boolean isColored() {
        return this.color != -1;
    }

    public boolean isColored(ForgeDirection input) {
        return this.isColored();
    }

    public void setColor(int offset) {
        this.color = offset;
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
    }

    public int getColor() {
        return this.color;
    }

    public NBTTagCompound getColorDataForPacket() {
        int counter;
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_70310_b(nbtTag);
        if (this.connections != null) {
            int[] connectionInts = new int[this.connections.size()];
            counter = 0;
            for (ForgeDirection direction : this.connections) {
                connectionInts[counter] = direction.ordinal();
                ++counter;
            }
            nbtTag.func_74783_a("ValidDirections", connectionInts);
        }
        if (this.visualConnections != null) {
            int[] visualConnectionInts = new int[this.visualConnections.size()];
            counter = 0;
            for (ForgeDirection direction : this.visualConnections) {
                visualConnectionInts[counter] = direction.ordinal();
                ++counter;
            }
            nbtTag.func_74783_a("ValidVisualDirections", visualConnectionInts);
        }
        return nbtTag;
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.connections = new HashSet<ForgeDirection>();
        for (int directionInt : packet.field_73331_e.func_74759_k("ValidDirections")) {
            this.connections.add(ForgeDirection.getOrientation((int)directionInt));
        }
        this.visualConnections = new HashSet<ForgeDirection>();
        for (int directionInt : packet.field_73331_e.func_74759_k("ValidVisualDirections")) {
            this.visualConnections.add(ForgeDirection.getOrientation((int)directionInt));
        }
    }
}

