/*
 * Decompiled with CFR 0.152.
 */
package extracells.handler;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.Util;
import appeng.api.config.FuzzyMode;
import appeng.api.config.ItemFlow;
import appeng.api.config.ListMode;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import extracells.ItemEnum;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidBusInventoryHandler
implements IMEInventoryHandler {
    public IFluidHandler tank;
    ForgeDirection facing;
    public int priority;
    List<ItemStack> filter;
    public TileEntity updateTarget;
    public IGridInterface grid;
    public IMEInventoryHandler parent;

    public FluidBusInventoryHandler(IFluidHandler tank, ForgeDirection facing, int priority, List<ItemStack> filter) {
        this.tank = tank;
        this.facing = facing;
        this.priority = priority;
        this.filter = filter;
    }

    public long storedItemTypes() {
        if (this.tank != null && this.getTankInfo(this.tank) != null) {
            return this.getTankInfo((IFluidHandler)this.tank)[0].fluid != null ? 1L : 0L;
        }
        return 0L;
    }

    public long storedItemCount() {
        if (this.tank != null && this.getTankInfo(this.tank) != null) {
            return this.getTankInfo((IFluidHandler)this.tank)[0].fluid.amount;
        }
        return 0L;
    }

    public long remainingItemCount() {
        if (this.tank != null && this.getTankInfo(this.tank) != null && this.getTankInfo((IFluidHandler)this.tank)[0].fluid != null) {
            return this.getTankInfo((IFluidHandler)this.tank)[0].capacity - this.getTankInfo((IFluidHandler)this.tank)[0].fluid.amount;
        }
        return 0L;
    }

    public long remainingItemTypes() {
        if (this.tank != null && this.getTankInfo(this.tank) != null && this.getTankInfo((IFluidHandler)this.tank)[0].fluid == null) {
            return 1L;
        }
        return 0L;
    }

    public boolean containsItemType(IAEItemStack aeitemstack) {
        if (aeitemstack != null && this.tank != null && this.getTankInfo(this.tank) != null && this.getTankInfo(this.tank)[0] != null && this.getTankInfo((IFluidHandler)this.tank)[0].fluid != null) {
            if (this.getTankInfo((IFluidHandler)this.tank)[0].fluid == null) {
                return false;
            }
            return aeitemstack.getItem() == ItemEnum.FLUIDDISPLAY.getItemInstance() && aeitemstack.getItemDamage() == this.getTankInfo((IFluidHandler)this.tank)[0].fluid.fluidID;
        }
        return false;
    }

    public long getTotalItemTypes() {
        return 1L;
    }

    public long countOfItemType(IAEItemStack aeitemstack) {
        if (this.tank != null && this.getTankInfo(this.tank) != null && this.getTankInfo(this.tank)[0] != null && this.getTankInfo((IFluidHandler)this.tank)[0].fluid != null) {
            return aeitemstack.getItem() == ItemEnum.FLUIDDISPLAY.getItemInstance() ? (aeitemstack.getItemDamage() == this.getTankInfo((IFluidHandler)this.tank)[0].fluid.fluidID ? (long)this.getTankInfo((IFluidHandler)this.tank)[0].fluid.amount : 0L) : 0L;
        }
        return 0L;
    }

    public IAEItemStack addItems(IAEItemStack input) {
        IAEItemStack addedStack = input.copy();
        if (input.getItem() == ItemEnum.FLUIDDISPLAY.getItemInstance() && (!this.isPreformatted() || this.isPreformatted() && this.isItemInPreformattedItems(input.getItemStack())) && this.tank != null && (this.getTankInfo(this.tank) == null || this.getTankInfo((IFluidHandler)this.tank)[0].fluid == null || FluidRegistry.getFluid((int)input.getItemDamage()) == this.tank.getTankInfo((ForgeDirection)this.facing)[0].fluid.getFluid())) {
            int filled = 0;
            for (long i = 0L; i < input.getStackSize() / 25L; ++i) {
                filled += this.tank.fill(this.facing, new FluidStack(input.getItemDamage(), 25), true);
            }
            int remainder = (int)(input.getStackSize() - input.getStackSize() / 25L * 25L);
            if (remainder > 0) {
                filled += this.tank.fill(this.facing, new FluidStack(input.getItemDamage(), remainder), true);
            }
            addedStack.setStackSize(input.getStackSize() - (long)filled);
            ((TileEntity)this.tank).func_70296_d();
            if (addedStack != null && addedStack.getStackSize() == 0L) {
                addedStack = null;
            }
            return addedStack;
        }
        return addedStack;
    }

    public IAEItemStack extractItems(IAEItemStack request) {
        IAEItemStack removedStack = request.copy();
        if (request.getItem() == ItemEnum.FLUIDDISPLAY.getItemInstance() && this.tank != null && this.getTankInfo(this.tank) != null && this.getTankInfo((IFluidHandler)this.tank)[0].fluid != null && FluidRegistry.getFluid((int)request.getItemDamage()) == this.getTankInfo((IFluidHandler)this.tank)[0].fluid.getFluid()) {
            FluidStack drainedStack;
            long drainedAmount = 0L;
            for (long i = 0L; i < request.getStackSize() / 25L; ++i) {
                FluidStack drainedStack2 = this.tank.drain(this.facing, 25, true);
                if (drainedStack2 == null || drainedStack2.amount == 0) continue;
                drainedAmount += (long)drainedStack2.amount;
            }
            int remainder = (int)(request.getStackSize() - request.getStackSize() / 25L * 25L);
            if (remainder > 0 && (drainedStack = this.tank.drain(this.facing, remainder, true)) != null && drainedStack.amount != 0) {
                drainedAmount += (long)drainedStack.amount;
            }
            ((TileEntity)this.tank).func_70296_d();
            if (drainedAmount == 0L) {
                return null;
            }
            removedStack.setStackSize(drainedAmount);
            return removedStack;
        }
        return null;
    }

    public IItemList getAvailableItems(IItemList out) {
        if (this.tank != null && this.getTankInfo(this.tank) != null && this.getTankInfo((IFluidHandler)this.tank)[0].fluid != null && this.getTankInfo((IFluidHandler)this.tank)[0].fluid.getFluid() != null) {
            IAEItemStack currentItemStack = Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1, this.getTankInfo((IFluidHandler)this.tank)[0].fluid.getFluid().getID()));
            currentItemStack.setStackSize((long)this.getTankInfo((IFluidHandler)this.tank)[0].fluid.amount);
            out.add(currentItemStack);
        }
        return out;
    }

    public boolean isItemInPreformattedItems(ItemStack request) {
        for (ItemStack itemstack : this.getPreformattedItems()) {
            if (itemstack.func_77973_b() != request.func_77973_b() || itemstack.func_77960_j() != request.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public IItemList getAvailableItems() {
        return this.getAvailableItems(Util.createItemList());
    }

    public IAEItemStack calculateItemAddition(IAEItemStack input) {
        IAEItemStack addedStack = input.copy();
        if (input.getItem() == ItemEnum.FLUIDDISPLAY.getItemInstance() && (!this.isPreformatted() || this.isPreformatted() && this.isItemInPreformattedItems(input.getItemStack())) && this.tank != null && this.getTankInfo(this.tank) != null && (this.getTankInfo((IFluidHandler)this.tank)[0].fluid == null || FluidRegistry.getFluid((int)input.getItemDamage()) == this.getTankInfo((IFluidHandler)this.tank)[0].fluid.getFluid())) {
            int filled = 0;
            for (long i = 0L; i < input.getStackSize() / 25L; ++i) {
                filled += this.tank.fill(this.facing, new FluidStack(input.getItemDamage(), 25), false);
            }
            int remainder = (int)(input.getStackSize() - input.getStackSize() / 25L * 25L);
            if (remainder > 0) {
                filled += this.tank.fill(this.facing, new FluidStack(input.getItemDamage(), remainder), false);
            }
            addedStack.setStackSize(input.getStackSize() - (long)filled);
            ((TileEntity)this.tank).func_70296_d();
            if (addedStack != null && addedStack.getStackSize() == 0L) {
                addedStack = null;
            }
            return addedStack;
        }
        return addedStack;
    }

    public long getAvailableSpaceByItem(IAEItemStack itemstack, long maxNeeded) {
        if (itemstack != null) {
            if (this.remainingItemCount() > 0L) {
                return itemstack.getItem() == ItemEnum.FLUIDDISPLAY.getItemInstance() ? this.remainingItemCount() : 0L;
            }
            for (IAEItemStack stack : this.getAvailableItems()) {
                if (stack == null || stack.getItem() != itemstack.getItem() || stack.getItemDamage() != itemstack.getItemDamage()) continue;
                return this.remainingItemCount();
            }
        }
        return 0L;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public long totalBytes() {
        if (this.tank != null) {
            return this.getTankInfo(this.tank) != null ? (long)this.getTankInfo((IFluidHandler)this.tank)[0].capacity : 0L;
        }
        return 0L;
    }

    public long freeBytes() {
        if (this.tank != null && this.getTankInfo(this.tank) != null) {
            return this.getTankInfo((IFluidHandler)this.tank)[0].fluid != null ? (long)(this.getTankInfo((IFluidHandler)this.tank)[0].capacity - this.getTankInfo((IFluidHandler)this.tank)[0].fluid.amount) : (long)this.getTankInfo((IFluidHandler)this.tank)[0].capacity;
        }
        return 0L;
    }

    public long usedBytes() {
        if (this.tank != null) {
            return this.getTankInfo(this.tank) != null ? (long)this.getTankInfo((IFluidHandler)this.tank)[0].fluid.amount : 0L;
        }
        return 0L;
    }

    public FluidTankInfo[] getTankInfo(IFluidHandler tank) {
        if (tank != null) {
            if (tank.getTankInfo(this.facing) != null && tank.getTankInfo(this.facing).length != 0) {
                return tank.getTankInfo(this.facing);
            }
            if (tank.getTankInfo(ForgeDirection.UNKNOWN) != null && tank.getTankInfo(ForgeDirection.UNKNOWN).length != 0) {
                return tank.getTankInfo(ForgeDirection.UNKNOWN);
            }
        }
        return null;
    }

    public long unusedItemCount() {
        return this.freeBytes();
    }

    public boolean canHoldNewItem() {
        return this.getAvailableItems().getItems().isEmpty();
    }

    public void setUpdateTarget(TileEntity e) {
        this.updateTarget = e;
    }

    public List<ItemStack> getPreformattedItems() {
        return this.filter;
    }

    public boolean isPreformatted() {
        return !this.filter.isEmpty();
    }

    public boolean isFuzzyPreformatted() {
        return false;
    }

    public void setFuzzyPreformatted(boolean nf) {
    }

    public void setName(String name) {
    }

    public String getName() {
        return "";
    }

    public void setGrid(IGridInterface grid) {
        this.grid = grid;
    }

    public IGridInterface getGrid() {
        return this.grid;
    }

    public void setParent(IMEInventoryHandler parent) {
        this.parent = parent;
    }

    public IMEInventoryHandler getParent() {
        return this.parent;
    }

    public void removeGrid(IGridInterface grid, IMEInventoryHandler ignore, List<IMEInventoryHandler> duplicates) {
    }

    public void validate(List<IMEInventoryHandler> duplicates) {
    }

    public boolean canAccept(IAEItemStack input) {
        if (input != null && input.getItem() == ItemEnum.FLUIDDISPLAY.getItemInstance()) {
            if (this.getAvailableItems() != null) {
                for (IAEItemStack current : this.getAvailableItems()) {
                    if (current != null && current.getItemDamage() != input.getItemDamage()) continue;
                    return true;
                }
                if (this.getAvailableItems().size() == 0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public ItemFlow getFlow() {
        return ItemFlow.READ_WRITE;
    }

    public void setFlow(ItemFlow p) {
    }

    public FuzzyMode getFuzzyModePreformatted() {
        return FuzzyMode.Percent_99;
    }

    public void setPreformattedItems(IItemList in, FuzzyMode mode, ListMode m) {
    }

    public ListMode getListMode() {
        return ListMode.BLACKLIST;
    }
}

