/*
 * Decompiled with CFR 0.152.
 */
package extracells.blocks;

import appeng.api.Blocks;
import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.events.GridStorageUpdateEvent;
import appeng.api.me.items.IMemoryCard;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.Extracells;
import extracells.blocks.RotatableColorBlock;
import extracells.tileentity.TileEntityBusFluidStorage;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockBusFluidStorage
extends RotatableColorBlock {
    @SideOnly(value=Side.CLIENT)
    Icon frontIcon;
    @SideOnly(value=Side.CLIENT)
    Icon sideIcon;
    @SideOnly(value=Side.CLIENT)
    Icon bottomIcon;
    @SideOnly(value=Side.CLIENT)
    Icon topIcon;

    public BlockBusFluidStorage(int id) {
        super(id, Material.field_76246_e);
        this.func_71849_a(Extracells.ModTab);
        this.func_71864_b("block.fluid.bus.storage");
        this.func_71848_c(2.0f);
        this.func_71894_b(10.0f);
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return -1;
    }

    public boolean func_71926_d() {
        return false;
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityBusFluidStorage();
    }

    public Icon func_71858_a(int side, int metadata) {
        return Blocks.blkInterface.func_77954_c();
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float offsetX, float offsetY, float offsetZ) {
        if (!world.field_72995_K) {
            ItemStack currentItem = player.field_71071_by.func_70448_g();
            if (currentItem != null) {
                IMemoryCard card = Util.getAppEngApi().getMemoryCardHandler();
                TileEntity blockTE = world.func_72796_p(x, y, z);
                if (card.isMemoryCard(currentItem)) {
                    if (player.func_70093_af()) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        blockTE.func_70310_b(nbt);
                        nbt.func_82580_o("x");
                        nbt.func_82580_o("y");
                        nbt.func_82580_o("z");
                        blockTE.func_70307_a(nbt);
                        card.setMemoryCardContents(currentItem, this.func_71917_a() + ".name", nbt);
                        player.func_70006_a(new ChatMessageComponent().func_111079_a(StatCollector.func_74838_a((String)"ChatMsg.SettingsSaved")));
                        return true;
                    }
                    if (card.getSettingsName(currentItem).equals(this.func_71917_a() + ".name") || card.getSettingsName(currentItem).equals("AppEng.GuiITooltip.Blank")) {
                        blockTE.func_70307_a(card.getData(currentItem));
                        Packet description = blockTE.func_70319_e();
                        if (description != null) {
                            PacketDispatcher.sendPacketToAllPlayers((Packet)description);
                        }
                        player.func_70006_a(new ChatMessageComponent().func_111079_a(StatCollector.func_74838_a((String)"ChatMsg.SettingsLoaded")));
                        return true;
                    }
                    player.func_70006_a(new ChatMessageComponent().func_111079_a(StatCollector.func_74838_a((String)"ChatMsg.IncorrectDevice")));
                    return true;
                }
            }
            if (world.func_72796_p(x, y, z) == null || player.func_70093_af()) {
                return false;
            }
            PacketDispatcher.sendPacketToPlayer((Packet)world.func_72796_p(x, y, z).func_70319_e(), (Player)((Player)player));
            player.openGui((Object)Extracells.instance, 2, world, x, y, z);
        }
        return true;
    }

    public void func_71863_a(World world, int x, int y, int z, int neighbourID) {
        TileEntity blockTE = world.func_72796_p(x, y, z);
        if (blockTE instanceof TileEntityBusFluidStorage) {
            TileEntityBusFluidStorage storageBus = (TileEntityBusFluidStorage)blockTE;
            if (!world.field_72995_K) {
                storageBus.updateGrid();
                PacketDispatcher.sendPacketToAllPlayers((Packet)world.func_72796_p(x, y, z).func_70319_e());
                MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(world, new WorldCoord(x, y, z), storageBus.getGrid()));
            }
            ForgeDirection blockOrientation = ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z));
            TileEntity fluidHandler = world.func_72796_p(x + blockOrientation.offsetX, y + blockOrientation.offsetY, z + blockOrientation.offsetZ);
            storageBus.setFluidHandler(fluidHandler instanceof IFluidHandler ? (IFluidHandler)fluidHandler : null);
        }
    }
}

