/*
 * Decompiled with CFR 0.152.
 */
package extracells;

import appeng.api.ICellHandler;
import appeng.api.Util;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import extracells.BlockEnum;
import extracells.ItemEnum;
import extracells.gui.widget.WidgetFluidModes;
import extracells.handler.FluidCellHandler;
import extracells.integration.logisticspipes.LPHelper;
import extracells.network.PacketHandler;
import extracells.proxy.CommonProxy;
import extracells.render.RenderHandler;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;

@Mod(modid="extracells", name="Extra Cells", dependencies="after:LogisticsPipes|Main;after:Waila;required-after:AppliedEnergistics")
@NetworkMod(channels={"ExtraCells"}, clientSideRequired=true, serverSideRequired=false, packetHandler=PacketHandler.class)
public class Extracells {
    @Mod.Instance(value="extracells")
    public static Extracells instance;
    public static CreativeTabs ModTab;
    public static int renderID;
    @SidedProxy(clientSide="extracells.proxy.ClientProxy", serverSide="extracells.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static boolean debug;
    public static boolean shortenedBuckets;
    public static int tickRateExport;
    public static int tickRateImport;
    public static int tickRateStorage;
    public static int tickRateChamber;
    public static LPHelper lpHelper;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        instance = this;
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        for (ItemEnum itemEnum : ItemEnum.values()) {
            itemEnum.setID(config.getItem(itemEnum.getIDName() + "_ID", itemEnum.getID(), itemEnum.getDescription()).getInt());
        }
        for (Enum enum_ : BlockEnum.values()) {
            ((BlockEnum)enum_).setID(config.getBlock(((BlockEnum)enum_).getIDName() + "_ID", ((BlockEnum)enum_).getID(), ((BlockEnum)enum_).getDescription()).getInt());
        }
        tickRateExport = config.get("Tick Rates", "tickRateExportBus", 20, "Every x ticks the export bus ticks. mb/t get adjusted automatically ;)").getInt();
        tickRateImport = config.get("Tick Rates", "tickRateImportBus", 20, "Every x ticks the import bus ticks. mb/t get adjusted automatically ;)").getInt();
        tickRateStorage = config.get("Tick Rates", "tickRateStorageBus", 20, "Every x ticks the storage bus ticks. mb/t get adjusted automatically ;)").getInt();
        tickRateChamber = config.get("Tick Rates", "tickRateCraftingChamber", 20, "Every x ticks the crafting chamber  ticks. mb/t get adjusted automatically ;)").getInt();
        WidgetFluidModes.FluidMode.DROPS.setAmount(config.get("Fluid Rates", "rateDrop", 20, "The Amount of Fluid being filled/drained per tick on the \"Drop\"-Amount").getInt());
        WidgetFluidModes.FluidMode.QUART.setAmount(config.get("Fluid Rates", "rateQuart", 250, "The Amount of Fluid being filled/drained per tick on the \"Quart\"-Amount").getInt());
        WidgetFluidModes.FluidMode.BUCKETS.setAmount(config.get("Fluid Rates", "rateBucket", 1000, "The Amount of Fluid being filled/drained per tick on the \"Bucket\"-Amount").getInt());
        WidgetFluidModes.FluidMode.DROPS.setCost(config.get("Energy Rates", "rateDrop", 5.0, "The Energy Cost per fill/drain operation on the \"Drop\"-Amount").getDouble(5.0));
        WidgetFluidModes.FluidMode.QUART.setCost(config.get("Energy Rates", "rateQuart", 30.0, "The Energy Cost per fill/drain operation on the \"Quart\"-Amount").getDouble(30.0));
        WidgetFluidModes.FluidMode.BUCKETS.setCost(config.get("Energy Rates", "rateBucket", 60.0, "The Energy Cost per fill/drain operation on the \"Bucket\"-Amount").getDouble(60.0));
        if (tickRateExport <= 0) {
            tickRateExport = 20;
        }
        if (tickRateImport <= 0) {
            tickRateImport = 20;
        }
        if (tickRateStorage <= 0) {
            tickRateStorage = 20;
        }
        debug = config.get("Dev Options", "showFluidsInMETerminal", false, "Dont't activate if you dont want to debug stuff ;)").getBoolean(false);
        shortenedBuckets = config.get("Render Options", "shortenBucketsInTerminal", true, "Do you want to show 1kB or 1000000mB?").getBoolean(true);
        config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.RegisterItems();
        proxy.RegisterBlocks();
        proxy.RegisterRenderers();
        proxy.RegisterTileEntities();
        proxy.addRecipes();
        if (!debug) {
            Util.addBasicBlackList((int)ItemEnum.FLUIDDISPLAY.getItemInstance().field_77779_bT, (int)Short.MAX_VALUE);
        }
        Util.getCellRegistry().addCellHandler((ICellHandler)new FluidCellHandler());
        LanguageRegistry.instance().addStringLocalization("itemGroup.Extra_Cells", "en_US", "Extra Cells");
        renderID = RenderingRegistry.getNextAvailableRenderId();
        RenderHandler handler = new RenderHandler(renderID);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)handler);
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"extracells.integration.WAILA.WailaDataProvider.callbackRegister");
        proxy.registerMovables();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.checkForIDMismatches();
        lpHelper = new LPHelper();
    }

    static {
        ModTab = new CreativeTabs("Extra_Cells"){

            public ItemStack getIconItemStack() {
                return new ItemStack(ItemEnum.STORAGEPHYSICAL.getItemInstance(), 1, 4);
            }
        };
    }
}

