/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.tileentity;

import cpw.mods.fml.common.FMLCommonHandler;
import hardcorequesting.QuestingData;
import hardcorequesting.Team;
import hardcorequesting.quests.Quest;
import hardcorequesting.tileentity.TileEntityTracker;
import net.minecraft.entity.player.EntityPlayer;

public enum TrackerType {
    TEAM("Team Tracker", "Emits a redstone signal depending on how many teams that have completed the selected quest. Players without teams count as separate one person teams."){

        @Override
        public int getMeta(TileEntityTracker tracker, Quest quest, int radius) {
            int meta = 0;
            for (Team team : QuestingData.getAllTeams()) {
                boolean valid;
                if (!team.getQuestData((int)quest.getId()).completed) continue;
                boolean bl = valid = radius == 0;
                if (!valid) {
                    for (Team.PlayerEntry entry : team.getPlayers()) {
                        EntityPlayer player;
                        if (!entry.isInTeam() || (player = QuestingData.getPlayer(entry.getName())) == null || !TrackerType.isPlayerWithinRadius(tracker, player, radius)) continue;
                        valid = true;
                        break;
                    }
                }
                if (!valid || ++meta != 15) continue;
                break;
            }
            return meta;
        }
    }
    ,
    PLAYER("Player Tracker", "Emits a redstone signal depending on how many players that have completed this quest."){

        @Override
        public int getMeta(TileEntityTracker tracker, Quest quest, int radius) {
            int meta = 0;
            block0: for (Team team : QuestingData.getAllTeams()) {
                if (!team.getQuestData((int)quest.getId()).completed) continue;
                for (Team.PlayerEntry entry : team.getPlayers()) {
                    EntityPlayer player;
                    boolean valid;
                    if (!entry.isInTeam()) continue;
                    boolean bl = valid = radius == 0;
                    if (!valid && (player = QuestingData.getPlayer(entry.getName())) != null && TrackerType.isPlayerWithinRadius(tracker, player, radius)) {
                        valid = true;
                    }
                    if (!valid || ++meta != 15) continue;
                    continue block0;
                }
            }
            return meta;
        }
    }
    ,
    PROGRESS_MAX("Progress Tracker (Max)", "Emits a redstone signal depending on the progress of this quest for the player/team that has the highest progress. This will only emit at full strength if someone has completed the quest."){

        @Override
        public int getMeta(TileEntityTracker tracker, Quest quest, int radius) {
            int meta = 0;
            for (Team team : QuestingData.getAllTeams()) {
                boolean valid;
                int newMeta = (int)(quest.getProgress(team) * 15.0f);
                if (newMeta <= meta) continue;
                boolean bl = valid = radius == 0;
                if (!valid) {
                    for (Team.PlayerEntry entry : team.getPlayers()) {
                        EntityPlayer player;
                        if (!entry.isInTeam() || (player = QuestingData.getPlayer(entry.getName())) == null || !TrackerType.isPlayerWithinRadius(tracker, player, radius)) continue;
                        valid = true;
                        break;
                    }
                }
                if (!valid) continue;
                meta = newMeta;
            }
            return meta;
        }
    }
    ,
    PROGRESS_CLOSE("Progress Tracker (Close)", "Emits a redstone signal depending on the progress of the nearest player. This will only emit at full strength if that player has completed the quest. This mode requires the players to be online, no matter the radius setting."){

        @Override
        public int getMeta(TileEntityTracker tracker, Quest quest, int radius) {
            double closest = 0.0;
            EntityPlayer closestPlayer = null;
            for (String name : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72369_d()) {
                EntityPlayer player = QuestingData.getPlayer(name);
                if (player == null) continue;
                double distance = player.func_70092_e((double)tracker.field_70329_l + 0.5, (double)tracker.field_70330_m + 0.5, (double)tracker.field_70327_n + 0.5);
                if (closestPlayer != null && !(distance < closest)) continue;
                closest = distance;
                closestPlayer = player;
            }
            if (closestPlayer != null) {
                return (int)(quest.getProgress(QuestingData.getQuestingData(closestPlayer).getTeam()) * 15.0f);
            }
            return 0;
        }
    };

    private String name;
    private String description;

    private static boolean isPlayerWithinRadius(TileEntityTracker tracker, EntityPlayer player, int radius) {
        return player.func_70092_e((double)tracker.field_70329_l + 0.5, (double)tracker.field_70330_m + 0.5, (double)tracker.field_70327_n + 0.5) < (double)(radius * radius);
    }

    private TrackerType(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract int getMeta(TileEntityTracker var1, Quest var2, int var3);
}

