/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.QuestingData;
import hardcorequesting.Team;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenuPortal;
import hardcorequesting.client.interfaces.GuiWrapperEditMenu;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.quests.Quest;
import hardcorequesting.tileentity.IBlockSync;
import hardcorequesting.tileentity.PortalType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.StringUtils;

public class TileEntityPortal
extends TileEntity
implements IBlockSync {
    private Quest quest;
    private int questId = -1;
    private List<String> players = new ArrayList<String>();
    private PortalType type = PortalType.TECH;
    private ItemStack item;
    private boolean completedTexture;
    private boolean uncompletedTexture = true;
    private boolean completedCollision;
    private boolean uncompletedCollision = true;
    public static final String NBT_QUEST = "Quest";
    public static final String NBT_TYPE = "PortalType";
    public static final String NBT_ID = "ItemId";
    public static final String NBT_DMG = "ItemDmg";
    public static final String NBT_COLLISION = "Collision";
    public static final String NBT_TEXTURES = "Textures";
    public static final String NBT_NOT_COLLISION = "NotCollision";
    public static final String NBT_NOT_TEXTURES = "NotTextures";
    private int delay = 20;
    private int resetDelay = 0;
    private boolean hasUpdatedData = false;

    public boolean isCompletedTexture() {
        return this.completedTexture;
    }

    public void setCompletedTexture(boolean completedTexture) {
        this.completedTexture = completedTexture;
    }

    public boolean isUncompletedTexture() {
        return this.uncompletedTexture;
    }

    public void setUncompletedTexture(boolean uncompletedTexture) {
        this.uncompletedTexture = uncompletedTexture;
    }

    public boolean isCompletedCollision() {
        return this.completedCollision;
    }

    public void setCompletedCollision(boolean completedCollision) {
        this.completedCollision = completedCollision;
    }

    public boolean isUncompletedCollision() {
        return this.uncompletedCollision;
    }

    public void setUncompletedCollision(boolean uncompletedCollision) {
        this.uncompletedCollision = uncompletedCollision;
    }

    public PortalType getType() {
        return this.type;
    }

    public void setType(PortalType type) {
        this.type = type;
    }

    public void writeContentToNBT(NBTTagCompound compound) {
        if (this.quest != null) {
            compound.func_74777_a(NBT_QUEST, this.quest.getId());
        }
        compound.func_74774_a(NBT_TYPE, (byte)this.type.ordinal());
        if (this.item != null) {
            compound.func_74777_a(NBT_ID, (short)this.item.field_77993_c);
            compound.func_74777_a(NBT_DMG, (short)this.item.func_77960_j());
        }
        compound.func_74757_a(NBT_COLLISION, this.completedCollision);
        compound.func_74757_a(NBT_TEXTURES, this.completedTexture);
        compound.func_74757_a(NBT_NOT_COLLISION, this.uncompletedCollision);
        compound.func_74757_a(NBT_NOT_TEXTURES, this.uncompletedTexture);
    }

    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        this.writeContentToNBT(compound);
    }

    public void func_70307_a(NBTTagCompound compound) {
        super.func_70307_a(compound);
        this.readContentFromNBT(compound);
    }

    public void readContentFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b(NBT_QUEST)) {
            this.questId = compound.func_74765_d(NBT_QUEST);
            if (Quest.getQuests() != null) {
                this.quest = Quest.getQuest(this.questId);
            }
        } else {
            this.quest = null;
        }
        this.type = PortalType.values()[compound.func_74771_c(NBT_TYPE)];
        if (compound.func_74764_b(NBT_ID)) {
            short id = compound.func_74765_d(NBT_ID);
            short dmg = compound.func_74765_d(NBT_DMG);
            this.item = new ItemStack((int)id, 1, (int)dmg);
        } else {
            this.item = null;
        }
        if (compound.func_74764_b(NBT_COLLISION)) {
            this.completedCollision = compound.func_74767_n(NBT_COLLISION);
            this.completedTexture = compound.func_74767_n(NBT_COLLISION);
            this.uncompletedCollision = compound.func_74767_n(NBT_NOT_COLLISION);
            this.uncompletedTexture = compound.func_74767_n(NBT_NOT_TEXTURES);
        } else {
            this.completedTexture = false;
            this.completedCollision = false;
            this.uncompletedTexture = true;
            this.uncompletedCollision = true;
        }
    }

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.quest == null && this.questId != -1) {
                this.quest = Quest.getQuest(this.questId);
                this.questId = -1;
            }
            boolean updated = false;
            if (this.delay++ >= 20) {
                if (this.quest != null && Quest.getQuest(this.quest.getId()) == null) {
                    this.quest = null;
                }
                if (this.quest != null) {
                    for (Team team : QuestingData.getAllTeams()) {
                        if (!team.getQuestData((int)this.quest.getId()).completed) continue;
                        for (Team.PlayerEntry entry : team.getPlayers()) {
                            if (!entry.isInTeam() || this.players.contains(entry.getName())) continue;
                            this.players.add(entry.getName());
                            updated = true;
                        }
                    }
                }
                this.delay = 0;
            }
            if (this.resetDelay++ >= 1200) {
                if (this.quest != null && Quest.getQuest(this.quest.getId()) == null) {
                    this.quest = null;
                }
                if (this.quest != null) {
                    Iterator<String> iterator = this.players.iterator();
                    while (iterator.hasNext()) {
                        String player = iterator.next();
                        if (QuestingData.hasData(player) && this.quest.isCompleted(player)) continue;
                        iterator.remove();
                        updated = true;
                    }
                } else if (this.players.size() > 0) {
                    this.players.clear();
                    updated = true;
                }
                this.resetDelay = 0;
            }
            if (updated) {
                PacketHandler.sendBlockPacket(this, null, 0);
            }
        } else {
            this.keepClientDataUpdated();
        }
    }

    public boolean hasTexture(EntityPlayer player) {
        return this.players.contains(StringUtils.func_76338_a((String)player.field_71092_bJ)) ? this.completedTexture : this.uncompletedTexture;
    }

    public boolean hasCollision(EntityPlayer player) {
        return this.players.contains(StringUtils.func_76338_a((String)player.field_71092_bJ)) ? this.completedCollision : this.uncompletedCollision;
    }

    public void setCurrentQuest() {
        this.quest = Quest.getQuest(Quest.selectedQuestId);
        this.delay = 1200;
        this.resetDelay = 1200;
        PacketHandler.sendBlockPacket(this, null, 0);
    }

    public Quest getCurrentQuest() {
        return this.quest;
    }

    @SideOnly(value=Side.CLIENT)
    private void keepClientDataUpdated() {
        double distance = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5);
        if (distance > Math.pow(128.0, 2.0)) {
            this.hasUpdatedData = false;
        } else if (!this.hasUpdatedData && distance < Math.pow(123.0, 2.0)) {
            this.hasUpdatedData = true;
            PacketHandler.sendBlockPacket(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0);
        }
    }

    @Override
    public void writeData(DataWriter dw, EntityPlayer player, boolean onServer, int id) {
        switch (id) {
            case 0: {
                if (!onServer) break;
                dw.writeBoolean(this.quest != null);
                if (this.quest != null) {
                    dw.writeData((int)this.quest.getId(), DataBitHelper.QUESTS);
                }
                dw.writeData(this.type.ordinal(), DataBitHelper.PORTAL_TYPE);
                if (!this.type.isPreset()) {
                    dw.writeBoolean(this.item != null);
                    if (this.item != null) {
                        dw.writeData(this.item.field_77993_c, DataBitHelper.SHORT);
                        dw.writeData(this.item.func_77960_j(), DataBitHelper.SHORT);
                    }
                }
                dw.writeBoolean(this.completedCollision);
                dw.writeBoolean(this.completedTexture);
                dw.writeBoolean(this.uncompletedCollision);
                dw.writeBoolean(this.uncompletedTexture);
                dw.writeData(this.players.size(), DataBitHelper.PLAYERS);
                for (String p : this.players) {
                    dw.writeString(p, DataBitHelper.NAME_LENGTH);
                }
                break;
            }
            case 1: {
                if (onServer) break;
                dw.writeData(this.type.ordinal(), DataBitHelper.PORTAL_TYPE);
                if (!this.type.isPreset()) {
                    dw.writeBoolean(this.item != null);
                    if (this.item != null) {
                        dw.writeData(this.item.field_77993_c, DataBitHelper.SHORT);
                        dw.writeData(this.item.func_77960_j(), DataBitHelper.SHORT);
                    }
                }
                dw.writeBoolean(this.completedCollision);
                dw.writeBoolean(this.completedTexture);
                dw.writeBoolean(this.uncompletedCollision);
                dw.writeBoolean(this.uncompletedTexture);
            }
        }
    }

    @Override
    public void readData(DataReader dr, EntityPlayer player, boolean onServer, int id) {
        switch (id) {
            case 0: {
                if (onServer) {
                    PacketHandler.sendBlockPacket(this, player, 0);
                    break;
                }
                this.quest = dr.readBoolean() ? Quest.getQuest(dr.readData(DataBitHelper.QUESTS)) : null;
                this.type = PortalType.values()[dr.readData(DataBitHelper.PORTAL_TYPE)];
                if (!this.type.isPreset()) {
                    if (dr.readBoolean()) {
                        int itemId = dr.readData(DataBitHelper.SHORT);
                        int dmg = dr.readData(DataBitHelper.SHORT);
                        this.item = new ItemStack(itemId, 1, dmg);
                    } else {
                        this.item = null;
                    }
                }
                this.completedCollision = dr.readBoolean();
                this.completedTexture = dr.readBoolean();
                this.uncompletedCollision = dr.readBoolean();
                this.uncompletedTexture = dr.readBoolean();
                this.players.clear();
                int count = dr.readData(DataBitHelper.PLAYERS);
                for (int i = 0; i < count; ++i) {
                    this.players.add(dr.readString(DataBitHelper.NAME_LENGTH));
                }
                this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                break;
            }
            case 1: {
                if (onServer) {
                    if (!Quest.isEditing) break;
                    this.type = PortalType.values()[dr.readData(DataBitHelper.PORTAL_TYPE)];
                    if (!this.type.isPreset()) {
                        if (dr.readBoolean()) {
                            int itemId = dr.readData(DataBitHelper.SHORT);
                            int dmg = dr.readData(DataBitHelper.SHORT);
                            this.item = new ItemStack(itemId, 1, dmg);
                        } else {
                            this.item = null;
                        }
                    }
                    this.completedCollision = dr.readBoolean();
                    this.completedTexture = dr.readBoolean();
                    this.uncompletedCollision = dr.readBoolean();
                    this.uncompletedTexture = dr.readBoolean();
                    PacketHandler.sendBlockPacket(this, null, 0);
                    break;
                }
                this.openInterfaceClient(player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void openInterfaceClient(EntityPlayer player) {
        GuiWrapperEditMenu gui = new GuiWrapperEditMenu();
        ((GuiBase)gui).setEditMenu(new GuiEditMenuPortal((GuiBase)gui, player, this));
        Minecraft.func_71410_x().func_71373_a((GuiScreen)gui);
    }

    public void openInterface(EntityPlayer player) {
        PacketHandler.sendBlockPacket(this, player, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendToServer() {
        PacketHandler.sendBlockPacket(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 1);
    }

    @Override
    public int infoBitLength() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getBlockIcon(int side) {
        Block block;
        if (this.item != null && this.item.func_77973_b() instanceof ItemBlock && (block = Block.field_71973_m[((ItemBlock)this.item.func_77973_b()).func_77883_f()]) != null) {
            try {
                return block.func_71858_a(side, this.item.func_77973_b().func_77647_b(this.item.func_77960_j()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public TileEntityPortal copy() {
        TileEntityPortal portal = new TileEntityPortal();
        NBTTagCompound compound = new NBTTagCompound();
        this.func_70310_b(compound);
        portal.func_70307_a(compound);
        portal.field_70331_k = this.field_70331_k;
        return portal;
    }
}

