/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.FileVersion;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiEditMenuItem;
import hardcorequesting.client.interfaces.GuiEditMenuMob;
import hardcorequesting.client.interfaces.GuiEditMenuTextEditor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestDataTask;
import hardcorequesting.quests.QuestDataTaskMob;
import hardcorequesting.quests.QuestTask;
import java.util.Arrays;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StringUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class QuestTaskMob
extends QuestTask {
    private boolean disabled;
    public Mob[] mobs = new Mob[0];
    private static final int Y_OFFSET = 30;
    private static final int X_TEXT_OFFSET = 23;
    private static final int X_TEXT_INDENT = 0;
    private static final int Y_TEXT_OFFSET = 0;
    private static final int ITEM_SIZE = 18;

    public QuestTaskMob(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @ForgeSubscribe
    public void onDeath(LivingDeathEvent event) {
        if (!this.disabled && event.entityLiving != null && !event.entityLiving.field_70170_p.field_72995_K && event.source != null) {
            EntityPlayer player = null;
            if (event.source.func_76364_f() != null && event.source.func_76364_f() instanceof EntityPlayer) {
                player = (EntityPlayer)event.source.func_76364_f();
            } else if (event.entityLiving.func_94060_bK() instanceof EntityPlayer) {
                player = (EntityPlayer)event.entityLiving.func_94060_bK();
            }
            if (player != null && this.parent.isEnabled(player) && this.parent.isAvailable(player) && this.isVisible(player) && !this.isCompleted(player)) {
                boolean updated = false;
                for (int i = 0; i < this.mobs.length; ++i) {
                    Class clazz;
                    Mob mob = this.mobs[i];
                    if (mob.count <= ((QuestDataTaskMob)this.getData((EntityPlayer)player)).killed[i] || (clazz = (Class)EntityList.field_75625_b.get(mob.mob)) == null) continue;
                    if (mob.isExact()) {
                        if (!clazz.equals(event.entityLiving.getClass())) continue;
                        int n = i;
                        ((QuestDataTaskMob)this.getData((EntityPlayer)player)).killed[n] = ((QuestDataTaskMob)this.getData((EntityPlayer)player)).killed[n] + 1;
                        updated = true;
                        continue;
                    }
                    if (!clazz.isAssignableFrom(event.entityLiving.getClass())) continue;
                    int n = i;
                    ((QuestDataTaskMob)this.getData((EntityPlayer)player)).killed[n] = ((QuestDataTaskMob)this.getData((EntityPlayer)player)).killed[n] + 1;
                    updated = true;
                }
                if (updated) {
                    boolean done = true;
                    for (int i = 0; i < this.mobs.length; ++i) {
                        Mob mob = this.mobs[i];
                        if (this.killed(i, player) >= mob.count) continue;
                        done = false;
                        break;
                    }
                    if (done) {
                        this.completeTask(StringUtils.func_76338_a((String)player.field_71092_bJ));
                    }
                    this.parent.sendUpdatedDataToTeam(player);
                }
            }
        }
    }

    @Override
    public void onDelete() {
        super.onDelete();
        this.disabled = true;
    }

    public void setMob(int id, Mob mob, EntityPlayer player) {
        if (id >= this.mobs.length) {
            this.mobs = Arrays.copyOf(this.mobs, this.mobs.length + 1);
            QuestDataTaskMob data = (QuestDataTaskMob)this.getData(player);
            data.killed = Arrays.copyOf(data.killed, data.killed.length + 1);
        }
        this.mobs[id] = mob;
    }

    public void setIcon(int id, ItemStack item, EntityPlayer player) {
        if (id >= this.mobs.length) {
            this.setMob(id, new Mob(), player);
        }
        this.mobs[id].icon = item;
    }

    public void setName(int id, String str, EntityPlayer player) {
        if (id >= this.mobs.length) {
            this.setMob(id, new Mob(), player);
        }
        this.mobs[id].name = str;
    }

    private Mob[] getEditFriendlyMobs(Mob[] mobs) {
        if (Quest.isEditing && mobs.length < DataBitHelper.TASK_MOB_COUNT.getMaximum()) {
            mobs = Arrays.copyOf(mobs, mobs.length + 1);
            mobs[mobs.length - 1] = new Mob();
            return mobs;
        }
        return mobs;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        Mob[] mobs = this.getEditFriendlyMobs(this.mobs);
        for (int i = 0; i < mobs.length; ++i) {
            Mob mob = mobs[i];
            int x = 180;
            int y = 95 + i * 30;
            gui.drawItem(mob.icon, x, y, mX, mY, false);
            gui.drawString(mob.name, x + 23, y + 0, 0x404040);
            int killed = this.killed(i, player);
            if (killed == mob.count) {
                gui.drawString((Object)((Object)GuiColor.GREEN) + "All killed", x + 23 + 0, y + 0 + 9, 0.7f, 0x404040);
            } else {
                gui.drawString(killed + "[" + 100 * killed / mob.count + "%] killed", x + 23 + 0, y + 0 + 9, 0.7f, 0x404040);
            }
            gui.drawString("Kill a total of " + mob.count, x + 23 + 0, y + 0 + 15, 0.7f, 0x404040);
        }
    }

    private int killed(int id, EntityPlayer player) {
        return id < this.mobs.length ? ((QuestDataTaskMob)this.getData((EntityPlayer)player)).killed[id] : 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        if (Quest.isEditing && gui.getCurrentMode() != GuiQuestBook.EditMode.NORMAL) {
            Mob[] mobs = this.getEditFriendlyMobs(this.mobs);
            block6: for (int i = 0; i < mobs.length; ++i) {
                Mob mob = mobs[i];
                int x = 180;
                int y = 95 + i * 30;
                if (!gui.inBounds(x, y, 18, 18, mX, mY)) continue;
                switch (gui.getCurrentMode()) {
                    case MOB: {
                        gui.setEditMenu(new GuiEditMenuMob(gui, this, mob.copy(), i, player));
                        break;
                    }
                    case ITEM: {
                        gui.setEditMenu(new GuiEditMenuItem((GuiBase)gui, player, mob.icon, i, GuiEditMenuItem.Type.MOB, 1, ItemPrecision.PRECISE));
                        break;
                    }
                    case RENAME: {
                        gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, this, i, mob));
                        break;
                    }
                    case DELETE: {
                        if (i >= this.mobs.length) break block6;
                        Mob[] newMobs = new Mob[this.mobs.length - 1];
                        int id = 0;
                        for (int j = 0; j < this.mobs.length; ++j) {
                            if (j == i) continue;
                            newMobs[id] = this.mobs[j];
                            ++id;
                        }
                        this.mobs = newMobs;
                        break;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void onUpdate(EntityPlayer player, DataReader dr) {
    }

    @Override
    public Class<? extends QuestDataTask> getDataType() {
        return QuestDataTaskMob.class;
    }

    @Override
    public void save(DataWriter dw) {
        dw.writeData(this.mobs.length, DataBitHelper.TASK_MOB_COUNT);
        for (Mob mob : this.mobs) {
            mob.save(dw);
        }
    }

    @Override
    public void load(DataReader dr, FileVersion version) {
        int count = dr.readData(DataBitHelper.TASK_MOB_COUNT);
        this.mobs = new Mob[count];
        for (int i = 0; i < this.mobs.length; ++i) {
            this.mobs[i] = new Mob();
            this.mobs[i].load(dr, version);
        }
    }

    @Override
    public void write(DataWriter dw, QuestDataTask task, boolean light) {
        super.write(dw, task, light);
        if (!light) {
            dw.writeData(((QuestDataTaskMob)task).killed.length, DataBitHelper.TASK_MOB_COUNT);
        }
        for (int val : ((QuestDataTaskMob)task).killed) {
            dw.writeData(val, DataBitHelper.KILL_COUNT);
        }
    }

    @Override
    public void read(DataReader dr, QuestDataTask task, FileVersion version, boolean light) {
        super.read(dr, task, version, light);
        QuestDataTaskMob mobData = (QuestDataTaskMob)task;
        if (light) {
            int[] killed = mobData.killed;
            for (int i = 0; i < killed.length; ++i) {
                killed[i] = dr.readData(DataBitHelper.KILL_COUNT);
            }
        } else {
            int count = dr.readData(DataBitHelper.TASK_MOB_COUNT);
            int[] killed = mobData.killed;
            for (int i = 0; i < count; ++i) {
                int val = dr.readData(DataBitHelper.KILL_COUNT);
                if (i >= killed.length) continue;
                killed[i] = Math.min(this.mobs[i].count, Math.max(0, val));
            }
        }
    }

    @Override
    public float getCompletedRatio(String playerName) {
        int killed = 0;
        int total = 0;
        for (int i = 0; i < this.mobs.length; ++i) {
            killed += ((QuestDataTaskMob)this.getData((String)playerName)).killed[i];
            total += this.mobs[i].count;
        }
        return (float)killed / (float)total;
    }

    @Override
    public void mergeProgress(String playerName, QuestDataTask own, QuestDataTask other) {
        int[] killed = ((QuestDataTaskMob)own).killed;
        int[] otherKilled = ((QuestDataTaskMob)other).killed;
        boolean all = true;
        for (int i = 0; i < killed.length; ++i) {
            killed[i] = Math.max(killed[i], otherKilled[i]);
            if (killed[i] >= this.mobs[i].count) continue;
            all = false;
        }
        if (all) {
            this.completeTask(playerName);
        }
    }

    @Override
    public void copyProgress(QuestDataTask own, QuestDataTask other) {
        super.copyProgress(own, other);
        int[] killed = ((QuestDataTaskMob)own).killed;
        System.arraycopy(((QuestDataTaskMob)other).killed, 0, killed, 0, killed.length);
    }

    @Override
    public void autoComplete(String playerName) {
        int[] killed = ((QuestDataTaskMob)this.getData((String)playerName)).killed;
        for (int i = 0; i < killed.length; ++i) {
            killed[i] = this.mobs[i].count;
        }
    }

    public class Mob {
        private ItemStack icon;
        private String name = "New";
        private String mob;
        private int count = 1;
        private boolean exact;

        public Mob copy() {
            Mob other = new Mob();
            other.icon = this.icon == null ? null : this.icon.func_77946_l();
            other.name = this.name;
            other.mob = this.mob;
            other.count = this.count;
            other.exact = this.exact;
            return other;
        }

        public void save(DataWriter dw) {
            dw.writeBoolean(this.icon != null);
            if (this.icon != null) {
                dw.writeData(this.icon.field_77993_c, DataBitHelper.SHORT);
                dw.writeData(this.icon.func_77960_j(), DataBitHelper.SHORT);
                dw.writeNBT(this.icon.func_77978_p());
            }
            dw.writeString(this.name, DataBitHelper.NAME_LENGTH);
            dw.writeString(this.mob, DataBitHelper.MOB_ID_LENGTH);
            dw.writeData(this.count, DataBitHelper.KILL_COUNT);
            dw.writeBoolean(this.exact);
        }

        public void load(DataReader dr, FileVersion version) {
            if (dr.readBoolean()) {
                int id = dr.readData(DataBitHelper.SHORT);
                int dmg = dr.readData(DataBitHelper.SHORT);
                NBTTagCompound compound = dr.readNBT();
                ItemStack itemStack = new ItemStack(id, 1, dmg);
                itemStack.func_77982_d(compound);
                this.icon = itemStack;
            } else {
                this.icon = null;
            }
            this.name = dr.readString(DataBitHelper.NAME_LENGTH);
            this.mob = dr.readString(DataBitHelper.MOB_ID_LENGTH);
            this.count = dr.readData(DataBitHelper.KILL_COUNT);
            this.exact = dr.readBoolean();
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public void setIcon(ItemStack icon) {
            this.icon = icon;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMob() {
            return this.mob;
        }

        public void setMob(String mob) {
            this.mob = mob;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public boolean isExact() {
            return this.exact;
        }

        public void setExact(boolean exact) {
            this.exact = exact;
        }
    }
}

