/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.quests.Quest;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class QuestSet {
    private String name;
    private String description;
    private List<String> cachedDescription;
    private List<Quest> quests;
    private int id;

    public QuestSet(String name, String description) {
        this.name = name;
        this.description = description;
        this.quests = new ArrayList<Quest>();
        this.id = Quest.getQuestSets().size();
    }

    public List<Quest> getQuests() {
        return this.quests;
    }

    public String getName() {
        return this.name;
    }

    public String getName(int i) {
        return i + 1 + ". " + this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getDescription(GuiBase gui) {
        if (this.cachedDescription == null) {
            this.cachedDescription = gui.getLinesFromText(this.description, 0.7f, 130);
        }
        return this.cachedDescription;
    }

    public boolean isEnabled(EntityPlayer player) {
        if (this.quests.isEmpty()) {
            return false;
        }
        for (Quest quest : this.quests) {
            if (!quest.isEnabled(player)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompleted(EntityPlayer player) {
        if (this.quests.isEmpty()) {
            return false;
        }
        for (Quest quest : this.quests) {
            if (quest.isCompleted(player)) continue;
            return false;
        }
        return true;
    }

    public void removeQuest(Quest quest) {
        this.quests.remove(quest);
    }

    public void addQuest(Quest quest) {
        this.quests.add(quest);
    }

    public int getCompletedCount(EntityPlayer player) {
        int count = 0;
        for (Quest quest : this.quests) {
            if (!quest.isCompleted(player) || !quest.isEnabled(player)) continue;
            ++count;
        }
        return count;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.cachedDescription = null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void decreaseId() {
        --this.id;
    }
}

