/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import hardcorequesting.QuestingData;
import hardcorequesting.Team;
import hardcorequesting.quests.QuestDataTask;
import net.minecraft.entity.player.EntityPlayer;

public class QuestData {
    public boolean[] reward;
    public boolean completed;
    public QuestDataTask[] tasks;
    public boolean available = true;
    public int time;

    public QuestData(int players) {
        this.reward = new boolean[players];
    }

    public boolean getReward(EntityPlayer player) {
        int id = this.getId(player);
        if (id >= 0 && id < this.reward.length) {
            return this.reward[id];
        }
        return true;
    }

    public void claimReward(EntityPlayer player) {
        int id = this.getId(player);
        if (id >= 0 && id < this.reward.length) {
            this.reward[id] = false;
        }
    }

    private int getId(EntityPlayer player) {
        Team team = QuestingData.getQuestingData(player).getTeam();
        int id = 0;
        for (Team.PlayerEntry entry : team.getPlayers()) {
            if (!entry.isInTeam()) continue;
            if (entry.getName().equals(QuestingData.getUserName(player))) {
                return id;
            }
            ++id;
        }
        return -1;
    }
}

