/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.config;

import hardcorequesting.QuestingData;
import hardcorequesting.Team;
import hardcorequesting.blocks.BlockInfo;
import hardcorequesting.items.ItemBag;
import hardcorequesting.items.ItemInfo;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestLine;
import java.io.File;
import net.minecraftforge.common.Configuration;

public class ModConfig {
    private static final String CATEGORY_GENERAL = "General";
    private static final String LIVES_KEY = "Default lives";
    private static final int LIVES_DEFAULT = 3;
    private static final String LIVES_COMMENT = "How many lives players should start with.";
    private static final String AUTO_KEY = "Auto-start hardcore mode";
    private static final boolean AUTO_DEFAULT = false;
    private static final String AUTO_COMMENT = "If set to true, new worlds will automatically activate Hardcore mode";
    private static final String AUTO_QUEST_KEY = "Auto-start questing mode";
    private static final boolean AUTO_QUEST_DEFAULT = true;
    private static final String AUTO_QUEST_COMMENT = "If set to true, new worlds will automatically activate Questing mode";
    public static final String MAXLIVES_KEY = "MaxLives";
    public static final int MAXLIVES_DEFAULT = 20;
    private static final String MAXLIVES_COMMENT = "Use this to set the maximum lives obtainable (Max 255)";
    public static int MAXLIVES;
    private static final String SPAWNBOOK_KEY = "SpawnBook";
    private static final boolean SPAWNBOOK_DEFAULT = true;
    private static final String SPAWNBOOK_COMMENT = "Use this if you want the book to spawn on create world";
    public static boolean spawnBook;
    private static final String EDITOR_KEY = "UseEditor";
    private static final boolean EDITOR_DEFAULT = false;
    private static final String EDITOR_COMMENT = "Only use this as a map maker who wants to create quests. Leaving this off allows you the play the existing quests.";
    private static final String MULTI_REWARD_KEY = "MultiReward";
    private static final boolean MULTI_REWARD_DEFAULT = true;
    private static final String MULTI_REWARD_COMMENT = "Allow every single player in a party to claim the reward for a quest. Setting this to false will give the party one set of rewards to share.";
    private static final String SYNC_KEY = "ServerSync";
    private static final boolean SYNC_DEFAULT = false;
    private static final String SYNC_COMMENT = "If this is set to true, the server will send the quests to clients connecting to it.";
    private static final String REWARD_KEY = "RewardInterface";
    private static final boolean REWARD_DEFAULT = true;
    private static final String REWARD_COMMENT = "Display an interface with the contents of the reward bag when you open it.";
    private static final String FRESHNESS_KEY = "RotTimer";
    private static final boolean FRESHNESS_DEFAULT = false;
    private static final String FRESHNESS_COMMENT = "Turn on/off the rot timer.";
    public static boolean ROTTIMER;
    private static final String ROT_KEY = "RotTime";
    private static final int ROT_DEFAULT = 120;
    private static final String ROT_COMMENT = "Define in seconds how long the rot timer is.";
    public static int MAXROT;
    public static int OVERLAY_XPOS;
    public static int OVERLAY_YPOS;
    public static int OVERLAY_XPOSDEFAULT;
    public static int OVERLAY_YPOSDEFAULT;

    public static void init(File file) {
        Configuration config = new Configuration(file);
        config.load();
        int lives = config.get(CATEGORY_GENERAL, LIVES_KEY, 3, LIVES_COMMENT).getInt(3);
        MAXLIVES = config.get(CATEGORY_GENERAL, MAXLIVES_KEY, 20, MAXLIVES_COMMENT).getInt(20);
        if (MAXLIVES < 1) {
            MAXLIVES = 1;
        } else if (MAXLIVES > 255) {
            MAXLIVES = 255;
        }
        if (lives < 1) {
            lives = 1;
        } else if (lives > MAXLIVES) {
            lives = MAXLIVES;
        }
        if (MAXROT < 1) {
            MAXROT = 1;
        }
        QuestingData.defaultLives = lives;
        QuestingData.autoHardcoreActivate = config.get(CATEGORY_GENERAL, AUTO_KEY, false, AUTO_COMMENT).getBoolean(false);
        QuestingData.autoQuestActivate = config.get(CATEGORY_GENERAL, AUTO_QUEST_KEY, true, AUTO_QUEST_COMMENT).getBoolean(true);
        Team.RewardSetting.isAllModeEnabled = config.get(CATEGORY_GENERAL, MULTI_REWARD_KEY, true, MULTI_REWARD_COMMENT).getBoolean(true);
        ItemBag.displayGui = config.get(CATEGORY_GENERAL, REWARD_KEY, true, REWARD_COMMENT).getBoolean(true);
        spawnBook = config.get(CATEGORY_GENERAL, SPAWNBOOK_KEY, true, SPAWNBOOK_COMMENT).getBoolean(true);
        Quest.isEditing = config.get(CATEGORY_GENERAL, EDITOR_KEY, false, EDITOR_COMMENT).getBoolean(false);
        QuestLine.doServerSync = config.get(CATEGORY_GENERAL, SYNC_KEY, false, SYNC_COMMENT).getBoolean(false);
        ROTTIMER = config.get(CATEGORY_GENERAL, FRESHNESS_KEY, false, FRESHNESS_COMMENT).getBoolean(false);
        MAXROT = config.get(CATEGORY_GENERAL, ROT_KEY, 120, ROT_COMMENT).getInt(120);
        ItemInfo.BOOK_ID = config.getItem("QuestBook", 27332).getInt() - 256;
        ItemInfo.HEART_ID = config.getItem("Hearts", 27333).getInt() - 256;
        ItemInfo.BAG_ID = config.getItem("Bags", 27334).getInt() - 256;
        BlockInfo.ITEMBARREL_ID = config.getBlock("ItemBarrel", 1000).getInt() - 256;
        BlockInfo.QUEST_TRACKER_ID = config.getBlock("QuestTracker", 1001).getInt() - 256;
        BlockInfo.QUEST_PORTAL_ID = config.getBlock("QuestPortal", 1002).getInt() - 256;
        config.save();
    }

    static {
        OVERLAY_XPOSDEFAULT = 2;
        OVERLAY_YPOSDEFAULT = 2;
    }
}

