/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenuExtended;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.TriggerType;
import net.minecraft.entity.player.EntityPlayer;

public class GuiEditMenuTrigger
extends GuiEditMenuExtended {
    private TriggerType type;
    private int triggerTasks;
    private int id;

    protected GuiEditMenuTrigger(GuiQuestBook gui, EntityPlayer player, Quest quest) {
        super(gui, player, true, 25, 20, 25, 135);
        this.id = quest.getId();
        this.type = quest.getTriggerType();
        this.triggerTasks = quest.getTriggerTasks();
        this.textBoxes.add(new GuiEditMenuExtended.TextBoxNumber((GuiBase)gui, 0, "Trigger tasks count"){

            @Override
            protected void setValue(int number) {
                GuiEditMenuTrigger.this.triggerTasks = number;
            }

            @Override
            protected int getValue() {
                return GuiEditMenuTrigger.this.triggerTasks;
            }

            @Override
            protected boolean isVisible() {
                return GuiEditMenuTrigger.this.type.isUseTaskCount();
            }
        });
    }

    @Override
    protected void onArrowClick(boolean left) {
        this.type = left ? TriggerType.values()[(this.type.ordinal() + TriggerType.values().length - 1) % TriggerType.values().length] : TriggerType.values()[(this.type.ordinal() + 1) % TriggerType.values().length];
    }

    @Override
    protected String getArrowText() {
        return this.type.getName();
    }

    @Override
    protected String getArrowDescription() {
        return this.type.getDescription();
    }

    @Override
    protected void save(GuiBase gui) {
        Quest quest = Quest.getQuest(this.id);
        if (quest != null) {
            quest.setTriggerType(this.type);
            quest.setTriggerTasks(Math.min(DataBitHelper.TASKS.getMaximum(), Math.max(1, this.triggerTasks)));
        }
    }
}

