/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenuExtended;
import hardcorequesting.tileentity.TileEntityTracker;
import hardcorequesting.tileentity.TrackerType;
import net.minecraft.entity.player.EntityPlayer;

public class GuiEditMenuTracker
extends GuiEditMenuExtended {
    private TileEntityTracker tracker;

    public GuiEditMenuTracker(GuiBase gui, EntityPlayer player, final TileEntityTracker tracker) {
        super(gui, player, true, 20, 30, 20, 130);
        this.tracker = tracker;
        this.textBoxes.add(new GuiEditMenuExtended.TextBoxNumber(gui, 0, "Player Radius"){

            @Override
            protected void setValue(int number) {
                tracker.setRadius(number);
            }

            @Override
            protected int getValue() {
                return tracker.getRadius();
            }

            @Override
            protected void draw(GuiBase gui, boolean selected) {
                super.draw(gui, selected);
                gui.drawString(gui.getLinesFromText("Only includes players within the given distance. Leaving this at zero makes it detect any player, even offline ones.", 0.7f, 130), GuiEditMenuTracker.this.BOX_X, GuiEditMenuTracker.this.BOX_Y + 30 + -10, 0.7f, 0x404040);
            }
        });
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        gui.drawCenteredString(this.tracker.getCurrentQuest() != null ? this.tracker.getCurrentQuest().getName() : "No quest selected", 0, 5, 1.0f, 170, 20, 0x404040);
    }

    @Override
    protected void onArrowClick(boolean left) {
        if (left) {
            this.tracker.setType(TrackerType.values()[(this.tracker.getType().ordinal() + TrackerType.values().length - 1) % TrackerType.values().length]);
        } else {
            this.tracker.setType(TrackerType.values()[(this.tracker.getType().ordinal() + 1) % TrackerType.values().length]);
        }
    }

    @Override
    protected String getArrowText() {
        return this.tracker.getType().getName();
    }

    @Override
    protected String getArrowDescription() {
        return this.tracker.getType().getDescription();
    }

    @Override
    protected void save(GuiBase gui) {
        this.tracker.sendToServer();
    }

    @Override
    public boolean doesRequiredDoublePage() {
        return false;
    }
}

