/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenuExtended;
import hardcorequesting.client.interfaces.GuiEditMenuItemPortal;
import hardcorequesting.client.interfaces.LargeButton;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.tileentity.PortalType;
import hardcorequesting.tileentity.TileEntityPortal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GuiEditMenuPortal
extends GuiEditMenuExtended {
    private TileEntityPortal portal;
    private GuiEditMenuPortal self = this;
    private List<CheckBox> checkboxes;
    private static final int CHECK_BOX_X = 20;
    private static final int CHECK_BOX_Y = 110;
    private static final int CHECK_BOX_OFFSET = 12;
    private static final int CHECK_BOX_SRC_X = 192;
    private static final int CHECK_BOX_SRC_Y = 102;
    private static final int CHECK_BOX_SIZE = 7;

    public GuiEditMenuPortal(GuiBase gui, EntityPlayer player, TileEntityPortal portal) {
        super(gui, player, true, 20, 30, 20, 130);
        this.portal = portal.copy();
        this.buttons.add(new LargeButton("Edit item", 40, 80){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return !GuiEditMenuPortal.this.self.portal.getType().isPreset();
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                gui.setEditMenu(new GuiEditMenuItemPortal(gui, GuiEditMenuPortal.this.self, player, GuiEditMenuPortal.this.self.portal.getItem()));
            }
        });
        this.checkboxes = new ArrayList<CheckBox>();
        this.checkboxes.add(new CheckBox("Use collision when completed", 20, 110){

            @Override
            public boolean getValue() {
                return GuiEditMenuPortal.this.self.portal.isCompletedCollision();
            }

            @Override
            public void setValue(boolean val) {
                GuiEditMenuPortal.this.self.portal.setCompletedCollision(val);
            }
        });
        this.checkboxes.add(new CheckBox("Use textures when completed", 20, 122){

            @Override
            public boolean getValue() {
                return GuiEditMenuPortal.this.self.portal.isCompletedTexture();
            }

            @Override
            public void setValue(boolean val) {
                GuiEditMenuPortal.this.self.portal.setCompletedTexture(val);
            }
        });
        this.checkboxes.add(new CheckBox("Use collision when not completed", 20, 134){

            @Override
            public boolean getValue() {
                return GuiEditMenuPortal.this.self.portal.isUncompletedCollision();
            }

            @Override
            public void setValue(boolean val) {
                GuiEditMenuPortal.this.self.portal.setUncompletedCollision(val);
            }
        });
        this.checkboxes.add(new CheckBox("Use textures when not completed", 20, 146){

            @Override
            public boolean getValue() {
                return GuiEditMenuPortal.this.self.portal.isUncompletedTexture();
            }

            @Override
            public void setValue(boolean val) {
                GuiEditMenuPortal.this.self.portal.setUncompletedTexture(val);
            }
        });
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        gui.drawCenteredString(this.portal.getCurrentQuest() != null ? this.portal.getCurrentQuest().getName() : "No quest selected", 0, 5, 1.0f, 170, 20, 0x404040);
        if (!this.portal.getType().isPreset()) {
            gui.drawItem(this.portal.getItem(), 20, 80, mX, mY, false);
        }
        for (CheckBox checkbox : this.checkboxes) {
            checkbox.draw(gui, mX, mY);
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        for (CheckBox checkbox : this.checkboxes) {
            checkbox.onClick(gui, mX, mY);
        }
    }

    @Override
    protected void onArrowClick(boolean left) {
        if (left) {
            this.portal.setType(PortalType.values()[(this.portal.getType().ordinal() + PortalType.values().length - 1) % PortalType.values().length]);
        } else {
            this.portal.setType(PortalType.values()[(this.portal.getType().ordinal() + 1) % PortalType.values().length]);
        }
    }

    @Override
    protected String getArrowText() {
        return this.portal.getType().getName();
    }

    @Override
    protected String getArrowDescription() {
        return this.portal.getType().getDescription();
    }

    @Override
    protected void save(GuiBase gui) {
        this.portal.sendToServer();
    }

    @Override
    public boolean doesRequiredDoublePage() {
        return false;
    }

    public void setItem(ItemStack item) {
        this.portal.setItem(item);
    }

    private abstract class CheckBox {
        private int x;
        private int y;
        private String name;
        private List<String> cached;
        private int width = Integer.MAX_VALUE;

        protected CheckBox(String name, int x, int y) {
            this.x = x;
            this.y = y;
            this.name = name;
        }

        protected CheckBox(String name, int x, int y, int width) {
            this(name, x, y);
            this.width = width;
        }

        protected void draw(GuiBase gui, int mX, int mY) {
            if (this.cached == null) {
                this.cached = gui.getLinesFromText(this.name, 0.7f, this.width);
            }
            boolean selected = this.getValue();
            boolean hover = gui.inBounds(this.x, this.y, 7, 7, mX, mY);
            gui.applyColor(-1);
            ResourceHelper.bindResource(GuiBase.MAP_TEXTURE);
            gui.drawRect(this.x, this.y, 192 + (selected ? 7 : 0), 102 + (hover ? 7 : 0), 7, 7);
            gui.drawString(this.cached, this.x + 12, this.y + 2, 0.7f, 0x404040);
        }

        protected void onClick(GuiBase gui, int mX, int mY) {
            if (gui.inBounds(this.x, this.y, 7, 7, mX, mY)) {
                this.setValue(!this.getValue());
            }
        }

        public abstract boolean getValue();

        public abstract void setValue(boolean var1);
    }
}

