/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenu;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.TextBoxGroup;
import hardcorequesting.items.Items;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiEditMenuItem
extends GuiEditMenu {
    private static final int ARROW_X_LEFT = 20;
    private static final int ARROW_X_RIGHT = 150;
    private static final int ARROW_Y = 40;
    private static final int ARROW_SRC_X = 244;
    private static final int ARROW_SRC_Y = 176;
    private static final int ARROW_W = 6;
    private static final int ARROW_H = 10;
    private int id;
    private Type type;
    protected Element selected;
    private List<Element> playerItems;
    private List<Element> searchItems;
    private ItemPrecision precision;
    private boolean clicked;
    private static final int PLAYER_X = 20;
    private static final int PLAYER_Y = 80;
    private static final int SEARCH_X = 180;
    private static final int SEARCH_Y = 30;
    private static final int SIZE = 18;
    private static final int OFFSET = 20;
    private static final int ITEMS_PER_LINE = 7;
    private static final int SEARCH_LINES = 9;
    private static final int PLAYER_LINES = 6;
    private TextBoxGroup.TextBox amountTextBox;
    private TextBoxGroup textBoxes;

    private boolean inArrowBounds(GuiBase gui, int mX, int mY, boolean left) {
        return gui.inBounds(left ? 20 : 150, 40, 6, 10, mX, mY);
    }

    private void drawArrow(GuiBase gui, int mX, int mY, boolean left) {
        int srcX = 244 + (left ? 0 : 6);
        int srcY = 176 + (this.inArrowBounds(gui, mX, mY, left) ? (this.clicked ? 1 : 2) : 0) * 10;
        gui.drawRect(left ? 20 : 150, 40, srcX, srcY, 6, 10);
    }

    private boolean usePrecision() {
        return this.type.allowPrecision && this.selected instanceof ElementItem;
    }

    private Element getSelected() {
        return this.selected;
    }

    public GuiEditMenuItem(GuiBase gui, EntityPlayer player, Object obj, int id, Type type, int amount, ItemPrecision precision) {
        this(gui, player, obj instanceof ItemStack ? new ElementItem((ItemStack)obj) : new ElementFluid((Fluid)obj), id, type, amount, precision);
    }

    public GuiEditMenuItem(GuiBase gui, EntityPlayer player, Element element, int id, final Type type, int amount, ItemPrecision precision) {
        super(gui, player, true);
        this.selected = element;
        this.id = id;
        this.type = type;
        this.precision = precision;
        this.playerItems = new ArrayList<Element>();
        this.searchItems = new ArrayList<Element>();
        InventoryPlayer inventory = Minecraft.func_71410_x().field_71439_g.field_71071_by;
        int itemLength = inventory.func_70302_i_();
        for (int i = 0; i < itemLength; ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null) continue;
            item = item.func_77946_l();
            item.field_77994_a = 1;
            boolean exists = false;
            for (Element other : this.playerItems) {
                if (!ItemStack.func_77989_b((ItemStack)item, (ItemStack)((ItemStack)other.getItem()))) continue;
                exists = true;
                break;
            }
            if (exists || item.func_77973_b().field_77779_bT == Items.book.field_77779_bT) continue;
            this.playerItems.add(new ElementItem(item));
        }
        if (type.allowFluids) {
            ArrayList<Integer> fluids = new ArrayList<Integer>();
            int end = this.playerItems.size();
            for (int i = 0; i < end; ++i) {
                Element item = this.playerItems.get(i);
                FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)((ItemStack)item.getItem()));
                if (fluidStack == null || fluids.contains(fluidStack.fluidID)) continue;
                fluids.add(fluidStack.fluidID);
                this.playerItems.add(new ElementFluid(fluidStack.getFluid()));
                if (this.playerItems.size() == 42) break;
            }
        }
        this.textBoxes = new TextBoxGroup();
        if (type.allowAmount) {
            this.amountTextBox = new TextBoxGroup.TextBox(gui, String.valueOf(amount), 100, 18, false){

                @Override
                protected boolean isCharacterValid(char c) {
                    return Character.isDigit(c);
                }

                @Override
                protected void textChanged(GuiBase gui) {
                    try {
                        int number = this.getText().equals("") ? 1 : Integer.parseInt(this.getText());
                        if (number == 0) {
                            number = 1;
                        }
                        if (GuiEditMenuItem.this.getSelected() != null) {
                            GuiEditMenuItem.this.getSelected().setAmount(number);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.textBoxes.add(this.amountTextBox);
        }
        this.textBoxes.add(new TextBoxGroup.TextBox(gui, "", 230, 18, false){

            @Override
            protected void textChanged(GuiBase gui) {
                GuiEditMenuItem.this.searchItems.clear();
                if (!this.getText().equals("")) {
                    String search = this.getText().toLowerCase();
                    Item[] items = Item.field_77698_e;
                    int itemLength = items.length;
                    ArrayList itemStacks = new ArrayList();
                    for (int i = 0; i < itemLength; ++i) {
                        Item item = items[i];
                        if (item == null || item.func_77640_w() == null) continue;
                        item.func_77633_a(item.field_77779_bT, null, itemStacks);
                    }
                    for (ItemStack itemStack : itemStacks) {
                        if (itemStack == null) continue;
                        GuiEditMenuItem.this.searchItems.add(new ElementItem(itemStack));
                    }
                    if (type.allowFluids) {
                        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                            GuiEditMenuItem.this.searchItems.add(new ElementFluid(fluid));
                        }
                    }
                    Iterator itemIterator = GuiEditMenuItem.this.searchItems.iterator();
                    int kept = 0;
                    while (itemIterator.hasNext()) {
                        List<String> description;
                        Element element = (Element)itemIterator.next();
                        if (kept >= 63) {
                            itemIterator.remove();
                            continue;
                        }
                        try {
                            description = element.getName(gui);
                        }
                        catch (Throwable ex) {
                            itemIterator.remove();
                            continue;
                        }
                        Iterator<String> descriptionIterator = description.iterator();
                        boolean foundSequence = false;
                        while (descriptionIterator.hasNext()) {
                            String line = descriptionIterator.next().toLowerCase();
                            if (!line.contains(search)) continue;
                            foundSequence = true;
                            break;
                        }
                        if (!foundSequence) {
                            itemIterator.remove();
                            continue;
                        }
                        ++kept;
                    }
                }
            }
        });
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        gui.drawString("Selected", 20, 20, 0x404040);
        this.selected.draw(gui, 70, 15, mX, mY);
        gui.drawString("Search", 180, 20, 0x404040);
        this.drawList(gui, 180, 30, this.searchItems, mX, mY);
        gui.drawString("Player inventory", 20, 70, 0x404040);
        this.drawList(gui, 20, 80, this.playerItems, mX, mY);
        this.textBoxes.draw(gui);
        if (this.usePrecision()) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            ResourceHelper.bindResource(GuiBase.MAP_TEXTURE);
            this.drawArrow(gui, mX, mY, true);
            this.drawArrow(gui, mX, mY, false);
            gui.drawCenteredString(this.precision.toString(), 26, 40, 0.7f, 124, 10, 0x404040);
        }
    }

    @Override
    public void drawMouseOver(GuiBase gui, int mX, int mY) {
        super.drawMouseOver(gui, mX, mY);
        this.drawListMouseOver(gui, 180, 30, this.searchItems, mX, mY);
        this.drawListMouseOver(gui, 20, 80, this.playerItems, mX, mY);
    }

    private void drawList(GuiBase gui, int x, int y, List<Element> items, int mX, int mY) {
        for (int i = 0; i < items.size(); ++i) {
            Element element = items.get(i);
            int xI = i % 7;
            int yI = i / 7;
            element.draw(gui, x + xI * 20, y + yI * 20, mX, mY);
        }
    }

    private void drawListMouseOver(GuiBase gui, int x, int y, List<Element> items, int mX, int mY) {
        for (int i = 0; i < items.size(); ++i) {
            Element element = items.get(i);
            int xI = i % 7;
            int yI = i / 7;
            if (!gui.inBounds(x + xI * 20, y + yI * 20, 18, 18, mX, mY)) continue;
            if (element == null) break;
            gui.drawMouseOver(element.getName(gui), mX + gui.getLeft(), mY + gui.getTop());
            break;
        }
    }

    private void clickList(GuiBase gui, int x, int y, List<Element> items, int mX, int mY) {
        for (int i = 0; i < items.size(); ++i) {
            Element element = items.get(i);
            int xI = i % 7;
            int yI = i / 7;
            if (!gui.inBounds(x + xI * 20, y + yI * 20, 18, 18, mX, mY)) continue;
            if (element == null) break;
            this.selected = element.copy();
            if (this.amountTextBox != null) {
                this.amountTextBox.textChanged(gui);
                break;
            }
            this.selected.setAmount(1);
            break;
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        this.clickList(gui, 20, 80, this.playerItems, mX, mY);
        this.clickList(gui, 180, 30, this.searchItems, mX, mY);
        this.textBoxes.onClick(gui, mX, mY);
        if (this.usePrecision()) {
            if (this.inArrowBounds(gui, mX, mY, true)) {
                this.precision = ItemPrecision.values()[(this.precision.ordinal() + ItemPrecision.values().length - 1) % ItemPrecision.values().length];
                this.clicked = true;
            } else if (this.inArrowBounds(gui, mX, mY, false)) {
                this.precision = ItemPrecision.values()[(this.precision.ordinal() + 1) % ItemPrecision.values().length];
                this.clicked = true;
            }
        }
    }

    @Override
    public void onRelease(GuiBase gui, int mX, int mY) {
        super.onRelease(gui, mX, mY);
        this.clicked = false;
    }

    @Override
    public void onKeyTyped(GuiBase gui, char c, int k) {
        super.onKeyTyped(gui, c, k);
        this.textBoxes.onKeyStroke(gui, c, k);
    }

    @Override
    protected void save(GuiBase gui) {
        if (this.type == Type.BAG_ITEM) {
            if (GuiQuestBook.getSelectedGroup() != null && this.selected instanceof ElementItem && (ItemStack)this.selected.getItem() != null) {
                GuiQuestBook.getSelectedGroup().setItem(this.id, (ItemStack)this.selected.getItem());
            }
        } else if (this.type == Type.QUEST_ICON) {
            if (Quest.getQuest(this.id) != null && this.selected instanceof ElementItem) {
                Quest.getQuest(this.id).setIcon((ItemStack)this.selected.getItem());
            }
        } else {
            ((GuiQuestBook)gui).getSelectedQuest().setItem(this.selected, this.id, this.type, this.precision, this.player);
        }
    }

    public static class ElementFluid
    extends Element<Fluid> {
        private int size;

        private ElementFluid(Fluid fluid) {
            this.item = fluid;
        }

        @Override
        public void draw(GuiBase gui, int x, int y, int mX, int mY) {
            gui.drawFluid((Fluid)this.item, x, y, mX, mY);
        }

        @Override
        public List<String> getName(GuiBase gui) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(((Fluid)this.item).getLocalizedName());
            return ret;
        }

        @Override
        public int getAmount() {
            return this.size;
        }

        @Override
        public void setAmount(int val) {
            this.size = val;
        }

        @Override
        public Element copy() {
            ElementFluid ret = new ElementFluid(this.item == null ? null : (Fluid)this.item);
            ret.size = this.size;
            return ret;
        }
    }

    public static class ElementItem
    extends Element<ItemStack> {
        private ElementItem(ItemStack item) {
            this.item = item;
        }

        @Override
        public void draw(GuiBase gui, int x, int y, int mX, int mY) {
            gui.drawItem((ItemStack)this.item, x, y, mX, mY, false);
        }

        @Override
        public List<String> getName(GuiBase gui) {
            if (this.item != null && ((ItemStack)this.item).func_77973_b() != null) {
                return ((ItemStack)this.item).func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("Unknown");
            return ret;
        }

        @Override
        public int getAmount() {
            return this.item == null ? 0 : ((ItemStack)this.item).field_77994_a;
        }

        @Override
        public void setAmount(int val) {
            if (this.item != null) {
                ((ItemStack)this.item).field_77994_a = val;
            }
        }

        @Override
        public Element copy() {
            return new ElementItem(this.item == null ? null : ((ItemStack)this.item).func_77946_l());
        }
    }

    public static abstract class Element<T> {
        protected T item;

        protected Element() {
        }

        public abstract void draw(GuiBase var1, int var2, int var3, int var4, int var5);

        public abstract List<String> getName(GuiBase var1);

        public abstract int getAmount();

        public abstract void setAmount(int var1);

        public T getItem() {
            return this.item;
        }

        public abstract Element copy();
    }

    public static enum Type {
        REWARD(false, true, false),
        PICK_REWARD(false, true, false),
        CONSUME_TASK(true, true, true),
        CRAFTING_TASK(false, true, true),
        QUEST_ICON(false, false, false),
        BAG_ITEM(false, true, false),
        LOCATION(false, false, false),
        MOB(false, false, false),
        PORTAL(false, false, false);

        private boolean allowFluids;
        private boolean allowAmount;
        private boolean allowPrecision;

        private Type(boolean allowFluids, boolean allowAmount, boolean allowPrecision) {
            this.allowFluids = allowFluids;
            this.allowAmount = allowAmount;
            this.allowPrecision = allowPrecision;
        }
    }
}

