/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.LargeButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

@SideOnly(value=Side.CLIENT)
public abstract class GuiEditMenu {
    protected List<LargeButton> buttons = new ArrayList<LargeButton>();
    private boolean hasButtons;
    protected EntityPlayer player;

    protected GuiEditMenu(GuiBase gui, EntityPlayer player) {
        this.player = player;
    }

    protected GuiEditMenu(GuiBase gui, EntityPlayer player, boolean isControlOnFirstPage) {
        this(gui, player);
        this.hasButtons = true;
        int xOffset = isControlOnFirstPage ? 0 : 145;
        this.buttons.add(new LargeButton("Ok", xOffset + 40, 200){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenu.this.save(gui);
                GuiEditMenu.this.close(gui);
            }
        });
        this.buttons.add(new LargeButton("Cancel", xOffset + 100, 200){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenu.this.close(gui);
            }
        });
    }

    public void draw(GuiBase gui, int mX, int mY) {
        for (LargeButton button : this.buttons) {
            if (!button.isVisible(gui, null)) continue;
            button.draw(gui, this.player, mX, mY);
        }
    }

    public void drawMouseOver(GuiBase gui, int mX, int mY) {
        for (LargeButton button : this.buttons) {
            if (!button.isVisible(gui, null)) continue;
            button.drawMouseOver(gui, this.player, mX, mY);
        }
    }

    public void onClick(GuiBase gui, int mX, int mY, int b) {
        if (!this.hasButtons && b == 1) {
            this.save(gui);
            this.close(gui);
        }
        for (LargeButton button : this.buttons) {
            if (!button.inButtonBounds(gui, mX, mY) || !button.isVisible(gui, null) || !button.isEnabled(gui, null)) continue;
            button.onClick(gui, this.player);
        }
    }

    protected void close(GuiBase gui) {
        gui.setEditMenu(null);
    }

    public void onKeyTyped(GuiBase gui, char c, int k) {
    }

    public void onDrag(GuiBase gui, int mX, int mY) {
    }

    public void onRelease(GuiBase gui, int mX, int mY) {
    }

    public void onScroll(GuiBase gui, int mX, int mY, int scroll) {
    }

    protected abstract void save(GuiBase var1);

    public boolean doesRequiredDoublePage() {
        return true;
    }
}

