/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.HardcoreQuesting;
import hardcorequesting.items.Items;
import hardcorequesting.quests.Quest;
import hardcorequesting.tileentity.PortalType;
import hardcorequesting.tileentity.TileEntityPortal;
import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPortal
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private Icon transparentIcon;
    @SideOnly(value=Side.CLIENT)
    private Icon emptyIcon;
    @SideOnly(value=Side.CLIENT)
    private Icon techIcon;
    @SideOnly(value=Side.CLIENT)
    private Icon techEmptyIcon;
    @SideOnly(value=Side.CLIENT)
    private Icon magicIcon;

    public BlockPortal(int id) {
        super(id, Material.field_76245_d);
        this.func_71864_b("hqmQuestPortal");
        this.func_71849_a(HardcoreQuesting.HQMTab);
        this.func_71848_c(10.0f);
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityPortal();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister icon) {
        this.field_94336_cN = icon.func_94245_a("hqm:hqmQuestPortal");
        this.emptyIcon = icon.func_94245_a("hqm:hqmItemBarrelEmpty");
        this.techIcon = icon.func_94245_a("hqm:hqmQuestPortalTech");
        this.techEmptyIcon = icon.func_94245_a("hqm:hqmQuestPortalTechTop");
        this.magicIcon = icon.func_94245_a("hqm:hqmQuestPortalMagic");
        this.transparentIcon = icon.func_94245_a("hqm:hqmQuestPortalTransparent");
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player != null && Quest.isEditing) {
            TileEntity te;
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().field_77993_c == Items.book.field_77779_bT) {
                TileEntity te2;
                if (!world.field_72995_K && (te2 = world.func_72796_p(x, y, z)) != null && te2 instanceof TileEntityPortal) {
                    ((TileEntityPortal)te2).setCurrentQuest();
                    if (((TileEntityPortal)te2).getCurrentQuest() != null) {
                        player.func_71035_c("You bound '" + ((TileEntityPortal)te2).getCurrentQuest().getName() + "' to the QGS");
                    } else {
                        player.func_71035_c("You currently have not selected any quest");
                    }
                }
                return true;
            }
            if (!world.field_72995_K && (te = world.func_72796_p(x, y, z)) != null && te instanceof TileEntityPortal) {
                ((TileEntityPortal)te).openInterface(player);
            }
            return true;
        }
        return false;
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB box, List lst, Entity entity) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (entity instanceof EntityPlayer && te instanceof TileEntityPortal && !((TileEntityPortal)te).hasCollision((EntityPlayer)entity)) {
            return;
        }
        super.func_71871_a(world, x, y, z, box, lst, entity);
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public final Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityPortal) {
            TileEntityPortal portal = (TileEntityPortal)te;
            if (!portal.hasTexture((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                return this.transparentIcon;
            }
            if (portal.getType().isPreset()) {
                return portal.getType() == PortalType.TECH ? (side == 0 || side == 1 ? this.techEmptyIcon : this.techIcon) : this.magicIcon;
            }
            Icon icon = portal.getBlockIcon(side);
            if (icon != null) {
                return icon;
            }
        }
        return this.func_71858_a(side, 0);
    }

    public Icon func_71858_a(int side, int meta) {
        return side == 0 || side == 1 ? this.emptyIcon : this.field_94336_cN;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te != null && te instanceof TileEntityPortal) {
            TileEntityPortal portal = (TileEntityPortal)te;
            ItemStack itemStack = super.getPickBlock(target, world, x, y, z);
            if (itemStack != null) {
                NBTTagCompound tagCompound = itemStack.func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    itemStack.func_77982_d(tagCompound);
                }
                NBTTagCompound info = new NBTTagCompound();
                tagCompound.func_74766_a("Portal", info);
                portal.writeContentToNBT(info);
            }
            return itemStack;
        }
        return null;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te != null && te instanceof TileEntityPortal) {
            TileEntityPortal manager = (TileEntityPortal)te;
            if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("Portal")) {
                manager.readContentFromNBT(itemStack.func_77978_p().func_74775_l("Portal"));
            }
        }
    }
}

