/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.bag;

import hardcorequesting.FileVersion;
import hardcorequesting.QuestingData;
import hardcorequesting.bag.GroupData;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestLine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class Group {
    private GroupTier tier;
    private List<ItemStack> items;
    private String name;
    private int limit;
    private int id;

    public static int size() {
        return QuestLine.getActiveQuestLine().groupCount;
    }

    private Group(int id, String name, GroupTier tier, List<ItemStack> items, int limit) {
        this.id = id;
        this.name = name;
        this.tier = tier;
        this.items = items;
        this.limit = limit;
        QuestLine.getActiveQuestLine().groupCount = Math.max(QuestLine.getActiveQuestLine().groupCount, id + 1);
    }

    public Group() {
        this.id = QuestLine.getActiveQuestLine().groupCount++;
        this.tier = GroupTier.getTiers().size() > 1 ? GroupTier.getTiers().get(1) : GroupTier.getTiers().get(0);
        this.items = new ArrayList<ItemStack>();
    }

    public GroupTier getTier() {
        return this.tier;
    }

    public static List<Group> getGroups() {
        return QuestLine.getActiveQuestLine().groupList;
    }

    public String getName() {
        return this.name == null || this.name.equals("") ? this.tier.getName() + " Group" : this.name;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setTier(GroupTier tier) {
        this.tier = tier;
    }

    public void setItem(int id, ItemStack item) {
        if (id >= this.items.size()) {
            this.items.add(item);
        } else {
            this.items.set(id, item);
        }
    }

    public void open(EntityPlayer player) {
        GroupData data;
        if (this.limit > 0 && (data = QuestingData.getQuestingData(player).getGroupData(this.id)) != null) {
            ++data.retrieved;
        }
        ArrayList<ItemStack> itemsToAdd = new ArrayList<ItemStack>();
        for (ItemStack item : this.items) {
            itemsToAdd.add(item.func_77946_l());
        }
        Quest.addItems(player, itemsToAdd);
        for (ItemStack item : itemsToAdd) {
            if (item.field_77994_a <= 0) continue;
            EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, item);
            player.field_70170_p.func_72838_d((Entity)entityItem);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void removeItem(int i) {
        if (i >= 0 && i < this.items.size()) {
            this.items.remove(i);
        }
    }

    public void remove(int i) {
        if (i >= 0 && i < QuestLine.getActiveQuestLine().groupList.size()) {
            Group group = QuestLine.getActiveQuestLine().groupList.remove(i);
            QuestLine.getActiveQuestLine().groups.remove(group.id);
        }
    }

    public static void saveAll(DataWriter dw) {
        dw.writeData(Group.getGroups().size(), DataBitHelper.GROUP_COUNT);
        for (Group group : Group.getGroups()) {
            dw.writeData(group.id, DataBitHelper.GROUP_COUNT);
            dw.writeString(group.name, DataBitHelper.QUEST_NAME_LENGTH);
            int id = GroupTier.getTiers().indexOf(group.tier);
            if (id == -1) {
                id = 0;
            }
            dw.writeData(id, DataBitHelper.TIER_COUNT);
            dw.writeData(group.items.size(), DataBitHelper.GROUP_ITEMS);
            for (ItemStack item : group.items) {
                NBTTagCompound compound = new NBTTagCompound();
                item.func_77955_b(compound);
                dw.writeNBT(compound);
            }
            if (group.limit > 0) {
                dw.writeBoolean(true);
                dw.writeData(group.limit, DataBitHelper.LIMIT);
                continue;
            }
            dw.writeBoolean(false);
        }
    }

    public static void readAll(DataReader dr, FileVersion version) {
        QuestLine.getActiveQuestLine().groups.clear();
        QuestLine.getActiveQuestLine().groupList.clear();
        QuestLine.getActiveQuestLine().groupCount = 0;
        int count = dr.readData(DataBitHelper.GROUP_COUNT);
        for (int i = 0; i < count; ++i) {
            int id = i;
            if (version.contains(FileVersion.BAG_LIMITS)) {
                id = dr.readData(DataBitHelper.GROUP_COUNT);
            }
            String name = dr.readString(DataBitHelper.QUEST_NAME_LENGTH);
            GroupTier tier = GroupTier.getTiers().get(dr.readData(DataBitHelper.TIER_COUNT));
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            int itemCount = dr.readData(DataBitHelper.GROUP_ITEMS);
            for (int j = 0; j < itemCount; ++j) {
                ItemStack itemStack;
                NBTTagCompound compound = dr.readNBT();
                if (compound == null || (itemStack = ItemStack.func_77949_a((NBTTagCompound)compound)) == null) continue;
                items.add(itemStack);
            }
            int limit = 0;
            if (version.contains(FileVersion.BAG_LIMITS) && dr.readBoolean()) {
                limit = dr.readData(DataBitHelper.LIMIT);
            }
            Group.add(new Group(id, name, tier, items, limit));
        }
    }

    public static void add(Group group) {
        QuestLine.getActiveQuestLine().groups.put(group.id, group);
        QuestLine.getActiveQuestLine().groupList.add(group);
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public static Group getGroup(int id) {
        return QuestLine.getActiveQuestLine().groups.get(id);
    }

    public int getRetrievalCount(EntityPlayer player) {
        GroupData data = QuestingData.getQuestingData(player).getGroupData(this.id);
        return data != null ? data.retrieved : 0;
    }

    public void setRetrievalCount(EntityPlayer player, int count) {
        GroupData data = QuestingData.getQuestingData(player).getGroupData(this.id);
        if (data != null) {
            data.retrieved = count;
        }
    }

    public boolean isValid(EntityPlayer player) {
        return this.limit == 0 || this.getRetrievalCount(player) < this.limit;
    }
}

