/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import cpw.mods.fml.common.FMLCommonHandler;
import hardcorequesting.FileVersion;
import hardcorequesting.QuestingData;
import hardcorequesting.TeamStats;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.network.PacketId;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class Team {
    private RewardSetting rewardSetting = RewardSetting.access$000();
    private LifeSetting lifeSetting = LifeSetting.SHARE;
    private int clientTeamLives = -1;
    public static ErrorMessage latestError;
    private int id = -1;
    private List<PlayerEntry> players = new ArrayList<PlayerEntry>();
    private List<Team> invites;
    private String name;
    private List<QuestData> questData;
    public static boolean reloadedInvites;

    public void resetProgress(Quest quest) {
        this.questData.set(quest.getId(), Quest.getQuest(quest.getId()).createData(this.getPlayerCount()));
    }

    public float getProgress() {
        int completed = 0;
        int total = 0;
        for (QuestData data : this.questData) {
            if (data == null) continue;
            ++total;
            if (!data.completed) continue;
            ++completed;
        }
        return (float)completed / (float)total;
    }

    public RewardSetting getRewardSetting() {
        return this.rewardSetting;
    }

    public LifeSetting getLifeSetting() {
        return this.lifeSetting;
    }

    public int getId() {
        return this.id;
    }

    public boolean isSharingLives() {
        return this.lifeSetting == LifeSetting.SHARE;
    }

    public int getSharedLives() {
        if (this.clientTeamLives != -1) {
            return this.clientTeamLives;
        }
        int lives = 0;
        for (PlayerEntry entry : this.getPlayers()) {
            if (!entry.inTeam) continue;
            lives += QuestingData.getQuestingData(entry.getName()).getRawLives();
        }
        return lives;
    }

    public int getPlayerCount() {
        int count = 0;
        for (PlayerEntry player : this.players) {
            if (!player.inTeam) continue;
            ++count;
        }
        return count;
    }

    public void removePlayer(String playerName) {
        int id = 0;
        for (PlayerEntry player : this.players) {
            if (!player.inTeam) continue;
            if (player.getName().equals(playerName)) {
                QuestData data;
                QuestData leaveData;
                int i;
                Team leaveTeam = new Team(playerName);
                leaveTeam.getPlayers().get(0).setBookOpen(player.bookOpen);
                for (i = 0; i < this.questData.size(); ++i) {
                    leaveData = leaveTeam.questData.get(i);
                    data = this.questData.get(i);
                    if (data == null) continue;
                    boolean[] old = data.reward;
                    data.reward = new boolean[old.length - 1];
                    for (int j = 0; j < data.reward.length; ++j) {
                        data.reward[j] = j < id ? old[j] : old[j + 1];
                    }
                    leaveData.reward[0] = old[id];
                }
                this.players.remove(id);
                for (i = 0; i < this.questData.size(); ++i) {
                    leaveData = leaveTeam.questData.get(i);
                    data = this.questData.get(i);
                    if (data == null || Quest.getQuest(i) == null) continue;
                    Quest.getQuest(i).copyProgress(leaveData, data);
                }
                QuestingData.getQuestingData(playerName).setTeam(leaveTeam);
                break;
            }
            ++id;
        }
    }

    public void refreshTeamData(UpdateType type) {
        for (PlayerEntry entry : this.getPlayers()) {
            this.refreshTeamData(entry, type);
        }
    }

    private void refreshTeamData(PlayerEntry entry, UpdateType type) {
        Team team = this;
        boolean valid = false;
        switch (type) {
            case ALL: {
                if (entry.shouldRefreshData()) {
                    valid = true;
                    break;
                }
            }
            case ONLY_INVITES: {
                team = QuestingData.getQuestingData(entry.getName()).getTeam();
                valid = !entry.isInTeam() && team.getEntry(entry.getName()).shouldRefreshData();
                break;
            }
            case ONLY_MEMBERS: {
                valid = entry.shouldRefreshData();
                break;
            }
            case ONLY_OWNER: {
                boolean bl = valid = entry.shouldRefreshData() && entry.isOwner();
            }
        }
        if (valid) {
            DataWriter dw = PacketHandler.getWriter(PacketId.REFRESH_TEAM);
            dw.writeBoolean(true);
            team.writeTeamData(dw, true);
            PacketHandler.sendToPlayer(entry.getName(), dw);
        }
    }

    public void refreshTeamLives() {
        if (!this.isSingle() && this.isSharingLives()) {
            for (PlayerEntry entry : this.getPlayers()) {
                if (!entry.shouldRefreshData()) continue;
                DataWriter dw = PacketHandler.getWriter(PacketId.REFRESH_TEAM);
                dw.writeBoolean(false);
                dw.writeData(this.getSharedLives(), DataBitHelper.TEAM_LIVES);
                PacketHandler.sendToPlayer(entry.getName(), dw);
            }
        }
    }

    public void refreshData() {
        for (PlayerEntry entry : this.getPlayers()) {
            if (!entry.shouldRefreshData()) continue;
            QuestingData.getQuestingData(entry.getName()).refreshClientData(entry.getName());
        }
    }

    public void clearProgress() {
        this.questData.clear();
        this.createQuestData();
        int playerCount = this.getPlayerCount();
        for (int i = 0; i < Quest.size(); ++i) {
            if (Quest.getQuest(i) == null || this.questData.get(i) == null) continue;
            Quest.getQuest(i).preRead(playerCount, this.questData.get(i));
        }
        this.refreshData();
    }

    public void onPacket(DataReader dr) {
        if (dr.readBoolean()) {
            this.readTeamData(QuestingData.FILE_VERSION, dr, true);
        } else {
            this.clientTeamLives = dr.readData(DataBitHelper.TEAM_LIVES);
        }
    }

    public void deleteTeam() {
        for (int i = this.players.size() - 1; i >= 0; --i) {
            PlayerEntry player = this.players.get(i);
            if (player.isInTeam()) {
                this.removePlayer(player.getName());
            } else {
                this.players.remove(i);
            }
            QuestingData.getQuestingData(player.getName()).getTeam().refreshTeamData(player, UpdateType.ONLY_MEMBERS);
        }
        List<Team> teams = QuestingData.getTeams();
        teams.remove(this.id);
        for (int i = this.id; i < teams.size(); ++i) {
            Team team = teams.get(i);
            --team.id;
        }
        for (String username : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72369_d()) {
            Team team = QuestingData.getQuestingData(username).getTeam();
            PlayerEntry entry = team.getEntry(username);
            if (entry == null) continue;
            team.refreshTeamData(entry, UpdateType.ONLY_MEMBERS);
        }
    }

    public List<Team> getInvites() {
        return this.invites;
    }

    public List<PlayerEntry> getPlayers() {
        return this.players;
    }

    private DataWriter getWriter(TeamAction action) {
        DataWriter dw = PacketHandler.getWriter(PacketId.TEAM);
        dw.writeData(action.ordinal(), DataBitHelper.TEAM_ACTION_ID);
        return dw;
    }

    public void create(String name) {
        DataWriter dw = this.getWriter(TeamAction.CREATE);
        dw.writeString(name, DataBitHelper.NAME_LENGTH);
        PacketHandler.sendToServer(dw);
    }

    public void invite(String name) {
        DataWriter dw = this.getWriter(TeamAction.INVITE);
        dw.writeString(name, DataBitHelper.NAME_LENGTH);
        PacketHandler.sendToServer(dw);
    }

    public void accept() {
        DataWriter dw = this.getWriter(TeamAction.ACCEPT);
        dw.writeData(this.id, DataBitHelper.TEAMS);
        PacketHandler.sendToServer(dw);
    }

    public void decline() {
        DataWriter dw = this.getWriter(TeamAction.DECLINE);
        dw.writeData(this.id, DataBitHelper.TEAMS);
        PacketHandler.sendToServer(dw);
    }

    public void kick(String name) {
        DataWriter dw = this.getWriter(TeamAction.KICK);
        dw.writeString(name, DataBitHelper.NAME_LENGTH);
        PacketHandler.sendToServer(dw);
    }

    public void leave() {
        PacketHandler.sendToServer(this.getWriter(TeamAction.LEAVE));
    }

    public void disband() {
        PacketHandler.sendToServer(this.getWriter(TeamAction.DISBAND));
    }

    public void nextLifeSetting() {
        PacketHandler.sendToServer(this.getWriter(TeamAction.NEXT_LIFE_SETTING));
    }

    public void nextRewardSetting() {
        PacketHandler.sendToServer(this.getWriter(TeamAction.NEXT_REWARD_SETTING));
    }

    public static void handlePacket(EntityPlayer player, DataReader dr, boolean onServer) {
        if (onServer) {
            Team.handleServerPacket(player, dr);
        } else {
            Team.handleClientPacket(player, dr);
        }
    }

    private static void handleClientPacket(EntityPlayer player, DataReader dr) {
        latestError = ErrorMessage.values()[dr.readData(DataBitHelper.TEAM_ERROR)];
    }

    private static void handleServerPacket(EntityPlayer player, DataReader dr) {
        TeamAction action = TeamAction.values()[dr.readData(DataBitHelper.TEAM_ACTION_ID)];
        String playerName = QuestingData.getUserName(player);
        Team team = QuestingData.getQuestingData(player).getTeam();
        block0 : switch (action) {
            case CREATE: {
                String teamName;
                if (!team.isSingle() || (teamName = dr.readString(DataBitHelper.NAME_LENGTH)).length() == 0) break;
                for (Team t : QuestingData.getTeams()) {
                    if (!t.getName().equals(teamName)) continue;
                    ErrorMessage.USED_NAME.sendToClient(player);
                    return;
                }
                QuestingData.addTeam(team);
                team.name = teamName;
                team.refreshTeamData(UpdateType.ONLY_MEMBERS);
                Team.declineAll(playerName);
                TeamStats.refreshTeam(team);
                break;
            }
            case INVITE: {
                if (team.isSingle() || !team.isOwner(playerName)) break;
                PlayerEntry entry = new PlayerEntry(dr.readString(DataBitHelper.NAME_LENGTH), false, false);
                if (!QuestingData.hasData(entry.getName())) {
                    ErrorMessage.INVALID_PLAYER.sendToClient(player);
                    break;
                }
                if (!QuestingData.getQuestingData(entry.getName()).getTeam().isSingle()) {
                    ErrorMessage.IN_PARTY.sendToClient(player);
                    break;
                }
                if (team.players.contains(entry)) break;
                team.players.add(entry);
                team.refreshTeamData(UpdateType.ONLY_MEMBERS);
                QuestingData.getQuestingData(entry.getName()).getTeam().refreshTeamData(UpdateType.ONLY_MEMBERS);
                break;
            }
            case ACCEPT: {
                int acceptId;
                if (!team.isSingle() || (acceptId = dr.readData(DataBitHelper.TEAMS)) < 0 || acceptId >= QuestingData.getTeams().size()) break;
                Team inviteTeam = QuestingData.getTeams().get(acceptId);
                int id = 0;
                for (PlayerEntry entry : inviteTeam.getPlayers()) {
                    QuestData questData;
                    QuestData joinData;
                    int i;
                    if (entry.inTeam) {
                        ++id;
                        continue;
                    }
                    if (!entry.name.equals(playerName)) continue;
                    entry.setBookOpen(team.getPlayers().get(0).bookOpen);
                    entry.inTeam = true;
                    QuestingData.getQuestingData(entry.name).setTeam(inviteTeam);
                    team.setId(inviteTeam.getId());
                    for (i = 0; i < inviteTeam.questData.size(); ++i) {
                        joinData = team.questData.get(i);
                        questData = inviteTeam.questData.get(i);
                        if (questData == null) continue;
                        boolean[] old = questData.reward;
                        questData.reward = new boolean[old.length + 1];
                        for (int j = 0; j < questData.reward.length; ++j) {
                            questData.reward[j] = j == id ? joinData.reward[0] : (j < id ? old[j] : old[j - 1]);
                        }
                    }
                    for (i = 0; i < inviteTeam.questData.size(); ++i) {
                        joinData = team.questData.get(i);
                        questData = inviteTeam.questData.get(i);
                        if (questData == null || Quest.getQuest(i) == null) continue;
                        Quest.getQuest(i).mergeProgress(playerName, questData, joinData);
                    }
                    inviteTeam.refreshData();
                    inviteTeam.refreshTeamData(UpdateType.ONLY_INVITES);
                    Team.declineAll(playerName);
                    TeamStats.refreshTeam(team);
                    break block0;
                }
                break;
            }
            case DECLINE: {
                int declineId;
                if (!team.isSingle() || (declineId = dr.readData(DataBitHelper.TEAMS)) < 0 || declineId >= QuestingData.getTeams().size()) break;
                Team inviteTeam = QuestingData.getTeams().get(declineId);
                inviteTeam.getPlayers().remove(new PlayerEntry(playerName, false, false));
                inviteTeam.refreshTeamData(UpdateType.ONLY_OWNER);
                team.refreshTeamData(UpdateType.ONLY_MEMBERS);
                break;
            }
            case KICK: {
                String playerToRemove;
                PlayerEntry entryToRemove;
                if (team.isSingle() || !team.isOwner(playerName) || (entryToRemove = team.getEntry(playerToRemove = dr.readString(DataBitHelper.NAME_LENGTH))).isOwner()) break;
                if (entryToRemove.inTeam) {
                    team.removePlayer(playerToRemove);
                    team.refreshTeamData(UpdateType.ALL);
                    TeamStats.refreshTeam(team);
                } else {
                    team.getPlayers().remove(entryToRemove);
                    team.refreshTeamData(UpdateType.ONLY_OWNER);
                }
                QuestingData.getQuestingData(playerToRemove).getTeam().refreshTeamData(UpdateType.ONLY_MEMBERS);
                break;
            }
            case LEAVE: {
                if (team.isSingle() || team.isOwner(playerName)) break;
                team.removePlayer(playerName);
                team.refreshTeamData(UpdateType.ALL);
                QuestingData.getQuestingData(playerName).getTeam().refreshTeamData(UpdateType.ONLY_MEMBERS);
                TeamStats.refreshTeam(team);
                break;
            }
            case DISBAND: {
                if (team.isSingle() || !team.isOwner(playerName)) break;
                team.deleteTeam();
                TeamStats.refreshTeam(team);
                break;
            }
            case NEXT_LIFE_SETTING: {
                if (team.isSingle() || !team.isOwner(playerName)) break;
                team.lifeSetting = LifeSetting.values()[(team.lifeSetting.ordinal() + 1) % LifeSetting.values().length];
                team.refreshTeamData(UpdateType.ALL);
                break;
            }
            case NEXT_REWARD_SETTING: {
                if (team.isSingle() || !team.isOwner(playerName)) break;
                team.rewardSetting = RewardSetting.values()[(team.rewardSetting.ordinal() + 1) % RewardSetting.values().length];
                if (team.rewardSetting == RewardSetting.ALL) {
                    team.rewardSetting = RewardSetting.getDefault();
                }
                team.refreshTeamData(UpdateType.ALL);
            }
        }
    }

    private boolean isOwner(String playerName) {
        PlayerEntry entry = this.getEntry(playerName);
        return entry != null && entry.isOwner();
    }

    public PlayerEntry getEntry(String playerName) {
        for (PlayerEntry playerEntry : this.getPlayers()) {
            if (!playerEntry.getName().equals(playerName)) continue;
            return playerEntry;
        }
        return null;
    }

    private static void declineAll(String playerName) {
        block0: for (Team team : QuestingData.getTeams()) {
            Iterator<PlayerEntry> iterator = team.getPlayers().iterator();
            while (iterator.hasNext()) {
                PlayerEntry playerEntry = iterator.next();
                if (playerEntry.isInTeam() || !playerEntry.getName().equals(playerName)) continue;
                iterator.remove();
                team.refreshTeamData(UpdateType.ONLY_OWNER);
                continue block0;
            }
        }
    }

    public Team(String player) {
        if (player != null) {
            this.players.add(new PlayerEntry(player, true, true));
        }
        this.createQuestData();
    }

    private void createQuestData() {
        this.questData = new ArrayList<QuestData>();
        for (int i = 0; i < Quest.size(); ++i) {
            this.createQuestData(i);
        }
    }

    private void createQuestData(int id) {
        if (id > this.questData.size()) {
            this.createQuestData(id - 1);
        }
        if (Quest.getQuest(id) != null) {
            this.questData.add(id, Quest.getQuest(id).createData(1));
        } else {
            this.questData.add(id, null);
        }
    }

    public QuestData getQuestData(int id) {
        if (id >= this.questData.size()) {
            this.createQuestData(id);
        }
        return this.questData.get(id);
    }

    public void loadData(FileVersion version, DataReader dr, boolean light) {
        this.readTeamData(version, dr, light);
        int playerCount = this.getPlayerCount();
        if (light) {
            for (int i = 0; i < this.questData.size(); ++i) {
                if (this.questData.get(i) == null) continue;
                Quest.getQuest(i).preRead(playerCount, this.questData.get(i));
                Quest.getQuest(i).read(dr, this.questData.get(i), version, true);
            }
        } else {
            for (int i = 0; i < Quest.size(); ++i) {
                Quest quest = Quest.getQuest(i);
                QuestData data = this.questData.get(i);
                if (quest == null || data == null) continue;
                quest.preRead(playerCount, data);
            }
            int count = dr.readData(DataBitHelper.QUESTS);
            for (int i = 0; i < count; ++i) {
                int id = dr.readData(DataBitHelper.QUESTS);
                Quest quest = Quest.getQuest(id);
                int bits = -1;
                if (version.contains(FileVersion.REMOVED_QUESTS)) {
                    bits = dr.readData(DataBitHelper.INT);
                }
                if (quest != null && this.questData.get(id) != null) {
                    quest.read(dr, this.questData.get(id), version, false);
                    continue;
                }
                if (!version.contains(FileVersion.REMOVED_QUESTS)) continue;
                dr.readData(bits);
            }
        }
    }

    private void readTeamData(FileVersion version, DataReader dr, boolean light) {
        if (light) {
            int count;
            this.setId(dr.readBoolean() ? -1 : 0);
            reloadedInvites = true;
            this.invites = null;
            if (this.isSingle() && (count = dr.readData(DataBitHelper.TEAMS)) != 0) {
                this.invites = new ArrayList<Team>();
                for (int i = 0; i < count; ++i) {
                    Team team = new Team(null);
                    team.loadTeamData(version, dr, true);
                    this.invites.add(team);
                }
            }
        }
        if (version.contains(FileVersion.TEAMS) && !this.isSingle()) {
            this.loadTeamData(version, dr, light);
        }
        if (light && !this.isSingle() && this.isSharingLives()) {
            this.clientTeamLives = dr.readData(DataBitHelper.TEAM_LIVES);
        }
    }

    private void loadTeamData(FileVersion version, DataReader dr, boolean light) {
        this.name = dr.readString(DataBitHelper.NAME_LENGTH);
        this.id = dr.readData(DataBitHelper.TEAMS);
        if (version.contains(FileVersion.TEAM_SETTINGS)) {
            this.lifeSetting = LifeSetting.values()[dr.readData(DataBitHelper.TEAM_LIVES_SETTING)];
            this.rewardSetting = RewardSetting.values()[dr.readData(DataBitHelper.TEAM_REWARD_SETTING)];
            if (this.rewardSetting == RewardSetting.ALL) {
                this.rewardSetting = RewardSetting.getDefault();
            }
        }
        this.players.clear();
        int count = dr.readData(DataBitHelper.PLAYERS);
        for (int i = 0; i < count; ++i) {
            boolean inTeam;
            String name = dr.readString(DataBitHelper.NAME_LENGTH);
            if (name == null) {
                name = "Unknown";
            }
            boolean owner = (inTeam = dr.readBoolean()) && dr.readBoolean();
            this.players.add(new PlayerEntry(name, inTeam, owner));
        }
    }

    public boolean isSingle() {
        return this.id == -1;
    }

    public void saveData(DataWriter dw, boolean light) {
        this.writeTeamData(dw, light);
        if (light) {
            for (int i = 0; i < this.questData.size(); ++i) {
                if (this.questData.get(i) == null || Quest.getQuest(i) == null) continue;
                Quest.getQuest(i).save(dw, this.questData.get(i), true);
            }
        } else {
            int count = 0;
            for (Quest quest : Quest.getQuests()) {
                if (quest == null) continue;
                ++count;
            }
            dw.writeData(count, DataBitHelper.QUESTS);
            for (int i = 0; i < this.questData.size(); ++i) {
                if (this.questData.get(i) == null || Quest.getQuest(i) == null) continue;
                dw.writeData(i, DataBitHelper.QUESTS);
                dw.createBuffer(DataBitHelper.INT);
                Quest.getQuest(i).save(dw, this.questData.get(i), false);
                dw.flushBuffer();
            }
        }
    }

    private void writeTeamData(DataWriter dw, boolean light) {
        if (light) {
            dw.writeBoolean(this.isSingle());
            if (this.isSingle()) {
                String name = this.players.get(0).name;
                ArrayList<Team> invitingTeams = new ArrayList<Team>();
                block0: for (Team team : QuestingData.getTeams()) {
                    for (PlayerEntry player : team.players) {
                        if (player.inTeam || !player.name.equals(name)) continue;
                        invitingTeams.add(team);
                        continue block0;
                    }
                }
                dw.writeData(invitingTeams.size(), DataBitHelper.TEAMS);
                for (Team invitingTeam : invitingTeams) {
                    invitingTeam.saveTeamData(dw, true);
                }
            }
        }
        if (!this.isSingle()) {
            this.saveTeamData(dw, light);
        }
        if (light && !this.isSingle() && this.isSharingLives()) {
            dw.writeData(this.getSharedLives(), DataBitHelper.TEAM_LIVES);
        }
    }

    private void saveTeamData(DataWriter dw, boolean light) {
        dw.writeString(this.name, DataBitHelper.NAME_LENGTH);
        dw.writeData(this.id, DataBitHelper.TEAMS);
        dw.writeData(this.lifeSetting.ordinal(), DataBitHelper.TEAM_LIVES_SETTING);
        dw.writeData(this.rewardSetting.ordinal(), DataBitHelper.TEAM_REWARD_SETTING);
        dw.writeData(this.players.size(), DataBitHelper.PLAYERS);
        for (PlayerEntry player : this.players) {
            dw.writeString(player.name, DataBitHelper.NAME_LENGTH);
            dw.writeBoolean(player.inTeam);
            if (!player.inTeam) continue;
            dw.writeBoolean(player.owner);
        }
    }

    public void postRead(QuestingData data, FileVersion version) {
        for (int i = 0; i < this.questData.size(); ++i) {
            if (Quest.getQuest(i) == null || this.questData.get(i) == null) continue;
            Quest.getQuest(i).postRead(data, this.questData.get(i), version);
        }
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public static class PlayerEntry {
        private String name;
        private boolean inTeam;
        private boolean owner;
        private boolean bookOpen;

        public PlayerEntry(String name, boolean inTeam, boolean owner) {
            this.name = name;
            this.inTeam = inTeam;
            this.owner = owner;
            this.bookOpen = false;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInTeam() {
            return this.inTeam;
        }

        public boolean isOwner() {
            return this.owner;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlayerEntry entry = (PlayerEntry)o;
            return !(this.name != null ? !this.name.equals(entry.name) : entry.name != null);
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public boolean shouldRefreshData() {
            return this.bookOpen || PacketHandler.getOverriddenBy(this.name) != null;
        }

        public boolean isBookOpen() {
            return this.bookOpen;
        }

        public void setBookOpen(boolean bookOpen) {
            this.bookOpen = bookOpen;
        }
    }

    public static enum ErrorMessage {
        INVALID_PLAYER("Invite Error", "The username does not match a player on this server. The players you invite must have logged on at least once before."),
        IN_PARTY("Invite Error", "That player is already in a party, you can't invite players from other parties."),
        USED_NAME("Team Error", "That party name is already used by someone else.");

        private String header;
        private String message;

        private ErrorMessage(String header, String message) {
            this.message = message;
            this.header = header;
        }

        public String getMessage() {
            return this.message;
        }

        public String getHeader() {
            return this.header;
        }

        public void sendToClient(EntityPlayer player) {
            DataWriter dw = PacketHandler.getWriter(PacketId.TEAM);
            dw.writeData(this.ordinal(), DataBitHelper.TEAM_ERROR);
            PacketHandler.sendToPlayer(QuestingData.getUserName(player), dw);
        }
    }

    private static enum TeamAction {
        CREATE,
        INVITE,
        ACCEPT,
        DECLINE,
        KICK,
        LEAVE,
        DISBAND,
        NEXT_LIFE_SETTING,
        NEXT_REWARD_SETTING;

    }

    public static enum UpdateType {
        ALL,
        ONLY_MEMBERS,
        ONLY_INVITES,
        ONLY_OWNER;

    }

    public static enum RewardSetting {
        ALL("Multiple rewards", "Everyone in the party can claim their rewards from a quest. This option gives more rewards than the others but can be disabled in the config."),
        ANY("Shared rewards", "The party receives one set of rewards when completing a quest. Anyone can claim the reward but as soon as it is claimed no body else can claim it."),
        RANDOM("Random rewards", "Each time the party completes a quest that set of rewards is assigned to a player. This player is the only one that can claim the rewards.");

        private String title;
        private String description;
        public static boolean isAllModeEnabled;

        private static RewardSetting getDefault() {
            return isAllModeEnabled ? ALL : ANY;
        }

        private RewardSetting(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum LifeSetting {
        SHARE("Shared lives", "Everyone puts their lives into a shared pool. If anyone dies a life is removed from there. Everyone needs at least one life to be kept in the game, so if your death results in the party getting too few lives, you get banned. The others can keep playing."),
        INDIVIDUAL("Individual lives", "Everyone keeps their lives separated. If you run out of lives, you're out of the game. The other players in the party can continue playing with their lives.");

        private String title;
        private String description;

        private LifeSetting(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

