/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import hardcorequesting.DeathStats;
import hardcorequesting.FileVersion;
import hardcorequesting.Team;
import hardcorequesting.TeamStats;
import hardcorequesting.bag.Group;
import hardcorequesting.bag.GroupData;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.config.ModConfig;
import hardcorequesting.items.Items;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.FileHelper;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.network.PacketId;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestData;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.BanEntry;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.StringUtils;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.FakePlayer;

public class QuestingData {
    private Team team;
    private int lives;
    private String name;
    private List<GroupData> groupData;
    public int selectedQuest = -1;
    public int selectedTask = -1;
    public boolean playedLore;
    public boolean receivedBook;
    private DeathStats deathStat;
    private static boolean hardcoreActive;
    private static boolean questActive;
    public static int defaultLives;
    private static HashMap<String, QuestingData> data;
    private static List<Team> teams;
    public static boolean autoHardcoreActivate;
    public static boolean autoQuestActivate;
    public static final FileVersion FILE_VERSION;
    private static final FileHelper FILE_HELPER;
    private static final String path = "HardcoreQuesting/players.dat";

    static HashMap<String, QuestingData> getData() {
        return data;
    }

    public DeathStats getDeathStat() {
        return this.deathStat;
    }

    public String getName() {
        return this.name;
    }

    private QuestingData(String name) {
        this.lives = defaultLives;
        this.name = name;
        this.team = new Team(name);
        this.createGroupData();
        this.deathStat = new DeathStats(name);
        data.put(name, this);
    }

    private void createGroupData() {
        this.groupData = new ArrayList<GroupData>();
        for (int i = 0; i < Group.size(); ++i) {
            this.createGroupData(i);
        }
    }

    private void createGroupData(int id) {
        int start;
        for (int i = start = id >= this.groupData.size() ? this.groupData.size() : id; i <= id; ++i) {
            if (Group.getGroup(i) != null) {
                this.groupData.add(i, new GroupData());
                continue;
            }
            this.groupData.add(i, null);
        }
    }

    public int getLives() {
        boolean shareLives = this.getTeam().isSharingLives();
        if (shareLives) {
            return this.getTeam().getSharedLives();
        }
        return this.getRawLives();
    }

    public int getLivesToStayAlive() {
        boolean shareLives = this.getTeam().isSharingLives();
        if (shareLives) {
            return this.getTeam().getPlayerCount();
        }
        return 1;
    }

    public int getRawLives() {
        return this.lives;
    }

    public QuestData getQuestData(int id) {
        return this.getTeam().getQuestData(id);
    }

    public GroupData getGroupData(int id) {
        if (id < 0 || id >= Group.size()) {
            return null;
        }
        if (id >= this.groupData.size()) {
            this.createGroupData(id);
        }
        return this.groupData.get(id);
    }

    public int addLives(EntityPlayer player, int amount) {
        int max = ModConfig.MAXLIVES;
        int i = this.getRawLives() + amount;
        this.lives = i <= max ? i : max;
        this.getTeam().refreshTeamLives();
        return this.lives;
    }

    public void removeLifeAndSendMessage(EntityPlayer player) {
        boolean isDead;
        boolean bl = isDead = !this.removeLives(player, 1);
        if (!isDead) {
            player.func_71035_c("You just lost a life. You have " + this.getLives() + " live(s) left");
        }
        if (this.getTeam().isSharingLives()) {
            for (Team.PlayerEntry entry : this.getTeam().getPlayers()) {
                EntityPlayer other;
                if (!entry.isInTeam() || entry.getName().equals(QuestingData.getUserName(player)) || (other = QuestingData.getPlayer(entry.getName())) == null) continue;
                other.func_71035_c(QuestingData.getUserName(player) + " just lost a life" + (isDead ? " and got banned" : "") + ". You have " + this.getLives() + " live(s) left");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLives(EntityPlayer player, int amount) {
        boolean shareLives = this.getTeam().isSharingLives();
        if (shareLives) {
            int dif = Math.min(this.lives - 1, amount);
            amount -= dif;
            this.lives -= dif;
            block4: while (amount > 0) {
                int players = 0;
                for (Team.PlayerEntry entry : QuestingData.getQuestingData(player).getTeam().getPlayers()) {
                    if (entry.getName().equals(QuestingData.getUserName(player)) || QuestingData.getQuestingData(entry.getName()).getRawLives() <= 1) continue;
                    ++players;
                }
                if (players == 0) break;
                int id = (int)(Math.random() * (double)players);
                for (Team.PlayerEntry entry : QuestingData.getQuestingData(player).getTeam().getPlayers()) {
                    if (entry.getName().equals(QuestingData.getUserName(player)) || QuestingData.getQuestingData(entry.getName()).getRawLives() <= 1) continue;
                    if (id == 0) {
                        --QuestingData.getQuestingData((String)entry.getName()).lives;
                        --amount;
                        continue block4;
                    }
                    --id;
                }
            }
            this.lives -= amount;
        } else {
            this.lives = this.getRawLives() - amount;
        }
        this.getTeam().refreshTeamLives();
        try {
            boolean bl;
            if (this.getLives() < this.getLivesToStayAlive()) {
                this.outOfLives(player);
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            TeamStats.refreshTeam(this.team);
        }
    }

    public void die(EntityPlayer player) {
        if (!QuestingData.isHardcoreActive()) {
            return;
        }
        this.removeLifeAndSendMessage(player);
    }

    private void outOfLives(EntityPlayer playerEntity) {
        QuestingData data = QuestingData.getQuestingData(playerEntity);
        Team team = data.getTeam();
        if (!team.isSingle() && !teams.isEmpty()) {
            team.removePlayer(QuestingData.getUserName(playerEntity));
            if (team.getPlayerCount() == 0) {
                team.deleteTeam();
            } else {
                team.refreshTeamData(Team.UpdateType.ALL);
            }
        }
        playerEntity.field_71071_by.func_82347_b(-1, -1);
        MinecraftServer mcServer = MinecraftServer.func_71276_C();
        if (mcServer.func_71264_H() && playerEntity.func_70005_c_().equals(mcServer.func_71214_G())) {
            ((EntityPlayerMP)playerEntity).field_71135_a.func_72565_c("You're out of lives. Game over, man, it's game over!");
            mcServer.func_71272_O();
        } else {
            BanEntry banentry = new BanEntry(playerEntity.func_70005_c_());
            banentry.func_73689_b("Out of lives in Hardcore Questing mode");
            banentry.func_73687_a("HQM");
            mcServer.func_71203_ab().func_72390_e().func_73706_a(banentry);
            ((EntityPlayerMP)playerEntity).field_71135_a.func_72565_c("You're out of lives. Game over, man, it's game over!");
            SoundHandler.playToAll(Sounds.DEATH);
        }
    }

    public static boolean isSinglePlayer() {
        return MinecraftServer.func_71276_C().func_71264_H();
    }

    public static boolean isHardcoreActive() {
        return hardcoreActive;
    }

    public static boolean isQuestActive() {
        return questActive;
    }

    public static void activateHardcore() {
        if (!hardcoreActive && !MinecraftServer.func_71276_C().func_130014_f_().func_72912_H().func_76093_s()) {
            hardcoreActive = true;
        }
    }

    public static void activateQuest() {
        if (!questActive) {
            questActive = true;
            for (String name : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72369_d()) {
                EntityPlayerMP player;
                if (name == null || (player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72361_f(name)) == null) continue;
                QuestingData.spawnBook((EntityPlayer)player);
            }
        }
    }

    public static void deactivate() {
        if (hardcoreActive || questActive) {
            PacketHandler.reset();
            hardcoreActive = false;
            questActive = false;
            data = new HashMap();
            teams = new ArrayList<Team>();
        }
    }

    public static List<Team> getTeams() {
        return teams;
    }

    public static List<Team> getAllTeams() {
        ArrayList<Team> all = new ArrayList<Team>();
        for (Team team : QuestingData.getTeams()) {
            all.add(team);
        }
        for (QuestingData player : data.values()) {
            if (!player.getTeam().isSingle()) continue;
            all.add(player.getTeam());
        }
        return all;
    }

    public static QuestingData getQuestingData(EntityPlayer player) {
        return QuestingData.getQuestingData(QuestingData.getUserName(player));
    }

    public static String getUserName(EntityPlayer player) {
        String name = StringUtils.func_76338_a((String)player.field_71092_bJ);
        String override = PacketHandler.getOverriddenName(name);
        return override != null ? override : name;
    }

    public static QuestingData getQuestingData(String name) {
        if (!data.containsKey(name)) {
            new QuestingData(name);
        }
        return data.get(name);
    }

    public static void load(File worldPath, WorldServer world) {
        File file = new File(worldPath, path);
        QuestingData.deactivate();
        if (!file.exists()) {
            if (world.func_72912_H().func_82573_f() == 0L) {
                if (autoHardcoreActivate) {
                    QuestingData.activateHardcore();
                }
                if (autoQuestActivate) {
                    QuestingData.activateQuest();
                }
            }
            return;
        }
        data.clear();
        teams.clear();
        FILE_HELPER.loadData(file);
    }

    public static void save(File worldPath, WorldServer world) {
        if (!QuestingData.isHardcoreActive() && !QuestingData.isQuestActive() || Quest.isEditing) {
            return;
        }
        File file = new File(worldPath, path);
        FILE_HELPER.saveData(file);
    }

    public static void saveAllData(DataWriter dw) {
        dw.writeBoolean(QuestingData.isHardcoreActive());
        dw.writeBoolean(QuestingData.isQuestActive());
        dw.writeData(teams.size(), DataBitHelper.TEAMS);
        for (Team team : teams) {
            team.saveData(dw, false);
        }
        dw.writeData(data.values().size(), DataBitHelper.PLAYERS);
        for (QuestingData d : data.values()) {
            dw.writeString(d.name, DataBitHelper.NAME_LENGTH);
            d.saveData(dw, false);
        }
    }

    public static void readAllData(DataReader dr, FileVersion version) {
        if (version.lacks(FileVersion.SETS)) {
            QuestingData.activateHardcore();
            QuestingData.activateQuest();
        }
        if (version.lacks(FileVersion.QUESTS)) {
            while (dr.doesUnderlyingStreamHasMoreThanAByteOfData()) {
                new QuestingData(version, dr);
            }
        } else {
            int i;
            if (dr.readBoolean()) {
                QuestingData.activateHardcore();
            }
            if (dr.readBoolean()) {
                QuestingData.activateQuest();
            }
            if (version.contains(FileVersion.TEAMS)) {
                int teamAmount = dr.readData(DataBitHelper.TEAMS);
                for (i = 0; i < teamAmount; ++i) {
                    Team team = new Team(null);
                    QuestingData.addTeam(team);
                    team.loadData(version, dr, false);
                }
            }
            int amount = dr.readData(DataBitHelper.PLAYERS);
            for (i = 0; i < amount; ++i) {
                new QuestingData(version, dr);
            }
        }
    }

    private QuestingData(FileVersion version, DataReader dr) {
        this.name = dr.readString(version.lacks(FileVersion.QUESTS) ? DataBitHelper.BYTE : DataBitHelper.NAME_LENGTH);
        this.deathStat = new DeathStats(this.name);
        this.createGroupData();
        this.loadData(version, dr, version.lacks(FileVersion.SETS));
        if (!data.containsKey(this.name)) {
            data.put(this.name, this);
        }
        this.team.postRead(this, version);
    }

    private void saveData(DataWriter dw, boolean light) {
        if (QuestingData.isHardcoreActive()) {
            dw.writeData(this.lives, DataBitHelper.LIVES);
        }
        if (QuestingData.isQuestActive()) {
            Quest.serverTicker.save(dw);
            if (this.selectedQuest != -1 && this.selectedTask != -1) {
                dw.writeBoolean(true);
                dw.writeData(this.selectedQuest, DataBitHelper.QUESTS);
                dw.writeData(this.selectedTask, DataBitHelper.TASKS);
            } else {
                dw.writeBoolean(false);
            }
            dw.writeBoolean(this.playedLore);
            dw.writeBoolean(this.receivedBook);
            if (this.team.isSingle() || light) {
                dw.writeBoolean(true);
                this.team.saveData(dw, light);
            } else {
                dw.writeBoolean(false);
                dw.writeData(this.team.getId(), DataBitHelper.TEAMS);
            }
            if (!light) {
                int groupCount = 0;
                for (Group group : Group.getGroups()) {
                    if (group == null || group.getLimit() <= 0) continue;
                    ++groupCount;
                }
                dw.writeData(groupCount, DataBitHelper.GROUP_COUNT);
                for (int i = 0; i < this.groupData.size(); ++i) {
                    if (Group.getGroup(i) == null || Group.getGroup(i).getLimit() <= 0) continue;
                    dw.writeData(i, DataBitHelper.GROUP_COUNT);
                    dw.writeData(this.getGroupData((int)i).retrieved, DataBitHelper.LIMIT);
                }
            }
        }
        DeathStats.save(this, dw, light);
        if (light) {
            TeamStats.save(dw);
        }
    }

    private void loadData(FileVersion version, DataReader dr, boolean light) {
        this.lives = QuestingData.isHardcoreActive() ? dr.readData(DataBitHelper.LIVES) : defaultLives;
        if (QuestingData.isQuestActive() && version.contains(FileVersion.QUESTS)) {
            if (version.contains(FileVersion.REPEATABLE_QUESTS)) {
                if (light) {
                    Quest.clientTicker.load(dr);
                } else {
                    Quest.serverTicker.load(dr);
                }
            }
            if (dr.readBoolean()) {
                this.selectedQuest = dr.readData(DataBitHelper.QUESTS);
                this.selectedTask = dr.readData(DataBitHelper.TASKS);
            } else {
                this.selectedQuest = -1;
                this.selectedTask = -1;
            }
            if (version.contains(FileVersion.LORE_AUDIO)) {
                this.playedLore = dr.readBoolean();
                this.receivedBook = dr.readBoolean();
            }
            if (version.lacks(FileVersion.TEAMS) || dr.readBoolean()) {
                this.team = new Team(this.getName());
                this.team.loadData(version, dr, light);
            } else {
                this.team = teams.get(dr.readData(DataBitHelper.TEAMS));
            }
            if (!light && version.contains(FileVersion.BAG_LIMITS)) {
                int groupCount = dr.readData(DataBitHelper.GROUP_COUNT);
                for (int i = 0; i < groupCount; ++i) {
                    int id = dr.readData(DataBitHelper.GROUP_COUNT);
                    if (this.getGroupData(id) == null) continue;
                    this.getGroupData((int)id).retrieved = dr.readData(DataBitHelper.LIMIT);
                }
            }
        }
        if (version.contains(FileVersion.DEATHS)) {
            DeathStats.load(this, dr, light);
        }
        if (light) {
            TeamStats.load(dr);
        }
    }

    private void sendDataToClient(DataWriter dw, String playerName) {
        dw.writeBoolean(QuestingData.isHardcoreActive());
        dw.writeBoolean(QuestingData.isQuestActive());
        this.saveData(dw, true);
        PacketHandler.sendToPlayer(playerName, dw);
    }

    public void sendDataToClientAndOpenInterface(EntityPlayer player, String name) {
        PacketHandler.add(player, name);
        DataWriter dw = PacketHandler.getWriter(PacketId.OPEN_INTERFACE);
        dw.writeBoolean(name != null);
        if (name != null) {
            dw.writeString(QuestingData.getUserName(player), DataBitHelper.NAME_LENGTH);
        }
        this.sendDataToClient(dw, QuestingData.getUserName(player));
    }

    public void refreshClientData(String playerName) {
        this.sendDataToClient(PacketHandler.getWriter(PacketId.REFRESH_INTERFACE), playerName);
    }

    public void receiveDataFromServer(DataReader dr) {
        hardcoreActive = dr.readBoolean();
        questActive = dr.readBoolean();
        this.loadData(FILE_VERSION, dr, true);
    }

    public static void disableHardcore(ICommandSender sender) {
        if (MinecraftServer.func_71276_C().func_130014_f_().func_72912_H().func_76093_s()) {
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"Hardcore mode don't work together with vanilla hardcore mode. Will try to disable it..."));
            try {
                ReflectionHelper.setPrivateValue(WorldInfo.class, (Object)sender.func_130014_f_().func_72912_H(), (Object)false, (int)20);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            if (!MinecraftServer.func_71276_C().func_130014_f_().func_72912_H().func_76093_s()) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"Vanilla hardcore mode has now been disabled. Please reopen your world for the change to take full effect."));
            }
        }
    }

    public static void spawnBook(EntityPlayer player) {
        if (!Quest.isEditing && !player.field_70170_p.field_72995_K && ModConfig.spawnBook && !QuestingData.getQuestingData((EntityPlayer)player).receivedBook && QuestingData.isQuestActive()) {
            QuestingData.getQuestingData((EntityPlayer)player).receivedBook = true;
            ItemStack diary = new ItemStack(Items.book);
            if (!player.field_71071_by.func_70441_a(diary)) {
                QuestingData.spawnItemAtPlayer(player, diary);
            }
        }
    }

    private static void spawnItemAtPlayer(EntityPlayer player, ItemStack stack) {
        EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, stack);
        player.field_70170_p.func_72838_d((Entity)item);
        if (!(player instanceof FakePlayer)) {
            item.func_70100_b_(player);
        }
    }

    public Team getTeam() {
        if (!this.team.isSingle() && !QuestingData.getTeams().isEmpty()) {
            this.team = QuestingData.getTeams().get(this.team.getId());
        }
        return this.team;
    }

    public static void addTeam(Team team) {
        team.setId(teams.size());
        teams.add(team);
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public static EntityPlayer getPlayer(String playerName) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72361_f(playerName);
    }

    public static boolean hasData(String playerName) {
        if (data.containsKey(playerName)) {
            return true;
        }
        EntityPlayer player = QuestingData.getPlayer(playerName);
        return player != null && StringUtils.func_76338_a((String)player.field_71092_bJ).equals(playerName);
    }

    public static void remove(EntityPlayer player) {
        data.remove(QuestingData.getUserName(player));
    }

    public static boolean hasData(EntityPlayer player) {
        return data.containsKey(StringUtils.func_76338_a((String)player.field_71092_bJ));
    }

    static {
        data = new HashMap();
        teams = new ArrayList<Team>();
        FILE_VERSION = FileVersion.values()[FileVersion.values().length - 1];
        FILE_HELPER = new FileHelper(){

            @Override
            public void write(DataWriter dw) {
                QuestingData.saveAllData(dw);
            }

            @Override
            public void read(DataReader dr, FileVersion version) {
                QuestingData.readAllData(dr, version);
            }
        };
    }
}

