/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.log;

import aroma1997.core.log.AromaLevels;
import aroma1997.core.log.AromaLog;
import aroma1997.core.log.AromaSpecialLogger;
import aroma1997.core.util.ServerUtil;
import aroma1997.core.util.Util;
import cpw.mods.fml.common.FMLLog;
import java.util.logging.Level;
import net.minecraft.command.ICommandSender;

public class LogHelper {
    private static AromaLog logger = new AromaLog("Aroma1997Core");

    public static void init() {
        logger.setParent(FMLLog.getLogger());
        if (Util.isDev()) {
            logger.setLevel(Level.ALL);
        }
        logger.log(Level.INFO, "Logger initialized.");
    }

    public static void log(Level level, String message) {
        logger.log(level, message);
    }

    public static void log(Level level, String[] messages) {
        for (String message : messages) {
            LogHelper.log(level, message);
        }
    }

    public static void logServer(Level level, String message) {
        logger.logServer(level, message);
    }

    public static AromaLog getLogger() {
        return logger;
    }

    public static AromaLog genNewLogger(String name) {
        AromaLog newLogger = new AromaLog(name);
        newLogger.setParent(logger);
        return newLogger;
    }

    public static void debugLog(String message) {
        if (!Util.isDev()) {
            return;
        }
        LogHelper.log((Level)AromaLevels.DEBUG, message);
    }

    public static void logException(String msg, Throwable t) {
        logger.log(Level.SEVERE, msg, t);
    }

    public static void sendMessageToPlayer(AromaLog logger, ICommandSender player, String message) {
        player.func_70006_a(ServerUtil.getChatForString(logger.getMessage(true, message)));
    }

    public static AromaSpecialLogger getSpecialLogger() {
        return AromaSpecialLogger.instance;
    }
}

