/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.config;

import aroma1997.core.log.LogHelper;
import java.io.File;
import java.util.logging.Level;
import net.minecraftforge.common.Configuration;

public class Conf {
    private static File configFolder;
    private static boolean initialized;

    public static void init(File folder) {
        if (initialized) {
            return;
        }
        LogHelper.log(Level.FINE, "Initializing Configurations from: " + folder);
        configFolder = new File(folder, "aroma1997");
        initialized = true;
    }

    public static File getConfigFolder() {
        return configFolder;
    }

    public static File getConfigFile(String name) {
        File file = new File(configFolder, name + ".cfg");
        LogHelper.log(Level.FINE, "Loaded configuration " + name + " from: " + file);
        return file;
    }

    public static Configuration getConfig(String name) {
        return new Configuration(Conf.getConfigFile(name));
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        initialized = false;
    }

    public static class Category {
        public static final String SOUND = "SOUND";
    }
}

