/*
 * Decompiled with CFR 0.152.
 */
package cofh.masquerade;

import cofh.CoFHCore;
import cofh.api.core.ISimpleRegistry;
import cofh.core.CoFHProps;
import cofh.masquerade.MasqueradePacketHandler;
import cofh.network.Payload;
import cofh.util.CoreUtils;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.StringUtils;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class RegistryCapes
implements ISimpleRegistry {
    private static HashMap<String, String> capeMap = new HashMap();
    public static boolean allowPlayersUse = true;
    public static boolean allowOpsUse = true;
    public static boolean allowOpsOthers = false;
    public static Configuration capeConf;

    public static void initialize() {
        RegistryCapes.registerDefaults();
        capeConf = new Configuration(new File(CoFHProps.configDir, "/cofh/CoFHMasquerade-Capes.cfg"));
        capeConf.load();
        if (!capeConf.hasCategory("capes")) {
            return;
        }
        for (String name : capeConf.getCategory("capes").keySet()) {
            Property curCape = capeConf.getCategory("capes").get(name);
            RegistryCapes.addCape(name, curCape.getString(), false);
        }
        CoFHCore.log.info("Loaded " + capeConf.getCategory("capes").keySet().size() + " capes.");
    }

    public static boolean addCape(String playerName, String capeURL, boolean saveToFile) {
        if (playerName == null || capeURL == null) {
            return false;
        }
        playerName = playerName.toLowerCase();
        capeMap.put(playerName, capeURL);
        if (saveToFile) {
            capeConf.get("capes", playerName, capeURL);
            capeConf.save();
        }
        return true;
    }

    public static boolean removeCape(String playerName, boolean removeFromFile) {
        if (playerName == null) {
            return false;
        }
        playerName = playerName.toLowerCase();
        capeMap.remove(playerName);
        if (removeFromFile) {
            if (capeConf.hasCategory("capes")) {
                capeConf.getCategory("capes").remove((Object)playerName);
                capeConf.save();
            } else {
                RegistryCapes.registerDefaults();
                return false;
            }
        }
        RegistryCapes.registerDefaults();
        return true;
    }

    public static String getPlayerCape(String playerName) {
        if (playerName == null || !capeMap.containsKey(playerName.toLowerCase())) {
            return String.format("http://skins.minecraft.net/MinecraftCloaks/%s.png", StringUtils.func_76338_a((String)playerName));
        }
        return capeMap.get(playerName.toLowerCase());
    }

    public static boolean playerCanAccess(String playerName) {
        return allowPlayersUse ? true : allowOpsUse && CoreUtils.isOp(playerName);
    }

    public static boolean playerCanSetOthers(String playerName) {
        return allowOpsOthers && CoreUtils.isOp(playerName) && (allowPlayersUse || allowOpsUse);
    }

    public static void readJoinPacket(DataInputStream data) {
        try {
            capeMap = new HashMap();
            int count = data.readByte();
            for (int i = 0; i < count; ++i) {
                String name = data.readUTF();
                String link = data.readUTF();
                RegistryCapes.addCape(name, link, false);
            }
        }
        catch (IOException e) {
            CoFHCore.log.log(Level.SEVERE, "Packet Payload Failure. ID: CJ");
        }
    }

    public static void readAddPacket(DataInputStream data) {
        try {
            String name = data.readUTF();
            String link = data.readUTF();
            RegistryCapes.addCape(name, link, false);
        }
        catch (IOException e) {
            CoFHCore.log.log(Level.SEVERE, "Packet Payload Failure. ID: CA");
        }
    }

    public static void sendJoinPacket(EntityPlayer player) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        int sendCount = 0;
        try {
            int i;
            List<EntityPlayer> players = CoFHCore.proxy.getPlayerList();
            if (players.size() <= 0) {
                return;
            }
            for (i = 0; i < players.size(); ++i) {
                if (RegistryCapes.getPlayerCape(players.get((int)i).field_71092_bJ) == null) continue;
                ++sendCount;
            }
            data.writeByte(MasqueradePacketHandler.Type.CAPE_JOIN.ordinal());
            data.writeByte(sendCount);
            for (i = 0; i < players.size(); ++i) {
                if (RegistryCapes.getPlayerCape(players.get((int)i).field_71092_bJ) == null) continue;
                data.writeUTF(players.get((int)i).field_71092_bJ);
                data.writeUTF(RegistryCapes.getPlayerCape(players.get((int)i).field_71092_bJ));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (sendCount == 0) {
            return;
        }
        PacketDispatcher.sendPacketToPlayer((Packet)Payload.getPacket(MasqueradePacketHandler.packetID, bytes), (Player)((Player)player));
    }

    public static void sendAddPacket(String playerUsername) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            if (RegistryCapes.getPlayerCape(playerUsername) == null) {
                return;
            }
            data.writeByte(MasqueradePacketHandler.Type.CAPE_ADD.ordinal());
            data.writeUTF(playerUsername);
            data.writeUTF(RegistryCapes.getPlayerCape(playerUsername));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)Payload.getPacket(MasqueradePacketHandler.packetID, bytes));
    }

    public static void readRemovePacket(DataInputStream data) {
        try {
            String name = data.readUTF();
            RegistryCapes.removeCape(name, false);
        }
        catch (IOException e) {
            CoFHCore.log.log(Level.SEVERE, "Packet Payload Failure. ID: CR");
        }
    }

    public static void sendRemovePacket(String playerUsername) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeByte(MasqueradePacketHandler.Type.CAPE_REMOVE.ordinal());
            data.writeUTF(playerUsername);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)Payload.getPacket(MasqueradePacketHandler.packetID, bytes));
    }

    public static void registerDefaults() {
        RegistryCapes.addCape("kingLemmingcofh", "https://dl.dropbox.com/u/57416963/Minecraft/Capes/kinglemmingcofh.png", false);
        RegistryCapes.addCape("zeldokavira", "https://dl.dropbox.com/u/27292492/cape/zeldo.png", false);
        RegistryCapes.addCape("jadedcat", "https://dl.dropbox.com/u/57416963/Minecraft/Capes/jadedcat.png", false);
    }

    @Override
    public boolean register(String playerName, String capeURL) {
        return RegistryCapes.addCape(playerName, capeURL, false);
    }
}

