/*
 * Decompiled with CFR 0.152.
 */
package enchiridion.api.pages;

import enchiridion.BookLogHandler;
import enchiridion.api.GuiGuide;
import enchiridion.api.GuideHandler;
import enchiridion.api.XMLHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;

public abstract class PageParser {
    public static RenderBlocks renderer;
    protected static RenderItem itemRenderer;
    protected static final ResourceLocation elements;
    public static HashMap<String, PageParser> parsers;
    public String node;
    protected String bookID;
    protected FontRenderer font;
    protected GuiGuide gui;
    protected boolean left;
    protected int x;
    protected int y;
    protected float size;

    public void init(GuiGuide gui, int x, int y, boolean left) {
        this.bookID = gui.xml;
        this.gui = gui;
        this.left = left;
        this.x = x;
        this.y = y;
        this.font = gui.getFont();
    }

    public void resize(Element xml) {
        this.x += XMLHelper.getAttribAsInteger(xml, "x", 0).intValue();
        this.y += XMLHelper.getAttribAsInteger(xml, "y", 0).intValue();
        this.size = XMLHelper.getAttribAsFloat(xml, "size", Float.valueOf(1.0f)).floatValue();
        this.x = (int)((float)this.x / this.size * 1.0f);
        GL11.glScalef((float)this.size, (float)this.size, (float)this.size);
    }

    public abstract void read(Element var1);

    public abstract void parse();

    public void drawFluidStack(int x, int y, Icon icon, int width, int height) {
        if (icon == null) {
            return;
        }
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), this.gui.getZLevel(), minU, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), this.gui.getZLevel(), minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), this.gui.getZLevel(), minU + (maxU - minU) * (double)width / 16.0, minV);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), this.gui.getZLevel(), minU, minV);
        tessellator.func_78381_a();
    }

    protected void drawItemStack(ItemStack stack, int x, int y) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        try {
            if (renderer == null) {
                renderer = Minecraft.func_71410_x().field_71438_f.field_72776_r;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Minecraft mc;
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            FontRenderer font = null;
            if (stack != null) {
                font = stack.func_77973_b().getFontRenderer(stack);
            }
            if (font == null) {
                font = this.gui.getFont();
            }
            if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)renderer, (TextureManager)(mc = Minecraft.func_71410_x()).func_110434_K(), (ItemStack)stack, (boolean)PageParser.itemRenderer.field_77024_a, (float)PageParser.itemRenderer.field_77023_b, (float)x, (float)y)) {
                itemRenderer.renderItemIntoGUI(font, this.gui.getMC().func_110434_K(), stack, x, y, false);
            }
            GL11.glDisable((int)2896);
        }
        catch (Exception e) {
            try {
                Minecraft mc;
                ArrayList ores = OreDictionary.getOres((Integer)OreDictionary.getOreID((ItemStack)stack));
                ItemStack stack2 = (ItemStack)ores.get(GuideHandler.rand.nextInt(ores.size()));
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
                FontRenderer font = null;
                if (stack2 != null) {
                    font = stack2.func_77973_b().getFontRenderer(stack2);
                }
                if (font == null) {
                    font = this.gui.getFont();
                }
                if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)renderer, (TextureManager)(mc = Minecraft.func_71410_x()).func_110434_K(), (ItemStack)stack2, (boolean)PageParser.itemRenderer.field_77024_a, (float)PageParser.itemRenderer.field_77023_b, (float)x, (float)y)) {
                    itemRenderer.renderItemIntoGUI(font, this.gui.getMC().func_110434_K(), stack2, x, y, false);
                }
            }
            catch (Exception e2) {
                BookLogHandler.log(Level.WARNING, "Rendering failed when trying to render an item!" + stack);
            }
        }
    }

    public static void registerHandler(String xml, PageParser handler) {
        parsers.put(xml, handler);
    }

    static {
        itemRenderer = (RenderItem)RenderManager.field_78727_a.field_78729_o.get(EntityItem.class);
        elements = new ResourceLocation("books", "textures/gui/guide_elements.png");
        parsers = new HashMap();
    }
}

