/*
 * Decompiled with CFR 0.152.
 */
package enchiridion.api;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLHelper {
    public static String getAttribute(Element e, String name) {
        if (e.getAttribute(name) == null) {
            return "";
        }
        return e.getAttribute(name);
    }

    public static Boolean getAttribAsBoolean(Element e, String name) {
        return XMLHelper.getAttribAsBoolean(e, name, false);
    }

    public static Boolean getAttribAsBoolean(Element e, String name, Boolean dft) {
        if (XMLHelper.getAttribute(e, name) == null) {
            return dft;
        }
        return Boolean.parseBoolean(XMLHelper.getAttribute(e, name));
    }

    public static Integer getAttribAsInteger(Element e, String name, Integer dft) {
        String num = XMLHelper.getAttribute(e, name);
        return num.equals("") ? dft : Integer.parseInt(num);
    }

    public static Float getAttribAsFloat(Element e, String name, Float dft) {
        String num = XMLHelper.getAttribute(e, name);
        return Float.valueOf(num.equals("") ? dft.floatValue() : Float.parseFloat(num));
    }

    public static Integer getAttribAsHex(Element e, String name, Integer dft) {
        String num = XMLHelper.getAttribute(e, name);
        return num.equals("") ? dft : Integer.parseInt(num, 16);
    }

    public static String getElement(Element e, String name) {
        if (e.getElementsByTagName(name) == null) {
            return "";
        }
        if (e.getElementsByTagName(name).item(0) == null) {
            return "";
        }
        return e.getElementsByTagName(name).item(0).getTextContent();
    }

    public static Boolean getElementAsBoolean(Element e, String name) {
        return XMLHelper.getElementAsBoolean(e, name, false);
    }

    public static Boolean getElementAsBoolean(Element e, String name, Boolean dft) {
        if (XMLHelper.getElement(e, name) == null) {
            return dft;
        }
        return Boolean.parseBoolean(XMLHelper.getElement(e, name));
    }

    public static Integer getElementAsInteger(Element e, String name, Integer dft) {
        String num = XMLHelper.getElement(e, name);
        return num.equals("") ? dft : Integer.parseInt(num);
    }

    public static Float getElementAsFloat(Element e, String name, Float dft) {
        String num = XMLHelper.getElement(e, name);
        return Float.valueOf(num.equals("") ? dft.floatValue() : Float.parseFloat(num));
    }

    public static Integer getElementAsHex(Element e, String name, Integer dft) {
        String num = XMLHelper.getElement(e, name);
        return num.equals("") ? dft : Integer.parseInt(num, 16);
    }

    public static Element getNode(Element e, String name) {
        Node n = e.getElementsByTagName(name).item(0);
        if (n == null) {
            return e;
        }
        if (n.getNodeType() == 1) {
            return (Element)n;
        }
        return e;
    }

    public static String getSelf(Element e) {
        return e.getTextContent();
    }
}

