/*
 * Decompiled with CFR 0.152.
 */
package enchiridion.api;

import cpw.mods.fml.common.FMLLog;
import enchiridion.api.BookReader;
import enchiridion.api.GuiGuide;
import enchiridion.api.IBookReader;
import enchiridion.api.pages.PageCrafting;
import enchiridion.api.pages.PageImage;
import enchiridion.api.pages.PageParagraph;
import enchiridion.api.pages.PageParser;
import enchiridion.api.pages.PageStack;
import enchiridion.api.pages.PageText;
import enchiridion.api.pages.PageUnderline;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.NodeList;

public class GuideHandler {
    public static boolean DEBUG_ENABLED;
    private static final HashMap<String, String> guides;
    private static final HashMap<String, IBookReader> handlers;
    private static final HashMap<String, Object> guis;
    public static final Random rand;

    public static HashMap<String, String> getGuides() {
        return guides;
    }

    public static HashMap<String, Object> getGuis() {
        return guis;
    }

    public static void registerBookReader(String xml, IBookReader reader) {
        if (handlers.containsKey(xml)) {
            FMLLog.getLogger().log(Level.WARNING, "Enchiridion API: Overwriting the handler for " + xml);
        }
        handlers.put(xml, reader);
    }

    public static void registerModBook(ItemStack stack, String modAssets) {
        String key = stack.func_77977_a().substring(5) + ":" + stack.func_77960_j();
        guides.put(key, modAssets);
    }

    public static void registerBook(ItemStack stack, String modAssets, String book, Integer color) {
        String key = stack.func_77977_a().substring(5) + ":" + stack.func_77960_j();
        guides.put(key, modAssets + ":" + book);
        guis.put(key, (Object)new GuiGuide(color, modAssets + ":" + book));
    }

    public static void registerBook(ItemStack stack, String modAssets, String book, String background, Integer color) {
        String key = stack.func_77977_a().substring(5) + ":" + stack.func_77960_j();
        guides.put(key, modAssets + ":" + book);
        guis.put(key, (Object)new GuiGuide(color, modAssets + ":" + book));
        GuiGuide.cover_left_cache.put(key, new ResourceLocation(modAssets, background));
        GuiGuide.cover_right_cache.put(key, new ResourceLocation(modAssets, background));
        GuiGuide.page_left_cache.put(key, new ResourceLocation(modAssets, background));
        GuiGuide.page_right_cache.put(key, new ResourceLocation(modAssets, background));
    }

    public static void registerPageHandler(String xml, PageParser handler) {
        PageParser.registerHandler(xml, handler);
    }

    public static Object getGui(ItemStack stack) {
        String key = stack.func_77977_a().substring(5) + ":" + stack.func_77960_j();
        return handlers.get(guides.get(key)).getGui(stack, key);
    }

    public static NodeList getDocument(String xml) {
        if (DEBUG_ENABLED) {
            try {
                if (handlers.get(xml) == null) {
                    handlers.put(xml, handlers.get("DEFAULT"));
                }
                return handlers.get(xml).getDocumentDebugMode(xml).getElementsByTagName("page");
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (handlers.get(xml) == null) {
            handlers.put(xml, handlers.get("DEFAULT"));
        }
        return handlers.get(xml).getDocument(xml).getElementsByTagName("page");
    }

    static {
        guides = new HashMap();
        handlers = new HashMap();
        guis = new HashMap();
        rand = new Random();
        GuideHandler.registerBookReader("DEFAULT", new BookReader());
        GuideHandler.registerPageHandler("crafting", new PageCrafting());
        GuideHandler.registerPageHandler("paragraph", new PageParagraph());
        GuideHandler.registerPageHandler("img", new PageImage());
        GuideHandler.registerPageHandler("stack", new PageStack());
        GuideHandler.registerPageHandler("hr", new PageUnderline());
        GuideHandler.registerPageHandler("text", new PageText());
    }
}

