/*
 * Decompiled with CFR 0.152.
 */
package enchiridion.api;

import enchiridion.api.DisplayRegistry;
import enchiridion.api.GuideHandler;
import enchiridion.api.pages.PageParser;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GuiGuide
extends GuiScreen {
    protected int guiTick = 0;
    protected int mouseXLeft = 0;
    protected int mouseXRight = 0;
    public int mouseY = 0;
    public static final HashMap<String, ResourceLocation> cover_left_cache = new HashMap();
    public static final HashMap<String, ResourceLocation> cover_right_cache = new HashMap();
    public static final HashMap<String, ResourceLocation> page_left_cache = new HashMap();
    public static final HashMap<String, ResourceLocation> page_right_cache = new HashMap();
    private static ResourceLocation cover_left;
    private static ResourceLocation cover_right;
    private static ResourceLocation page_left;
    private static ResourceLocation page_right;
    public static HashMap lastPage;
    protected float red;
    protected float green;
    protected float blue;
    protected int leftX = 212;
    protected int rightX = 218;
    protected int ySize = 217;
    protected int maxPage;
    private int hex;
    public String xml;
    public static int currentPage;
    public NodeList guide;
    public Node page1;
    public Node page2;

    public FontRenderer getFont() {
        return this.field_73886_k;
    }

    public Minecraft getMC() {
        return this.field_73882_e;
    }

    public void setZLevel(float f) {
        this.field_73735_i = f;
    }

    public double getZLevel() {
        return this.field_73735_i;
    }

    public GuiGuide(int hex, String xml) {
        this.hex = hex;
        this.xml = xml;
        if (cover_left_cache.get(xml) == null) {
            cover_left_cache.put(xml, new ResourceLocation("books", "textures/gui/guide_cover_left.png"));
        }
        if (cover_right_cache.get(xml) == null) {
            cover_right_cache.put(xml, new ResourceLocation("books", "textures/gui/guide_cover_right.png"));
        }
        if (page_left_cache.get(xml) == null) {
            page_left_cache.put(xml, new ResourceLocation("books", "textures/gui/guide_page_left.png"));
        }
        if (page_right_cache.get(xml) == null) {
            page_right_cache.put(xml, new ResourceLocation("books", "textures/gui/guide_page_right.png"));
        }
    }

    public GuiGuide(int hex, String bg, String xml) {
        this(hex, xml);
        if (cover_left_cache.get(xml) == null) {
            cover_left_cache.put(xml, new ResourceLocation(bg));
        }
        if (cover_right_cache.get(xml) == null) {
            cover_right_cache.put(xml, new ResourceLocation(bg));
        }
        if (page_left_cache.get(xml) == null) {
            page_left_cache.put(xml, new ResourceLocation(bg));
        }
        if (page_right_cache.get(xml) == null) {
            page_right_cache.put(xml, new ResourceLocation(bg));
        }
    }

    public void func_73874_b() {
        lastPage.put(this.xml, currentPage);
    }

    public void func_73866_w_() {
        currentPage = lastPage.containsKey(this.xml) ? (Integer)lastPage.get(this.xml) : 0;
        cover_left = cover_left_cache.get(this.xml);
        cover_right = cover_right_cache.get(this.xml);
        page_left = page_left_cache.get(this.xml);
        page_right = page_right_cache.get(this.xml);
        this.red = (float)(this.hex >> 16 & 0xFF) / 255.0f;
        this.green = (float)(this.hex >> 8 & 0xFF) / 255.0f;
        this.blue = (float)(this.hex & 0xFF) / 255.0f;
        this.guide = GuideHandler.getDocument(this.xml);
        this.maxPage = this.guide.getLength();
        this.page1 = this.guide.item(currentPage);
        if (this.guide.item(currentPage) != null) {
            this.page2 = this.guide.item(currentPage + 1);
        }
    }

    public void draw(GuiGuide gui, Node node, int x, int y, boolean left) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 1) {
            Element e = (Element)node;
            for (Map.Entry<String, PageParser> page : PageParser.parsers.entrySet()) {
                if (e.getElementsByTagName(page.getKey()) == null) continue;
                NodeList list = e.getElementsByTagName(page.getKey());
                for (int i = 0; i < list.getLength(); ++i) {
                    Node n = list.item(i);
                    if (n.getNodeType() != 1) continue;
                    PageParser parser = page.getValue();
                    parser.init(gui, x, y, left);
                    parser.read((Element)n);
                    GL11.glPushMatrix();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    parser.resize((Element)n);
                    parser.parse();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    private void drawPage(Node page, int x, int y, boolean left) {
        this.draw(this, page, x, y + 9, left);
    }

    public void drawLeftPage(int x, int y) {
        GL11.glColor4f((float)this.red, (float)this.green, (float)this.blue, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(cover_left);
        this.func_73729_b(x - 9, y, 35, 0, this.leftX + 9, this.ySize);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(page_left);
        this.func_73729_b(x, y, 44, 0, this.leftX, this.ySize);
        this.func_73729_b(x + 21, y + 200, 0, 246, 18, 10);
        if (this.mouseXRight >= -192 && this.mouseXRight <= -174 && this.mouseY >= 100 && this.mouseY <= 110) {
            this.func_73729_b(x + 21, y + 200, 23, 246, 18, 10);
        }
        this.drawPage(this.page1, x + 24, y + 15, true);
        this.field_73882_e.field_71466_p.func_78276_b("\u00a78\u00a7l" + (currentPage + 1) + "/" + this.guide.getLength(), x + 42, y + 202, 0);
    }

    public void drawRightPage(int x, int y) {
        GL11.glColor4f((float)this.red, (float)this.green, (float)this.blue, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(cover_right);
        this.func_73729_b(x, y, 0, 0, this.rightX + 9, this.ySize);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(page_right);
        this.func_73729_b(x, y, 0, 0, this.rightX, this.ySize);
        this.func_73729_b(x + 175, y + 200, 0, 246, 18, 10);
        if (this.mouseXRight >= 175 && this.mouseXRight <= 192 && this.mouseY >= 100 && this.mouseY <= 110) {
            this.func_73729_b(x + 175, y + 200, 23, 246, 18, 10);
        }
        this.drawPage(this.page2, x + 6, y + 15, false);
        if (this.guide.getLength() % 2 == 0 || currentPage < this.guide.getLength() - 1) {
            String name = currentPage + 2 + "/" + this.guide.getLength();
            int xBonus = 0;
            if (name.length() < 4) {
                xBonus = 28;
            } else if (name.length() < 5) {
                xBonus = 20;
            } else if (name.length() < 6) {
                xBonus = 15;
            } else if (name.length() < 7) {
                xBonus = 8;
            } else if (name.length() < 8) {
                xBonus = 0;
            }
            this.field_73882_e.field_71466_p.func_78276_b("\u00a78\u00a7l" + name, x + 124 + xBonus, y + 202, 0);
        }
    }

    public void func_73863_a(int i, int j, float f) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.field_73880_f / 2;
        int y = 8;
        this.drawLeftPage(x - 212, y);
        this.drawRightPage(x, y);
        ++this.guiTick;
        if (this.guiTick % 96 == 0) {
            DisplayRegistry.updateIcons();
        }
        super.func_73863_a(i, j, f);
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        boolean clicked = false;
        if (this.mouseXRight >= -192 && this.mouseXRight <= -174 && this.mouseY >= 100 && this.mouseY <= 110) {
            clicked = true;
            currentPage -= 2;
        }
        if (this.mouseXRight >= 175 && this.mouseXRight <= 192 && this.mouseY >= 100 && this.mouseY <= 110) {
            clicked = true;
            currentPage += 2;
        }
        if (clicked) {
            if (this.guide.getLength() % 2 == 0) {
                if (currentPage < 0) {
                    currentPage = this.guide.getLength() - 2;
                } else if (currentPage >= this.guide.getLength()) {
                    currentPage = 0;
                }
            } else if (currentPage < 0) {
                currentPage = this.guide.getLength() - 1;
            } else if (currentPage > this.guide.getLength()) {
                currentPage = 0;
            }
            this.page1 = this.guide.item(currentPage);
            this.page2 = this.guide.item(currentPage + 1);
        }
    }

    public void func_73867_d() {
        int x = Mouse.getEventX() * this.field_73880_f / this.field_73882_e.field_71443_c;
        int y = this.field_73881_g - Mouse.getEventY() * this.field_73881_g / this.field_73882_e.field_71440_d - 1;
        this.mouseXRight = x - this.field_73880_f / 2;
        this.mouseY = y - this.ySize / 2;
        super.func_73867_d();
    }

    static {
        lastPage = new HashMap();
    }
}

