/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.HarvestMode;
import powercrystals.minefactoryreloaded.core.IHarvestManager;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.TreeHarvestManager;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiHarvester;
import powercrystals.minefactoryreloaded.gui.container.ContainerHarvester;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityHarvester
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private Map<String, Boolean> _settings;
    private Map<String, Boolean> _immutableSettings;
    private Random _rand;
    private IHarvestManager _treeManager;
    private BlockPosition _lastTree;

    public TileEntityHarvester() {
        super(Machine.Harvester);
        this._areaManager = new HarvestAreaManager(this, 1, 0, 0);
        this.setManageSolids(true);
        this._settings = new HashMap<String, Boolean>();
        this._settings.put("silkTouch", false);
        this._settings.put("harvestSmallMushrooms", false);
        this._settings.put("playSounds", MFRConfig.playSounds.getBoolean(true));
        this._immutableSettings = Collections.unmodifiableMap(this._settings);
        this._rand = new Random();
        this.setCanRotate(true);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this._treeManager != null) {
            this._treeManager.free();
        }
        this._lastTree = null;
    }

    @Override
    public void func_70312_q() {
        super.func_70312_q();
        if (!this.field_70331_k.field_72995_K) {
            if (this._treeManager != null) {
                this._treeManager.setWorld(this.field_70331_k);
            } else {
                this._treeManager = new TreeHarvestManager(this.field_70331_k, new Area(new BlockPosition((TileEntity)this), 0, 0, 0), HarvestMode.FruitTree);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiHarvester(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerHarvester getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerHarvester(this, inventoryPlayer);
    }

    public Map<String, Boolean> getSettings() {
        return this._settings;
    }

    public Map<String, Boolean> getImmutableSettings() {
        return this._immutableSettings;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 5;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[0]);
    }

    @Override
    public boolean activateMachine() {
        BlockPosition blockPosition = this.getNextHarvest();
        if (blockPosition == null) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        this._settings.put("playSounds", MFRConfig.playSounds.getBoolean(true));
        int n = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        int n2 = this.field_70331_k.func_72805_g(blockPosition.x, blockPosition.y, blockPosition.z);
        IFactoryHarvestable iFactoryHarvestable = MFRRegistry.getHarvestables().get(new Integer(n));
        iFactoryHarvestable.preHarvest(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z);
        List<ItemStack> list = iFactoryHarvestable.getDrops(this.field_70331_k, this._rand, this.getImmutableSettings(), blockPosition.x, blockPosition.y, blockPosition.z);
        if (iFactoryHarvestable.breakBlock()) {
            if (!this.field_70331_k.func_72832_d(blockPosition.x, blockPosition.y, blockPosition.z, 0, 0, 2)) {
                return false;
            }
            if (this._settings.get("playSounds").booleanValue()) {
                this.field_70331_k.func_72889_a(null, 2001, blockPosition.x, blockPosition.y, blockPosition.z, n + (n2 << 12));
            }
        }
        this.doDrop(list);
        iFactoryHarvestable.postHarvest(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z);
        this._tanks[0].fill(FluidRegistry.getFluidStack((String)"sludge", (int)10), true);
        return true;
    }

    private BlockPosition getNextHarvest() {
        if (!this._treeManager.getIsDone()) {
            return this.getNextTreeSegment(this._lastTree, false);
        }
        BlockPosition blockPosition = this._areaManager.getNextBlock();
        int n = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (!MFRRegistry.getHarvestables().containsKey(new Integer(n))) {
            this._lastTree = null;
            return null;
        }
        IFactoryHarvestable iFactoryHarvestable = MFRRegistry.getHarvestables().get(new Integer(n));
        if (iFactoryHarvestable.canBeHarvested(this.field_70331_k, this.getImmutableSettings(), blockPosition.x, blockPosition.y, blockPosition.z)) {
            HarvestType harvestType = iFactoryHarvestable.getHarvestType();
            switch (harvestType) {
                case Column: 
                case LeaveBottom: {
                    blockPosition = this.getNextVertical(blockPosition.x, blockPosition.y, blockPosition.z, harvestType == HarvestType.Column ? 0 : 1);
                }
                default: {
                    this._lastTree = null;
                    return blockPosition;
                }
                case Tree: 
                case TreeFlipped: 
            }
            BlockPosition blockPosition2 = this.getNextTreeSegment(blockPosition, harvestType == HarvestType.TreeFlipped);
            if (blockPosition2 != null) {
                this._areaManager.rewindBlock();
            }
            return blockPosition2;
        }
        this._lastTree = null;
        return null;
    }

    private BlockPosition getNextVertical(int n, int n2, int n3, int n4) {
        int n5 = -1;
        int n6 = MFRConfig.verticalHarvestSearchMaxVertical.getInt();
        int n7 = n4;
        while (n7 < n6) {
            int n8 = this.field_70331_k.func_72798_a(n, n2 + n7, n3);
            if (!MFRRegistry.getHarvestables().containsKey(new Integer(n8)) || !MFRRegistry.getHarvestables().get(new Integer(n8)).canBeHarvested(this.field_70331_k, this.getImmutableSettings(), n, n2 + n7, n3)) break;
            n5 = n7++;
        }
        if (n5 < 0) {
            return null;
        }
        return new BlockPosition(n, n2 + n5, n3);
    }

    private BlockPosition getNextTreeSegment(BlockPosition blockPosition, boolean bl) {
        Object object;
        if (!blockPosition.equals((Object)this._lastTree) || this._treeManager.getIsDone()) {
            int n = 0;
            int n2 = MFRConfig.treeSearchMaxVertical.getInt();
            if (bl) {
                n = n2;
                n2 = 0;
            }
            this._lastTree = new BlockPosition(blockPosition);
            object = new Area(this._lastTree, MFRConfig.treeSearchMaxHorizontal.getInt(), n, n2);
            this._treeManager.reset(this.field_70331_k, (Area)object, bl ? HarvestMode.HarvestTreeInverted : HarvestMode.HarvestTree);
        }
        Map<Integer, IFactoryHarvestable> map = MFRRegistry.getHarvestables();
        while (!this._treeManager.getIsDone()) {
            HarvestType harvestType;
            BlockPosition blockPosition2 = this._treeManager.getNextBlock();
            Integer n = this.field_70331_k.func_72798_a(blockPosition2.x, blockPosition2.y, blockPosition2.z);
            if (map.containsKey(n) && (harvestType = (object = map.get(n)).getHarvestType()) == HarvestType.Tree | harvestType == HarvestType.TreeFlipped | harvestType == HarvestType.TreeLeaf && object.canBeHarvested(this.field_70331_k, this.getImmutableSettings(), blockPosition2.x, blockPosition2.y, blockPosition2.z)) {
                return blockPosition2;
            }
            this._treeManager.moveNext();
        }
        return null;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
            if (fluidTank.getFluidAmount() <= 0) continue;
            return fluidTank.drain(n, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (!fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.drain(fluidStack.amount, bl);
            }
        }
        return null;
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(4000)};
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        for (Map.Entry<String, Boolean> entry : this._settings.entrySet()) {
            nBTTagCompound2.func_74774_a(entry.getKey(), (byte)(entry.getValue() != false ? 1 : 0));
        }
        nBTTagCompound.func_74782_a("harvesterSettings", (NBTBase)nBTTagCompound2);
        this._treeManager.writeToNBT(nBTTagCompound);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagCompound.func_74781_a("harvesterSettings");
        if (nBTTagCompound2 != null) {
            for (String string : this._settings.keySet()) {
                byte by = nBTTagCompound2.func_74771_c(string);
                if (by != 1) continue;
                this._settings.put(string, true);
            }
        }
        if (this._treeManager != null) {
            this._treeManager.free();
        }
        this._treeManager = new TreeHarvestManager(nBTTagCompound);
        if (!this._treeManager.getIsDone()) {
            this._lastTree = this._treeManager.getOrigin();
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }
}

