/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiAutoAnvil;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerAutoAnvil;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityAutoAnvil
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private float maximumCost;
    private int stackSizeToBeUsedInRepair;
    private boolean repairOnly;
    private ItemStack _output;

    public TileEntityAutoAnvil() {
        super(Machine.AutoAnvil);
        this.setManageSolids(true);
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (itemStack == null) {
            return false;
        }
        if (this.repairOnly) {
            if (n == 0) {
                return Item.field_77698_e[itemStack.field_77993_c].isRepairable();
            }
            if (n == 1 && this._inventory[0] != null && Item.field_77698_e[itemStack.field_77993_c].isRepairable()) {
                return this._inventory[0].field_77993_c == itemStack.field_77993_c;
            }
            return false;
        }
        if (n == 0) {
            return itemStack.func_77984_f() || itemStack.field_77993_c == Item.field_92105_bW.field_77779_bT;
        }
        if (n == 1 && this._inventory[0] != null) {
            if (itemStack.field_77993_c == Item.field_92105_bW.field_77779_bT && Item.field_92105_bW.func_92110_g(itemStack).func_74745_c() > 0) {
                return true;
            }
            return itemStack.field_77993_c == this._inventory[0].field_77993_c && itemStack.func_77984_f() || this._inventory[0].func_77973_b().func_82789_a(this._inventory[0], itemStack);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 2;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiAutoAnvil(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerAutoAnvil(this, inventoryPlayer);
    }

    @Override
    protected boolean activateMachine() {
        if (this._output == null || this._inventory[2] != null) {
            return false;
        }
        if (this.repairOnly) {
            if (this._inventory[0] != null && this._inventory[1] != null && this._inventory[0].field_77993_c == this._inventory[1].field_77993_c && Item.field_77698_e[this._inventory[0].field_77993_c].isRepairable()) {
                this.setWorkDone(this.getWorkDone() + 1);
                if (this.getWorkDone() >= this.getWorkMax()) {
                    this._inventory[0] = null;
                    this._inventory[1] = null;
                    this._inventory[2] = this._output;
                    this.setWorkDone(0);
                    this._output = null;
                }
                return true;
            }
            return false;
        }
        if (this.drain(this._tanks[0], 4, false) != 4) {
            return false;
        }
        if (this.stackSizeToBeUsedInRepair > 0 && (this._inventory[1] == null || this._inventory[1].field_77994_a < this.stackSizeToBeUsedInRepair)) {
            return false;
        }
        this.drain(this._tanks[0], 4, true);
        this.setWorkDone(this.getWorkDone() + 1);
        if (this.getWorkDone() >= this.getWorkMax()) {
            this._inventory[0] = null;
            this._inventory[2] = this._output;
            if (this.stackSizeToBeUsedInRepair > 0 && this._inventory[1].field_77994_a > this.stackSizeToBeUsedInRepair) {
                this._inventory[1].field_77994_a -= this.stackSizeToBeUsedInRepair;
            } else {
                this._inventory[1] = null;
            }
            this.setWorkDone(0);
            this._output = null;
        }
        return true;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        super.onFactoryInventoryChanged();
        this._output = this.getAnvilOutput();
        this.setWorkDone(0);
    }

    private ItemStack getAnvilOutput() {
        int n;
        int n2;
        ItemStack itemStack = this._inventory[0];
        this.maximumCost = 0.0f;
        int n3 = 0;
        if (itemStack == null) {
            return null;
        }
        if (this.repairOnly) {
            this.stackSizeToBeUsedInRepair = 0;
            ItemStack itemStack2 = this._inventory[1];
            Item item = Item.field_77698_e[itemStack.field_77993_c];
            if (itemStack2 != null && item.isRepairable() && itemStack.field_77993_c == itemStack2.field_77993_c) {
                int n4 = item.func_77612_l();
                int n5 = itemStack.func_77952_i();
                int n6 = itemStack2.func_77952_i();
                int n7 = n4 - n5 + (n4 - n6) + n4 * 5 / 100;
                int n8 = Math.max(n4 - n7, 0);
                this.maximumCost = (float)((n5 + n6) / 2 - n8) / 100.0f;
                return new ItemStack(itemStack.field_77993_c, 1, n8);
            }
            return null;
        }
        ItemStack itemStack3 = itemStack.func_77946_l();
        ItemStack itemStack4 = this._inventory[1];
        Map map = EnchantmentHelper.func_82781_a((ItemStack)itemStack3);
        boolean bl = false;
        int n9 = itemStack3.func_82838_A() + (itemStack4 == null ? 0 : itemStack4.func_82838_A());
        this.stackSizeToBeUsedInRepair = 0;
        if (itemStack4 != null) {
            boolean bl2 = bl = itemStack4.field_77993_c == Item.field_92105_bW.field_77779_bT && Item.field_92105_bW.func_92110_g(itemStack4).func_74745_c() > 0;
            if (itemStack3.func_77984_f() && Item.field_77698_e[itemStack3.field_77993_c].func_82789_a(itemStack3, itemStack4)) {
                int n10;
                int n11 = Math.min(itemStack3.func_77952_i(), itemStack3.func_77958_k() / 4);
                if (n11 <= 0) {
                    return null;
                }
                for (n10 = 0; n11 > 0 && n10 < itemStack4.field_77994_a; ++n10) {
                    itemStack3.func_77964_b(itemStack3.func_77952_i() - n11);
                    n3 += Math.max(1, n11 / 100) + map.size();
                    n11 = Math.min(itemStack3.func_77952_i(), itemStack3.func_77958_k() / 4);
                }
                this.stackSizeToBeUsedInRepair = n10;
            } else {
                if (!(bl || itemStack3.field_77993_c == itemStack4.field_77993_c && itemStack3.func_77984_f())) {
                    return null;
                }
                if (itemStack3.func_77984_f() && !bl) {
                    int n12 = itemStack3.func_77958_k() - itemStack3.func_77952_i();
                    int n13 = itemStack4.func_77958_k() - itemStack4.func_77952_i();
                    int n14 = n13 + itemStack3.func_77958_k() * 12 / 100;
                    int n15 = n12 + n14;
                    n2 = itemStack3.func_77958_k() - n15;
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n2 < itemStack3.func_77960_j()) {
                        itemStack3.func_77964_b(n2);
                        n3 += Math.max(1, n14 / 100);
                    }
                }
                Map map2 = EnchantmentHelper.func_82781_a((ItemStack)itemStack4);
                for (Integer n16 : map2.keySet()) {
                    Enchantment enchantment = Enchantment.field_77331_b[n16];
                    n2 = map.containsKey(n16) ? (Integer)map.get(n16) : 0;
                    n = (Integer)map2.get(n16);
                    int n17 = n2 == n ? ++n : Math.max(n, n2);
                    n = n17;
                    int n18 = n - n2;
                    boolean bl3 = enchantment.func_92089_a(itemStack3);
                    if (itemStack3.field_77993_c == ItemEnchantedBook.field_92105_bW.field_77779_bT) {
                        bl3 = true;
                    }
                    for (Integer n19 : map.keySet()) {
                        if (n19 == n16 || enchantment.func_77326_a(Enchantment.field_77331_b[n19])) continue;
                        bl3 = false;
                        n3 += n18;
                    }
                    if (!bl3) continue;
                    if (n17 > enchantment.func_77325_b()) {
                        n17 = enchantment.func_77325_b();
                    }
                    map.put(Integer.valueOf(n16), n17);
                    int n20 = 0;
                    switch (enchantment.func_77324_c()) {
                        case 1: {
                            n20 = 8;
                            break;
                        }
                        case 2: {
                            n20 = 4;
                        }
                        default: {
                            break;
                        }
                        case 5: {
                            n20 = 2;
                            break;
                        }
                        case 10: {
                            n20 = 1;
                        }
                    }
                    if (bl) {
                        n20 = Math.max(1, n20 / 2);
                    }
                    n3 += n20 * n18;
                }
            }
        }
        int n21 = 0;
        for (Integer n22 : map.keySet()) {
            Enchantment enchantment = Enchantment.field_77331_b[n22];
            n2 = (Integer)map.get(n22);
            n = 0;
            ++n21;
            switch (enchantment.func_77324_c()) {
                case 1: {
                    n = 8;
                    break;
                }
                case 2: {
                    n = 4;
                }
                default: {
                    break;
                }
                case 5: {
                    n = 2;
                    break;
                }
                case 10: {
                    n = 1;
                }
            }
            if (bl) {
                n = Math.max(1, n / 2);
            }
            n9 += n21 + n2 * n;
        }
        if (bl) {
            n9 = Math.max(1, n9 / 2);
        }
        if (bl && !Item.field_77698_e[itemStack3.field_77993_c].isBookEnchantable(itemStack3, itemStack4)) {
            itemStack3 = null;
        }
        this.maximumCost = n9 + n3;
        if (n3 <= 0) {
            itemStack3 = null;
        }
        if (itemStack3 != null) {
            EnchantmentHelper.func_82782_a((Map)map, (ItemStack)itemStack3);
        }
        return itemStack3;
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("repairOnly", this.repairOnly);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this.repairOnly = nBTTagCompound.func_74767_n("repairOnly");
    }

    public boolean getRepairOnly() {
        return this.repairOnly;
    }

    public void setRepairOnly(boolean bl) {
        this.repairOnly = bl;
        this.onFactoryInventoryChanged();
    }

    @Override
    public int getWorkMax() {
        return (int)(100.0f * this.maximumCost);
    }

    @Override
    public int getIdleTicksMax() {
        return 1;
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null && FluidRegistry.getFluid((String)"mobessence").equals(fluidStack.getFluid())) {
            return this._tanks[0].fill(fluidStack, bl);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(4000)};
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

