/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.input.Keyboard;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.IToolHammer;
import powercrystals.minefactoryreloaded.api.IToolHammerAdvanced;

public class MFRUtil {
    public static final List<ForgeDirection> VALID_DIRECTIONS = Arrays.asList(ForgeDirection.VALID_DIRECTIONS);

    @SideOnly(value=Side.CLIENT)
    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isCtrlKeyDown() {
        if (Minecraft.field_142025_a) {
            return Keyboard.isKeyDown((int)219) || Keyboard.isKeyDown((int)220);
        }
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static String shiftForInfo() {
        return EnumChatFormatting.GRAY + MFRUtil.localize("tip.info.mfr.holdShift1", true) + " " + EnumChatFormatting.YELLOW + EnumChatFormatting.ITALIC + MFRUtil.localize("tip.info.mfr.holdShift2", true) + " " + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + MFRUtil.localize("tip.info.mfr.holdShift3", true) + EnumChatFormatting.RESET;
    }

    public static String localize(String string) {
        return MFRUtil.localize(string + ".name", false);
    }

    public static String localize(String string, String string2) {
        return MFRUtil.localize(string + string2 + ".name", true, string2);
    }

    public static String localize(String string, boolean bl) {
        return MFRUtil.localize(string, bl, string);
    }

    public static String localize(String string, boolean bl, String string2) {
        if (bl && !StatCollector.func_94522_b((String)string)) {
            return string2;
        }
        return StatCollector.func_74838_a((String)string);
    }

    public static boolean isHoldingUsableTool(EntityPlayer entityPlayer, int n, int n2, int n3) {
        if (entityPlayer.field_71071_by.func_70448_g() == null) {
            return false;
        }
        Item item = Item.field_77698_e[entityPlayer.field_71071_by.func_70448_g().field_77993_c];
        if (item instanceof IToolHammerAdvanced) {
            return ((IToolHammerAdvanced)item).isActive(entityPlayer.field_71071_by.func_70448_g());
        }
        if (item instanceof IToolHammer) {
            return true;
        }
        if (item instanceof IToolWrench) {
            return ((IToolWrench)item).canWrench(entityPlayer, n, n2, n3);
        }
        return false;
    }

    public static boolean isHoldingHammer(EntityPlayer entityPlayer) {
        if (entityPlayer.field_71071_by.func_70448_g() == null) {
            return false;
        }
        Item item = Item.field_77698_e[entityPlayer.field_71071_by.func_70448_g().field_77993_c];
        if (item instanceof IToolHammerAdvanced) {
            return ((IToolHammerAdvanced)item).isActive(entityPlayer.field_71071_by.func_70448_g());
        }
        return item instanceof IToolHammer;
    }

    public static boolean isHolding(EntityPlayer entityPlayer, Class<? extends Item> clazz) {
        if (entityPlayer.field_71071_by.func_70448_g() == null) {
            return false;
        }
        Item item = Item.field_77698_e[entityPlayer.field_71071_by.func_70448_g().field_77993_c];
        return item != null && clazz.isAssignableFrom(item.getClass());
    }

    public static <V extends Entity, T extends Class<V>> V prepareMob(T t, World world) {
        try {
            Entity entity = (Entity)t.getConstructor(World.class).newInstance(world);
            return (V)entity;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ForgeDirection[] directionsWithoutConveyors(World world, int n, int n2, int n3) {
        ArrayList<ForgeDirection> arrayList = new ArrayList<ForgeDirection>();
        int n4 = MineFactoryReloadedCore.conveyorBlock.field_71990_ca;
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            if (n4 == world.func_72798_a(n + forgeDirection.offsetX, n2 + forgeDirection.offsetY, n3 + forgeDirection.offsetZ)) continue;
            arrayList.add(forgeDirection);
        }
        return arrayList.toArray(new ForgeDirection[arrayList.size()]);
    }

    public static NBTTagCompound writeModifierToNBT(String string, AttributeModifier attributeModifier) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74778_a("AttributeName", string);
        nBTTagCompound.func_74778_a("Name", attributeModifier.func_111166_b());
        nBTTagCompound.func_74780_a("Amount", attributeModifier.func_111164_d());
        nBTTagCompound.func_74768_a("Operation", attributeModifier.func_111169_c());
        nBTTagCompound.func_74772_a("UUIDMost", attributeModifier.func_111167_a().getMostSignificantBits());
        nBTTagCompound.func_74772_a("UUIDLeast", attributeModifier.func_111167_a().getLeastSignificantBits());
        return nBTTagCompound;
    }
}

